/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */ 

package org.netbeans.microedition.testme.svg.tests;

import java.util.Timer;
import java.util.TimerTask;
import org.netbeans.microedition.testme.svg.support.SVGTestMIDlet;
import org.netbeans.microedition.testme.svg.support.SVGUtils;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGAnimationElement;

/**
 * The J2ME test suite for known issue related to a start of SVG animation with indefinite
 * begin time from a midlet.
 * @author  PavelBenes
 * @version
 */
public class AnimationStartTests extends SVGTestMIDlet {
    private static final int WHITE    = 0x00FFFFFF;

    public AnimationStartTests() throws Exception {
        super("Animation start unit test(s)", 1, "animationRestart.svg", true);
    }
    
    protected void runTest(int testNumber) throws Throwable {
        switch(testNumber) {
            case 1: testAnimationStart(); break;
        }
    }    
    
    /**
     * This test verifies if a midlet could start an animation with indefined begin time.
     * A test animation smoothly moves a red box from [30, 30] to [50, 50] in two seconds.
     * On some devices however the movement is not smooth and box box position is changed
     * abruptly at the end of the interval.
     */    
    protected void testAnimationStart() {
        log("Starting the animation");
        startAnimation();
        
        // after 1.75 second when the box should be near its final destination check the
        // initial location. If the box is still there, it is an error.
        new Timer().schedule( new TimerTask() {
            public void run() {
                log("Verifying the box position");
                int color = SVGUtils.getPixelColor(takeScreenshot(), 35, 35);
                asynchronousTestCompleted( (color & SVGUtils.RGB_MASK) == WHITE, "The box should be elsewhere.");
            }
        }, 1750);
    }
    
    private void startAnimation() {
        getSVGAnimator().invokeLater(new Runnable() {
            public void run() {
                Document doc = getSVGImage().getDocument();
                SVGAnimationElement el = (SVGAnimationElement)doc.getElementById("animation");
                el.beginElementAt(0.0f);
            }
        });
    }
}
