<%@page contentType="text/html"%>
<%@page pageEncoding="UTF-8"%>
<%@ page import="org.netbeans.lib.uihandler.InputGesture" %>
<%@ page import="java.util.Map" %>
<%@ page import="java.util.Set" %>
<%@ taglib uri="/WEB-INF/chart-tag.tld" prefix="chart" %>
<%@ taglib uri="/WEB-INF/statistics.tld" prefix="ui" %>

<head>
<jsp:include page="../template/header.jsp"/>
<ui:useStatistic name="Gestures"/>

<a href="http://www.netbeans.org/index.html">HOME</a> 
/ 
<a href="http://www.netbeans.org/community/index.html">Community</a>
/
<a href="index.jsp">Analytics</a>
/
Graph
/
Gestures

</div><td class="valign-top b-right full-width">

    <div class="f-page-cell bg-sky" >
        <h2>Are people using mouse or keyboard?</h2>
        
        <p>
            Most of the actions in NetBeans can be invoked either though
            menu or toolbar or keyboard. Some people prefer to use keyboard,
            others stick to mouse usage. This graphs shall give an overview
            of what people do and allow you to compare your own statistics
            to statistics of other people.
        </p>
    </div>
    
    <table width="100%">
        <% 
        Map<InputGesture,Integer> last = (Map<InputGesture,Integer>)pageContext.getAttribute("lastGestures");
        if (last != null && !last.isEmpty()) {
        %>
        <tr>
            <td align="center" width="480">
                <chart:pie 
                    collection="lastGestures" 
                    category="key" 
                    value="value" 
                    title="Last Session" 
                    align="center" 
                    rotation="anticlockwise"
                />
                <!-- explodePercent="0.25" explodePosition="0"  -->
                <p>
                    This graph shows data gathered in your last session. 
                    It shows how many actions you have invoked and what
                    was the percentage of those invoked by mouse in a toolbar,
                    menu or directly by a keyboard.
                </p>
            </td>
        </tr>
        <% }
        Map<InputGesture,Integer> user = (Map<InputGesture,Integer>)pageContext.getAttribute("userGestures");

        if (user != null && !user.isEmpty()) {
        %>
        <tr>
            <td align="center" width="480">
                <chart:pie 
                    collection="userGestures" 
                    category="key" 
                    value="value" 
                    title="All Your Sessions" 
                    align="center" 
                    rotation="anticlockwise"
                />
                <!-- explodePercent="0.25" explodePosition="0"  -->
                <p>
                    This graph shows data collected from all your sessions.
                    Again, the total sum is the number of all started actions,
                    the pies describe those executed via menu, toolbar and keyboard.
                </p>
                
            </td>
        </tr>
        <% } 
        
        
        Map<InputGesture,Integer> all= (Map<InputGesture,Integer>)pageContext.getAttribute("globalGestures");

        if (all != null && !all.isEmpty()) {
        %>
        <tr>
            <td align="center" width="480">
                <chart:pie 
                    collection="globalGestures" 
                    category="key" 
                    value="value" 
                    title="Global" 
                    align="center" 
                    rotation="anticlockwise"
                />
                <!-- explodePercent="0.25" explodePosition="0"  -->
                <p>
                    In order to give you a feel how others use the NetBeans IDE,
                    here is a total agregation of the invoked actions
                    grouped by the way they were invoked over
                    all recorded sessions from all users. Feel free to compare
                    your usage with the average!
                </p>
            </td>
        </tr>
        <% } %>
    </table></center>
<jsp:include page="../template/footer.jsp"/>
