/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.exceptions.web;

import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

/**
 *
 * @author Jan Horvath
 */
public class Utils {

    public Utils() {
    }

    public static Map getParamsFromRequest(HttpServletRequest request) {
        String[] components = request.getParameterValues("component");
        String[] subcomponents = request.getParameterValues("subcomponent");
        String[] os = request.getParameterValues("os");
        String[] vm = request.getParameterValues("vm");
        String[] build = request.getParameterValues("build");
        String username = request.getParameter("username");
//        Long build = null;
//        try {
//            build = new Long(request.getParameter("build"));
//        } catch (Exception e) {
//        }
        
        
        String reset = request.getParameter("reset");
        
        Map params = new Hashtable();
        boolean newParams = false;
        if (components != null) {
            params.put("component", Arrays.asList(components));
            newParams = true;
        }
        if (subcomponents != null) {
            params.put("subcomponent", Arrays.asList(subcomponents));
            newParams = true;
        }
        if (os != null) {
            params.put("operatingsystem", Arrays.asList(os));
            newParams = true;
        }
        if (build != null) {
            params.put("build", Arrays.asList(build));
            newParams = true;
        }
        if (vm != null) {
            params.put("vm", Arrays.asList(vm));
            newParams = true;
        }
        if ((username != null) && (username.length() > 0)) {
            params.put("username", Collections.singletonList(username));
            newParams = true;
        }
        
        if (newParams || (reset != null)) {
            request.getSession().setAttribute("params", params);
        } else {
            Object o = request.getSession().getAttribute("params");
            if (o != null) {
                params = (Map) o;
            }
        }
        return params;
    }
}
