/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.exceptions.entity;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;

/**
 *
 * @author Jindrich Sedek
 */
@Embeddable
public class MappingPK implements Serializable {
    @Column(name = "OLD_COMPONENT", nullable = false)
    private String oldComponent;
    @Column(name = "OLD_SUBCOMPONENT", nullable = false)
    private String oldSubcomponent;

    public MappingPK() {
    }

    public MappingPK(String oldComponent, String oldSubcomponent) {
        this.oldComponent = oldComponent;
        this.oldSubcomponent = oldSubcomponent;
    }

    public String getOldComponent() {
        return oldComponent;
    }

    public void setOldComponent(String oldComponent) {
        this.oldComponent = oldComponent;
    }

    public String getOldSubcomponent() {
        return oldSubcomponent;
    }

    public void setOldSubcomponent(String oldSubcomponent) {
        this.oldSubcomponent = oldSubcomponent;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (oldComponent != null ? oldComponent.hashCode() : 0);
        hash += (oldSubcomponent != null ? oldSubcomponent.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof MappingPK)) {
            return false;
        }
        MappingPK other = (MappingPK) object;
        if (this.oldComponent != other.oldComponent && (this.oldComponent == null || !this.oldComponent.equals(other.oldComponent))) {
            return false;
        }
        if (this.oldSubcomponent != other.oldSubcomponent && (this.oldSubcomponent == null || !this.oldSubcomponent.equals(other.oldSubcomponent))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "org.netbeans.modules.exceptions.entity.MappingPK[oldComponent=" + oldComponent + ", oldSubcomponent=" + oldSubcomponent + "]";
    }

}
