/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.exceptions.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.OneToOne;

/**
 *
 * @author Jan Horvath
 */
@Entity
@Table(name = "logfile")
@NamedQueries({@NamedQuery(name = "Logfile.findById", query = "SELECT l FROM Logfile l WHERE l.id = :id"),
@NamedQuery(name = "Logfile.findByIp", query = "SELECT l FROM Logfile l WHERE l.ip = :ip"),
@NamedQuery(name = "Logfile.findByBuildnumber", query = "SELECT l FROM Logfile l WHERE l.buildnumber = :buildnumber"),
@NamedQuery(name = "Logfile.findByUserdir", query = "SELECT l FROM Logfile l WHERE l.userdir = :userdir"),
@NamedQuery(name = "Logfile.findByUploadNumber", query = "SELECT l FROM Logfile l WHERE l.uploadNumber = :uploadNumber"),
@NamedQuery(name = "Logfile.findByDateCreated", query = "SELECT l FROM Logfile l WHERE l.dateCreated = :dateCreated"),
@NamedQuery(name = "Logfile.findByFile", query = "SELECT l FROM Logfile l WHERE l.userdir = :userdir AND l.uploadNumber = :uploadnumber")
})
        public class Logfile implements Serializable {
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "ID", nullable = false)
    private Integer id;
    @Column(name = "IP")
    private Long ip;
    @Column(name = "BUILDNUMBER")
    private Long buildnumber;
    @Column(name = "USERDIR")
    private String userdir;
    @Column(name = "UPLOAD_NUMBER")
    private Integer uploadNumber;
    @Column(name = "DATE_CREATED")
    @Temporal(TemporalType.TIMESTAMP)
    private Date dateCreated;
    @JoinColumn(name = "PRODUCT_VERSION_ID", referencedColumnName = "ID")
    @ManyToOne
    private ProductVersion productVersionId;
    @OneToOne(mappedBy = "logfileId")
    private Exceptions exceptions;
    
    public Logfile() {
    }
    
    public Logfile(Integer id) {
        this.id = id;
    }
    
    public Integer getId() {
        return id;
    }
    
    public void setId(Integer id) {
        this.id = id;
    }
    
    public Long getIp() {
        return ip;
    }
    
    public String getIpAddr(){
        String result = Long.toString(ip % 1000);
        long pom = ip / 1000;
        while (pom != 0){
            result = Long.toString(pom % 1000).concat("."+result);
            pom = pom / 1000;
        }
        return result;
    }
    
    public void setIp(Long ip) {
        this.ip = ip;
    }
    
    public void setIpAddr(String address){
        String[] numbers = address.split("\\.");
        long ip =0;
        for (int i = 0; i < numbers.length; i++){
            Integer value = new Integer(numbers[i]);
            ip = ip*1000+value;
        }
        this.ip = ip;
    }
    
    public Long getBuildnumber() {
        return buildnumber;
    }
    
    public void setBuildnumber(Long buildnumber) {
        this.buildnumber = buildnumber;
    }
    
    public String getUserdir() {
        return userdir;
    }
    
    public void setUserdir(String userdir) {
        this.userdir = userdir;
    }
    
    public Integer getUploadNumber() {
        return uploadNumber;
    }
    
    public void setUploadNumber(Integer uploadNumber) {
        this.uploadNumber = uploadNumber;
    }
    
    public String getFileName(){
        if (userdir == null) return null;
        if ((uploadNumber==null)||(uploadNumber==0)) return userdir;
        else return userdir + "." + Integer.toString(uploadNumber-1);
    }
    
    public Date getDateCreated() {
        return dateCreated;
    }
    
    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }
    
    public ProductVersion getProductVersionId() {
        return productVersionId;
    }
    
    public void setProductVersionId(ProductVersion productVersionId) {
        this.productVersionId = productVersionId;
    }
    
    @Override
    public int hashCode() {
        int hash = 0;
        hash += (id != null
                ? id.hashCode(): 0);
        return hash;
    }
    
    @Override
    public boolean equals(Object object) {
        /*
         * TODO: Warning - this method won't work in the case the id fields are not set
         */
        if (!(object instanceof Logfile)) {
            return false;
        }
        Logfile other = (Logfile) object;
        if (this.id != other.id && (this.id == null || !this.id.equals(other.id))) {
            return false;
        }
        return true;
    }
    
    @Override
    public String toString() {
        return "org.netbeans.modules.exceptions.entity.Logfile[id=" + id + "]";
    }
    
}
