/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.exceptions.entity;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.netbeans.modules.exceptions.utils.PersistenceUtils;

/**
 *
 * @author Jan Horvath
 */
@Entity
@Table(name = "exceptions")
@NamedQueries({@NamedQuery(name = "Exceptions.findById", query = "SELECT e FROM Exceptions e WHERE e.id = :id"),
@NamedQuery(name = "Exceptions.findBySummary", query = "SELECT e FROM Exceptions e WHERE e.summary = :summary"),
@NamedQuery(name = "Exceptions.findByComponent", query = "SELECT e FROM Exceptions e WHERE e.component = :component"),
@NamedQuery(name = "Exceptions.findBySubcomponent", query = "SELECT e FROM Exceptions e WHERE e.subcomponent = :subcomponent"),
@NamedQuery(name = "Exceptions.findByLoggername", query = "SELECT e FROM Exceptions e WHERE e.loggername = :loggername"),
@NamedQuery(name = "Exceptions.findByVm", query = "SELECT e FROM Exceptions e WHERE e.vm = :vm"),
@NamedQuery(name = "Exceptions.findByProductversion", query = "SELECT e FROM Exceptions e WHERE e.productversion = :productversion"),
@NamedQuery(name = "Exceptions.findByOperatingsystem", query = "SELECT e FROM Exceptions e WHERE e.operatingsystem = :operatingsystem"),
@NamedQuery(name = "Exceptions.findByIssuezillaid", query = "SELECT e FROM Exceptions e WHERE e.issuezillaid = :issuezillaid"),
@NamedQuery(name = "Exceptions.findByReportdate", query = "SELECT e FROM Exceptions e WHERE e.reportdate = :reportdate"),
@NamedQuery(name = "Exceptions.findByBuild", query = "SELECT e FROM Exceptions e WHERE e.build = :build"),
@NamedQuery(name = "Exceptions.findByInterval", query = "SELECT e FROM Exceptions e WHERE e.reportdate BETWEEN :start AND :end ORDER BY e.reportdate"),
@NamedQuery(name = "Exceptions.findByIntervalIssue", query = "SELECT e FROM Exceptions e WHERE e.reportdate BETWEEN :start AND :end ORDER BY e.reportdate"),
@NamedQuery(name = "Exceptions.countByInterval", query = "SELECT COUNT(e) FROM Exceptions e WHERE e.reportdate BETWEEN :start AND :end"),
@NamedQuery(name = "Exceptions.countByBuild", query = "SELECT COUNT(e) FROM Exceptions e WHERE e.build = :build"),
@NamedQuery(name = "Exceptions.selectBuilds", query = "SELECT DISTINCT e.build FROM Exceptions e WHERE e.build > :from ORDER BY e.build"),
@NamedQuery(name = "Exceptions.findByStatus", query = "SELECT e FROM Exceptions e WHERE e.status = :status")})

public class Exceptions implements Serializable {
   
    public enum Status {
        MAN_COMPONENT_CHANGE(1),
        MAN_ISSUE_CHANGE(2),
        MAN_DUPLICATE_CHANGE(4),
        ISSUEZILLA_TRANSFER(8);
        
        private final int status;
        Status(int status) {
            this.status = status;
        }
        public int intValue() {
            return status;
        }
        
        public static EnumSet<Status> getEnumSet(Integer status) {
            EnumSet<Status> set = EnumSet.noneOf(Status.class);
            if (status != null) {
                int i = status.intValue();
                if (testStatus(i, MAN_COMPONENT_CHANGE)) set.add(MAN_COMPONENT_CHANGE);
                if (testStatus(i, MAN_ISSUE_CHANGE)) set.add(MAN_ISSUE_CHANGE);
                if (testStatus(i, MAN_DUPLICATE_CHANGE)) set.add(MAN_DUPLICATE_CHANGE);
                if (testStatus(i, ISSUEZILLA_TRANSFER)) set.add(ISSUEZILLA_TRANSFER);
            }
            return set;
        }
        
        public static Integer getInteger(EnumSet<Status> set) {
            int i = 0;
            if (set != null) {
                for (Iterator<Exceptions.Status> it = set.iterator(); it.hasNext();) {
                    Exceptions.Status status = it.next();
                    i |= status.intValue();
                }
            }
            return new Integer(i);
        }
        
        private static boolean testStatus(int i, Status s) {
            return (i & s.intValue()) == s.intValue();
        }
        
    }
    
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "ID", nullable = false)
    private Integer id;
    @Column(name = "SUMMARY")
    private String summary;
    @Column(name = "COMPONENT")
    private String component;
    @Column(name = "SUBCOMPONENT")
    private String subcomponent;
    @Column(name = "loggername")
    private String loggername;
    @Column(name = "VM")
    private String vm;
    @Column(name = "PRODUCTVERSION")
    private String productversion;
    @Column(name = "OPERATINGSYSTEM")
    private String operatingsystem;
    @Column(name = "ISSUEZILLAID")
    private Integer issuezillaid;
    @Column(name = "REPORTDATE")
    @Temporal(TemporalType.TIMESTAMP)
    private Date reportdate;
    @Column(name = "BUILD")
    private Long build;
    @Column(name = "STATUS")
    private Integer status;
    @JoinColumn(name = "NBUSER_ID", referencedColumnName = "ID")
    @ManyToOne
    private Nbuser nbuserId;
    @JoinColumn(name = "STACKTRACE", referencedColumnName = "ID")
    @OneToOne
    private Stacktrace stacktrace;
    @OneToMany(cascade = CascadeType.ALL, mappedBy = "duplicateof")
    private Collection<Exceptions> exceptionsCollection;
    @JoinColumn(name = "DUPLICATEOF", referencedColumnName = "ID")
    @ManyToOne
    private Exceptions duplicateof;
    @OneToOne(cascade = CascadeType.ALL, mappedBy = "exceptions")
    private Hashcodes hashcodes;
    @OneToMany(cascade = CascadeType.ALL, mappedBy = "exceptionId")
    private Collection<Comment> commentCollection;
    @JoinColumn(name = "LOGFILE_ID", referencedColumnName = "ID")
    @OneToOne
    private Logfile logfileId;
    
    @Transient
    private int duplicates = -1;
    @Transient
    private long latestBuild = -1;
    @Transient
    private EnumSet<Status> statusEnumSet;
    
    public Exceptions() {
    }
    
    public Exceptions(Integer id) {
        this.id = id;
    }
    
//    @PostLoad
    public void loadStatus() {
        statusEnumSet = Status.getEnumSet(getStatus());
    }
    
//    @PreUpdate
//    @PrePersist
    public void saveStatus() {
        setStatus(Status.getInteger(statusEnumSet));
    }
    
    public Integer getId() {
        return id;
    }
    
    public void setId(Integer id) {
        this.id = id;
    }

    private PersistenceUtils getPU(){
        return PersistenceUtils.getInstance();
    }
    
    public int getDuplicates() {
        if (duplicates < 0) {
            Map m = (Map) Collections.singletonMap("duplicateof.id", Collections.singletonList(getId()));
            duplicates = getPU().count(Exceptions.class,  m, false, false).intValue();
        }
        return duplicates;
    }
    
    public Collection<Exceptions> getDuplicatesCollection() {
        Integer id = getDuplicateof() == null ? getId() : getDuplicateof().getId();
        Map m = (Map) Collections.singletonMap("duplicateof.id", Collections.singletonList(id));
        Collection<Exceptions> duplicatesCol = getPU().find(Exceptions.class,  m, false, false, null);
        return duplicatesCol;
    }
    
    public int getDuplicatesFromDistinctUsers(){
        return getPU().countDistinct(Exceptions.class, "nbuserId", "entity.duplicateof.id = "+ getId());
    }
    
    public int getDuplicatesFromOneUser(Nbuser user){
        return  getPU().count(Exceptions.class, "entity.duplicateof.id = " + getId() + " AND entity.nbuserId.id = " + user.getId());
    }

    public long getLatestBuild() {
        if (latestBuild < 0) {
            latestBuild = getBuild() == null ? 0 : getBuild().longValue();
            Collection<Exceptions> col = getExceptionsCollection();
            
            if ((col != null) && (col.size() > 0)) {
                for (Iterator<Exceptions> it = col.iterator(); it.hasNext();) {
                    Exceptions dup = it.next();
                    if ((dup.getBuild() != null) && (latestBuild < dup.getBuild())) {
                        latestBuild = dup.getBuild();
                    }
                }
            }
        }
        return latestBuild;
    }
    
    public boolean getComponentManChanged() {
        loadStatus();
        return statusEnumSet.contains(Status.MAN_COMPONENT_CHANGE);
    }
    
    public void setComponentManChanged(boolean it) {
        loadStatus();
        setStatusEnum(Status.MAN_COMPONENT_CHANGE, it);
        saveStatus();
    }
    
    public boolean getIssueManChanged() {
        loadStatus();
        return statusEnumSet.contains(Status.MAN_ISSUE_CHANGE);
    }
    
    public void setIssueManChanged(boolean it) {
        loadStatus();
        setStatusEnum(Status.ISSUEZILLA_TRANSFER, it);
        saveStatus();
    }
    
    public boolean getDuplicateManChanged() {
        loadStatus();
        return statusEnumSet.contains(Status.MAN_DUPLICATE_CHANGE);
    }
    
    public void setDuplicateManChanged(boolean it) {
        loadStatus();
        setStatusEnum(Status.MAN_DUPLICATE_CHANGE, it);
        saveStatus();
    }
    
    public boolean getIssuezillaTransfer() {
        loadStatus();
        return statusEnumSet.contains(Status.ISSUEZILLA_TRANSFER);
    }
    
    public void setIssuezillaTransfer(boolean it) {
        loadStatus();
        setStatusEnum(Status.ISSUEZILLA_TRANSFER, it);
        saveStatus();
    }
    
    private void setStatusEnum(Status status, boolean it) {
        if (it) {
            statusEnumSet.add(status);
        } else {
            statusEnumSet.remove(status);
        }
    }
    
    public Logfile getLogfileId() {
        return logfileId;
    }

    public void setLogfileId(Logfile logfileId) {
        this.logfileId = logfileId;
    }
    
    public String getSummary() {
        return summary;
    }
    
    public void setSummary(String summary) {
        this.summary = summary;
    }
    
    public String getComponent() {
        return component;
    }
    
    public void setComponentAndSubcomponent(String component, String subcomponent){
        Map<String, Object> params = new HashMap<String, Object>(3);
        params.put("oldSubcomponent", subcomponent);
        params.put("oldComponent", component);
        List<Mapping> mappings = getPU().executeNamedQuery("Mapping.findByOld", params);
//        List<Mapping> mappings = getPU().executeQuery(
//                "SELECT m FROM Mapping m WHERE m.mappingPK.oldSubcomponent = :oldSubcomponent AND m.mappingPK.oldComponent = :oldComponent", params);
        if (mappings.size() > 0){
            Mapping mapping= mappings.get(0);
            component = mapping.getNewComponent();
            subcomponent = mapping.getNewSubcomponent();
        }
        this.component = component;
        this.subcomponent = subcomponent;
    }

    public String getSubcomponent() {
        return subcomponent;
    }
    
    public String getLoggername() {
        return loggername;
    }
    
    public void setLoggername(String loggername) {
        this.loggername = loggername;
    }
    
    public String getVm() {
        return vm;
    }
    
    public void setVm(String vm) {
        this.vm = vm;
    }
    
    public String getProductversion() {
        return productversion;
    }
    
    public void setProductversion(String productversion) {
        this.productversion = productversion;
    }
    
    public String getOperatingsystem() {
        return operatingsystem;
    }
    
    public void setOperatingsystem(String operatingsystem) {
        this.operatingsystem = operatingsystem;
    }
    
    public Integer getIssuezillaid() {
        return issuezillaid;
    }
    
    public void setIssuezillaid(Integer issuezillaid) {
        this.issuezillaid = issuezillaid;
    }
    
    public Date getReportdate() {
        return reportdate;
    }
    
    public void setReportdate(Date reportdate) {
        this.reportdate = reportdate;
    }
    
    public Long getBuild() {
        return build;
    }
    
    public void setBuild(Long build) {
        this.build = build;
    }
    
    public Integer getStatus() {
        return status;
    }
    
    public void setStatus(Integer status) {
        this.status = status;
    }
    
    public Nbuser getNbuserId() {
        return nbuserId;
    }
    
    public void setNbuserId(Nbuser nbuserId) {
        this.nbuserId = nbuserId;
    }
    
    public Stacktrace getStacktrace() {
        return stacktrace;
    }
    
    public void setStacktrace(Stacktrace stacktrace) {
        this.stacktrace = stacktrace;
    }
    
    public Collection<Exceptions> getExceptionsCollection() {
        return exceptionsCollection;
    }
    
    public void setExceptionsCollection(Collection<Exceptions> exceptionsCollection) {
        this.exceptionsCollection = exceptionsCollection;
    }
    
    public Exceptions getDuplicateof() {
        return duplicateof;
    }
    
    public void setDuplicateof(Exceptions duplicateof) {
        this.duplicateof = duplicateof;
    }
    
    public Hashcodes getHashcodes() {
        return hashcodes;
    }
    
    public void setHashcodes(Hashcodes hashcodes) {
        this.hashcodes = hashcodes;
    }
    
    public Collection<Comment> getCommentCollection() {
        return commentCollection;
    }
    
    public void setCommentCollection(Collection<Comment> commentCollection) {
        this.commentCollection = commentCollection;
    }
    
    @Override
    public int hashCode() {
        int hash = 0;
        
        hash += (id != null ? id.hashCode()
                : 0);
        return hash;
    }
    
    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof Exceptions)) {
            return false;
        }
        Exceptions other = (Exceptions) object;
        
        if (this.id != other.id &&
                (this.id == null || !this.id.equals(other.id)))
            return false;
        return true;
    }
    
    @Override
    public String toString() {
        return "Exceptions[id=" + id +
                ", build=" + build +
                ", duplicateof=" + duplicateof +
                "]";
    }
   
}
