/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.java.editor.options;

import java.awt.event.ItemEvent;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.editor.SettingsNames;
import org.netbeans.editor.ext.java.JavaSettingsNames;
import org.openide.util.NbBundle;

/**
 *
 * @author  Martin Roskanin
 */
public class CodeFoldingEditorPanel extends javax.swing.JPanel {

    CodeFoldingEditor foldingEditor;

    /** Creates new form CodeFoldingEditorPanel */
    public CodeFoldingEditorPanel(CodeFoldingEditor foldingEditor) {
        this.foldingEditor = foldingEditor;
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        enableFoldingCB = new javax.swing.JCheckBox();
        jLabel1 = new javax.swing.JLabel();
        methodCB = new javax.swing.JCheckBox();
        innerCB = new javax.swing.JCheckBox();
        importCB = new javax.swing.JCheckBox();
        javadocCB = new javax.swing.JCheckBox();
        initialCommentCB = new javax.swing.JCheckBox();

        setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(enableFoldingCB, org.openide.util.NbBundle.getMessage(CodeFoldingEditorPanel.class, "CFEP_UseCF")); // NOI18N
        enableFoldingCB.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                checkBoxChange(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 12, 0);
        add(enableFoldingCB, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(CodeFoldingEditorPanel.class, "CFEP_CollapsedByDefault")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 5, 11);
        add(jLabel1, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(methodCB, org.openide.util.NbBundle.getMessage(CodeFoldingEditorPanel.class, "CFEP_Method")); // NOI18N
        methodCB.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                methodCBItemStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 24, 0, 0);
        add(methodCB, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(innerCB, org.openide.util.NbBundle.getMessage(CodeFoldingEditorPanel.class, "CFEP_InnerClass")); // NOI18N
        innerCB.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                innerCBItemStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 24, 0, 0);
        add(innerCB, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(importCB, org.openide.util.NbBundle.getMessage(CodeFoldingEditorPanel.class, "CFEP_Import")); // NOI18N
        importCB.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                importCBItemStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 24, 0, 0);
        add(importCB, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(javadocCB, org.openide.util.NbBundle.getMessage(CodeFoldingEditorPanel.class, "CFEP_Javadoc")); // NOI18N
        javadocCB.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                javadocCBItemStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 24, 0, 0);
        add(javadocCB, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(initialCommentCB, org.openide.util.NbBundle.getMessage(CodeFoldingEditorPanel.class, "CFEP_InitialComment")); // NOI18N
        initialCommentCB.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                initialCommentCBItemStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 24, 0, 0);
        add(initialCommentCB, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void initialCommentCBItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_initialCommentCBItemStateChanged
        notifyEditor();
    }//GEN-LAST:event_initialCommentCBItemStateChanged

    private void javadocCBItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_javadocCBItemStateChanged
        notifyEditor();
    }//GEN-LAST:event_javadocCBItemStateChanged

    private void importCBItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_importCBItemStateChanged
        notifyEditor();
    }//GEN-LAST:event_importCBItemStateChanged

    private void innerCBItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_innerCBItemStateChanged
        notifyEditor();
    }//GEN-LAST:event_innerCBItemStateChanged

    private void methodCBItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_methodCBItemStateChanged
        notifyEditor();
    }//GEN-LAST:event_methodCBItemStateChanged

    private void checkBoxChange(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_checkBoxChange
        setCBoxesEnabled(evt.getStateChange() == ItemEvent.SELECTED);
        notifyEditor();
    }//GEN-LAST:event_checkBoxChange

    
    private void notifyEditor() {
        if( foldingEditor != null ) foldingEditor.customEditorChange();
    }
    
    private void setCBoxesEnabled(boolean selected){
        methodCB.setEnabled(selected);
        innerCB.setEnabled(selected);
        importCB.setEnabled(selected);
        javadocCB.setEnabled(selected);
        initialCommentCB.setEnabled(selected);
    }
    
    /**
     * Fill in editor with initial values
     */
    public void setValue( Map m ) {

        Boolean val = (Boolean)m.get(SettingsNames.CODE_FOLDING_ENABLE);
        if (val.booleanValue() == false){
            setCBoxesEnabled(false);
        }
        enableFoldingCB.setSelected(val.booleanValue());
        
        val = (Boolean)m.get(JavaSettingsNames.CODE_FOLDING_COLLAPSE_METHOD);
        methodCB.setSelected(val.booleanValue());

        val = (Boolean)m.get(JavaSettingsNames.CODE_FOLDING_COLLAPSE_INNERCLASS);
        innerCB.setSelected(val.booleanValue());

        val = (Boolean)m.get(JavaSettingsNames.CODE_FOLDING_COLLAPSE_IMPORT);
        importCB.setSelected(val.booleanValue());

        val = (Boolean)m.get(JavaSettingsNames.CODE_FOLDING_COLLAPSE_JAVADOC);
        javadocCB.setSelected(val.booleanValue());
        
        val = (Boolean)m.get(JavaSettingsNames.CODE_FOLDING_COLLAPSE_INITIAL_COMMENT);
        initialCommentCB.setSelected(val.booleanValue());

    }

    /**
     * Take the result of users modifications
     */
    public Map getValue() {
        Map ret = new HashMap(10);
        ret.put(SettingsNames.CODE_FOLDING_ENABLE, Boolean.valueOf(enableFoldingCB.isSelected()));
        ret.put(JavaSettingsNames.CODE_FOLDING_COLLAPSE_METHOD, Boolean.valueOf(methodCB.isSelected()));
        ret.put(JavaSettingsNames.CODE_FOLDING_COLLAPSE_INNERCLASS, Boolean.valueOf(innerCB.isSelected()));
        ret.put(JavaSettingsNames.CODE_FOLDING_COLLAPSE_IMPORT, Boolean.valueOf(importCB.isSelected()));
        ret.put(JavaSettingsNames.CODE_FOLDING_COLLAPSE_JAVADOC, Boolean.valueOf(javadocCB.isSelected()));
        ret.put(JavaSettingsNames.CODE_FOLDING_COLLAPSE_INITIAL_COMMENT, Boolean.valueOf(initialCommentCB.isSelected()));
        return ret;
    }

    private String getBundleString(String s) {
        return NbBundle.getMessage(CodeFoldingEditorPanel.class, s);
    }        

    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox enableFoldingCB;
    private javax.swing.JCheckBox importCB;
    private javax.swing.JCheckBox initialCommentCB;
    private javax.swing.JCheckBox innerCB;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JCheckBox javadocCB;
    private javax.swing.JCheckBox methodCB;
    // End of variables declaration//GEN-END:variables
    
}
