/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.j2ee.refactoring.moveclass;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.jmi.reflect.RefObject;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.MoveClassRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.taglib.TLDDataObject;
import org.netbeans.modules.web.taglib.TLDLoader;
import org.netbeans.modules.web.taglib.model.FunctionType;
import org.netbeans.modules.web.taglib.model.ListenerType;
import org.netbeans.modules.web.taglib.model.TagType;
import org.netbeans.modules.web.taglib.model.Taglib;
import org.netbeans.modules.web.taglib.model.ValidatorType;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

/**
 *
 * @author Martin Grebac
 */
public final class TldMoveClassRefactoring {
    
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.j2ee.refactoring.rename");   // NOI18N

    public TldMoveClassRefactoring() { }

    /** Find usages in web deployment descriptor: web.xml 
     */
    public Problem prepare(MoveClassRefactoring moveClassRefactor, Collection resources, RefactoringElementsBag refactoringElements) {
        Problem problem = null;
            
        for (Iterator i = resources.iterator(); i.hasNext();) {
            Resource resource = (Resource) i.next();
            FileObject fo = JavaModel.getFileObject(resource);

            err.log("resource package name:  " + resource.getPackageName());
            err.log("resource: name " + resource.getName());

            WebModule wm = WebModule.getWebModule(fo);
            
            FileObject target = moveClassRefactor.getTargetClassPathRoot();
            WebModule wmNew = null;
            if  (target != null) {
                wmNew = WebModule.getWebModule(moveClassRefactor.getTargetClassPathRoot());
            }
            
            if (wm != null) {              // the class is in a web module, therefore tld makes sense
                boolean moveToAnotherProject = false; 
                
                if (wmNew != null) {
                    moveToAnotherProject = !wm.equals(wmNew);
                }
    
                FileObject webInf = wm.getWebInf();
                Enumeration e = null;
                if (webInf != null) {
                    e = webInf.getChildren(true);
                }
                if (e != null) {
                    while (e.hasMoreElements()) {
                        FileObject tld = (FileObject)e.nextElement();
                        FileObject tldNew = null;
                        
                        if (isTld(tld)) {

                            DataObject tldData = null;
                            DataObject newTldData = null;
                            
                            try {
                                tldData = DataObject.find(tld);
                            } catch (DataObjectNotFoundException dne) {
                                // ignore
                            }
                            
                            if (moveToAnotherProject) {
                                FileObject webInfNew = wmNew.getWebInf();
                                Enumeration e2 = null;
                                if (webInfNew != null) {
                                    e2 = webInfNew.getChildren(true);
                                }
                                while (e2.hasMoreElements()) {
                                    tldNew = (FileObject)e2.nextElement();
                                    if (isTld(tldNew)) {
                                        try {
                                            newTldData = DataObject.find(tldNew);
                                            break;
                                        } catch (DataObjectNotFoundException dne) {
                                            // ignore
                                        }
                                    }
                                }
                                if (newTldData == null) {
                                    Problem newProblem = new Problem(false, NbBundle.getMessage(TldMoveClassRefactoring.class, "TXT_TaglibNotExistMoveClassOtherProjectInvalidProblem"));
                                    problem = Utility.addProblemsToEnd(problem, newProblem);
                                }
                            }
                            
                            
                            if ((tldData != null) && (tldData instanceof TLDDataObject)) {
                                Taglib taglib = null;
                                try {
                                    taglib = ((TLDDataObject)tldData).getTaglib();
                                } catch (IOException ioe) {}
                                if (taglib != null) {
                                    List classes = resource.getClassifiers();
                                    err.log("Classes in resource: " + classes);

                                    for (int j=0; j < classes.size(); j++ ) {
                                        JavaClass jClass = (JavaClass)classes.get(j);
                                        err.log("javaclass: "+ jClass);

                                        String name = jClass.getName();
                                        err.log("name: " + name);

                                        String targetPackage = moveClassRefactor.getTargetPackageName(resource);
                                        err.log("targetPackage: " + targetPackage);

                                        String newName = targetPackage + "." + jClass.getSimpleName();
                                        err.log("newname: " + newName);

                                        // tag element
                                        TagType[] tagTypes = taglib.getTag();
                                        if ((tagTypes != null) && (tagTypes.length > 0)) {
                                            for (int tt = 0; tt < tagTypes.length; tt++) {
                                                TagType tagT = tagTypes[tt];
                                                String tagClass = tagT.getTagClass();
                                                String teiClass = tagT.getTeiClass();
                                                if (!moveToAnotherProject) {
                                                    if ((tagClass != null) && (tagClass.equals(name))) {
                                                        RefactoringElementImplementation elem = new TaglibTagClassMoveClassRefactoringElement(tldData, name, newName);
                                                        refactoringElements.add(moveClassRefactor, elem);
                                                    }
                                                    if ((teiClass != null) && (teiClass.equals(name))) {
                                                        RefactoringElementImplementation elem = new TaglibTeiClassMoveClassRefactoringElement(tldData, name, newName);
                                                        refactoringElements.add(moveClassRefactor, elem);
                                                    }
                                                } else {
                                                    if (newTldData != null) {
                                                        if ((tagClass != null) && (tagClass.equals(name))) {
                                                            RefactoringElementImplementation elem = new TaglibTagClassReferenceMoveClassOtherProjectRefactoringElement(tldData, newTldData, name, newName);
                                                            refactoringElements.add(moveClassRefactor, elem);
                                                        }
                                                        if ((teiClass != null) && (teiClass.equals(name))) {
                                                            RefactoringElementImplementation elem = new TaglibTeiClassReferenceMoveClassOtherProjectRefactoringElement(tldData, newTldData, name, newName);
                                                            refactoringElements.add(moveClassRefactor, elem);
                                                        }
                                                    }
                                                }
                                            }
                                        }

                                        FunctionType[] functionTypes = taglib.getFunction();
                                        if ((functionTypes != null) && (functionTypes.length > 0)) {
                                            for (int tt = 0; tt < functionTypes.length; tt++) {
                                                FunctionType functionT = functionTypes[tt];
                                                String functionClass = functionT.getFunctionClass();
                                                if ((functionClass != null) && (functionClass.equals(name))) {
                                                    RefactoringElementImplementation elem = new TaglibFunctionClassMoveClassRefactoringElement(tldData, name, newName);
                                                    refactoringElements.add(moveClassRefactor, elem);
                                                }
                                            }
                                        }

                                        // validator element
                                        ValidatorType validatorType = taglib.getValidator();
                                        if (validatorType != null) {
                                            String validatorClass = validatorType.getValidatorClass();
                                            if ((validatorClass != null) && (validatorClass.equals(name))) {
                                                RefactoringElementImplementation elem = new TaglibValidatorClassMoveClassRefactoringElement(tldData, name, newName);
                                                refactoringElements.add(moveClassRefactor, elem);
                                            }
                                        }

                                        // listener element
                                        org.netbeans.modules.web.taglib.model.ListenerType[] listenerTypes = taglib.getListener();
                                        if ((listenerTypes != null) && (listenerTypes.length > 0)) {
                                            for (int tt = 0; tt < listenerTypes.length; tt++) {
                                                org.netbeans.modules.web.taglib.model.ListenerType listenerT = listenerTypes[tt];
                                                String listenerClass = listenerT.getListenerClass();
                                                if ((listenerClass != null) && (listenerClass.equals(name))) {
                                                    RefactoringElementImplementation elem = new TaglibListenerClassMoveClassRefactoringElement(tldData, name, newName);
                                                    refactoringElements.add(moveClassRefactor, elem);
                                                }
                                            }
                                        }


                                    }

                                } else {
                                    Object[] args = new Object [] {tld.getNameExt()};
                                    String msg = MessageFormat.format(NbBundle.getMessage(TldMoveClassRefactoring.class, "TXT_TaglibMoveClassInvalidProblem"), args);
                                    Problem newProblem = new Problem(false, msg);
                                    problem = Utility.addProblemsToEnd(problem, newProblem);
                                }
                            }
                        }
                    }
                }
            }
        }
        return problem;
    }

    private boolean isTld(FileObject fo) {
        boolean isTld = false;
        if (fo != null) {
            String ext = fo.getExt();
            if (TLDLoader.tldExt.equalsIgnoreCase(ext)) {
                isTld = true;
            }
        }
        return isTld;
    }
        
    public final class TaglibTagClassMoveClassRefactoringElement extends AbstractMoveClassRefactoringElement implements ExternalChange {

        protected DataObject data = null;

        /** Creates a new instance of TaglibTagClassMoveClassRefactoringElement */
        public TaglibTagClassMoveClassRefactoringElement(DataObject data, String oldName, String newName) { 
            this.data = data;
            this.oldName = oldName;
            this.newName = newName;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {data.getPrimaryFile().getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(TldMoveClassRefactoring.class, "TXT_TaglibTagClassMoveClass"), args);
        }

        /** Returns file that the element affects (relates to)
         * @return File
         */
        public FileObject getParentFile() {
            if (data != null) {
                return data.getPrimaryFile();                
            }
            return null;
        }        

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            if (data != null) {
                FileObject tldFO = data.getPrimaryFile();
                TLDDataObject tdo = ((TLDDataObject)data);
                Taglib taglib = null;
                try {
                    taglib = tdo.getTaglib();
                } catch (IOException ioe) { 
                    //ignore 
                }
                if (taglib != null) /* TODO check validity */ {
                    err.log("perform external change: TaglibTagClassMoveClassRefactoringElement");
                    TagType tag = null;
                    TagType[] tags = taglib.getTag();
                    for (int i=0; i < tags.length; i++) {
                        String tagClass = tags[i].getTagClass();
                        if (oldName.equals(tagClass)) {
                            tag = tags[i];
                            break;
                        }
                    }
                    if (tag!=null) {
                        tag.setTagClass(newName);
                        try {
                            if (tdo != null) {
                                tdo.write(taglib);
                            }
                        } catch (IOException ioe) {
                            ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ioe.getMessage());
                        }
                    }
                }
            }
        }
        
        public void undoExternalChange() {
            if (data != null) {
                FileObject tldFO = data.getPrimaryFile();
                TLDDataObject tdo = ((TLDDataObject)data);
                Taglib taglib = null;
                try {
                    taglib = tdo.getTaglib();
                } catch (IOException ioe) { 
                    //ignore 
                }
                if (taglib != null) /* TODO check validity */ {
                    err.log("undo external change: TaglibTagClassMoveClassRefactoringElement");
                    TagType tag = null;
                    TagType[] tags = taglib.getTag();
                    for (int i=0; i < tags.length; i++) {
                        String tagClass = tags[i].getTagClass();
                        if (newName.equals(tagClass)) {
                            tag = tags[i];
                            break;
                        }
                    }
                    if (tag!=null) {
                        tag.setTagClass(oldName);
                        try {
                            if (tdo != null) {
                                tdo.write(taglib);
                            }
                        } catch (IOException ioe) {
                            ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ioe.getMessage());
                        }
                    }
                }
            }
        }
    }    
    
    
    public final class TaglibTagClassReferenceMoveClassOtherProjectRefactoringElement extends AbstractMoveClassRefactoringElement implements ExternalChange {

        protected DataObject data = null;
        protected DataObject newData = null;

        /** Creates a new instance of TaglibTagClassReferenceMoveClassOtherProjectRefactoringElement */
        public TaglibTagClassReferenceMoveClassOtherProjectRefactoringElement(DataObject data, DataObject newData, String oldName, String newName) { 
            this.data = data;
            this.newData = newData;
            this.oldName = oldName;
            this.newName = newName;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {data.getPrimaryFile().getNameExt(), data.getPrimaryFile().getNameExt(), newData.getPrimaryFile().getNameExt()};
            return MessageFormat.format(NbBundle.getMessage(TldMoveClassRefactoring.class, "TXT_TaglibTagClassReferenceMoveClassOtherProject"), args);
        }

        /** Returns file that the element affects (relates to)
         * @return File
         */
        public FileObject getParentFile() {
            if (data != null) {
                return data.getPrimaryFile();                
            }
            return null;
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            if (data != null) {
                FileObject tldFO = data.getPrimaryFile();
                TLDDataObject tdo = ((TLDDataObject)data);

                FileObject newTldFO = newData.getPrimaryFile();
                TLDDataObject newTdo = ((TLDDataObject)newData);
                
                Taglib taglib = null;
                Taglib newTaglib = null;
                try {
                    taglib = tdo.getTaglib();
                    newTaglib = newTdo.getTaglib();
                } catch (IOException ioe) { 
                    //ignore 
                }
                if ((taglib != null) && (newTaglib != null)) /* TODO check validity */ {
                    err.log("perform external change: TaglibTagClassReferenceMoveClassOtherProject");
                    TagType tag = null;
                    TagType[] tags = taglib.getTag();
                    for (int i=0; i < tags.length; i++) {
                        String tagClass = tags[i].getTagClass();
                        if (oldName.equals(tagClass)) {
                            tag = tags[i];
                            break;
                        }
                    }
                    if (tag != null) {
                        taglib.removeTag(tag);
                        tag.setTagClass(newName);
                        newTaglib.addTag(tag);
                        try {
                            if (tdo != null) {
                                tdo.write(taglib);
                            }
                            if (newTdo != null) {
                                newTdo.write(newTaglib);
                            }
                        } catch (IOException ioe) {
                            ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ioe.getMessage());
                        }
                    }
                }
            }
        }
        
        public void undoExternalChange() {
            if (data != null) {
                FileObject tldFO = data.getPrimaryFile();
                TLDDataObject tdo = ((TLDDataObject)data);

                FileObject newTldFO = newData.getPrimaryFile();
                TLDDataObject newTdo = ((TLDDataObject)newData);
                
                Taglib taglib = null;
                Taglib newTaglib = null;
                try {
                    taglib = tdo.getTaglib();
                    newTaglib = newTdo.getTaglib();
                } catch (IOException ioe) { 
                    //ignore 
                }
                if ((taglib != null) && (newTaglib != null)) /* TODO check validity */ {
                    err.log("perform external change: TaglibTagClassReferenceMoveClassOtherProject");
                    TagType tag = null;
                    TagType[] tags = newTaglib.getTag();
                    for (int i=0; i < tags.length; i++) {
                        String tagClass = tags[i].getTagClass();
                        if (newName.equals(tagClass)) {
                            tag = tags[i];
                            break;
                        }
                    }
                    if (tag != null) {
                        newTaglib.removeTag(tag);
                        tag.setTagClass(oldName);
                        taglib.addTag(tag);
                        try {
                            if (tdo != null) {
                                tdo.write(taglib);
                            }
                            if (newTdo != null) {
                                newTdo.write(newTaglib);
                            }
                        } catch (IOException ioe) {
                            ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ioe.getMessage());
                        }
                    }
                }
            }
        }
    }    
    
    
    public final class TaglibTeiClassMoveClassRefactoringElement extends AbstractMoveClassRefactoringElement implements ExternalChange {

        protected DataObject data = null;

        /** Creates a new instance of TaglibTeiClassMoveClassRefactoringElement */
        public TaglibTeiClassMoveClassRefactoringElement(DataObject data, String oldName, String newName) { 
            this.data = data;
            this.oldName = oldName;
            this.newName = newName;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {data.getPrimaryFile().getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(TldMoveClassRefactoring.class, "TXT_TaglibTeiClassMoveClass"), args);
        }

        /** Returns file that the element affects (relates to)
         * @return File
         */
        public FileObject getParentFile() {
            if (data != null) {
                return data.getPrimaryFile();                
            }
            return null;
        }        

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            if (data != null) {
                FileObject tldFO = data.getPrimaryFile();
                TLDDataObject tdo = ((TLDDataObject)data);
                Taglib taglib = null;
                try {
                    taglib = tdo.getTaglib();
                } catch (IOException ioe) { 
                    //ignore 
                }
                if (taglib != null) /* TODO check validity */ {
                    TagType tag = null;
                    TagType[] tags = taglib.getTag();
                    for (int i=0; i < tags.length; i++) {
                        String teiClass = tags[i].getTagClass();
                        if (oldName.equals(teiClass)) {
                            tag = tags[i];
                            break;
                        }
                    }
                    if (tag!=null) {
                        tag.setTeiClass(newName);
                        try {
                            if (tdo != null) {
                                tdo.write(taglib);
                            }
                        } catch (IOException ioe) {
                            ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ioe.getMessage());
                        }
                    }
                }
            }
        }
        
        public void undoExternalChange() {
            if (data != null) {
                FileObject tldFO = data.getPrimaryFile();
                TLDDataObject tdo = ((TLDDataObject)data);
                Taglib taglib = null;
                try {
                    taglib = tdo.getTaglib();
                } catch (IOException ioe) { 
                    //ignore 
                }
                if (taglib != null) /* TODO check validity */ {
                    TagType tag = null;
                    TagType[] tags = taglib.getTag();
                    for (int i=0; i < tags.length; i++) {
                        String teiClass = tags[i].getTagClass();
                        if (newName.equals(teiClass)) {
                            tag = tags[i];
                            break;
                        }
                    }
                    if (tag!=null) {
                        tag.setTeiClass(oldName);
                        try {
                            if (tdo != null) {
                                tdo.write(taglib);
                            }
                        } catch (IOException ioe) {
                            ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ioe.getMessage());
                        }
                    }
                }
            }
        }
    }        

    
    public final class TaglibTeiClassReferenceMoveClassOtherProjectRefactoringElement extends AbstractMoveClassRefactoringElement implements ExternalChange {

        protected DataObject data = null;
        protected DataObject newData = null;

        /** Creates a new instance of TaglibTeiClassReferenceMoveClassOtherProjectRefactoringElement */
        public TaglibTeiClassReferenceMoveClassOtherProjectRefactoringElement(DataObject data, DataObject newData, String oldName, String newName) { 
            this.data = data;
            this.newData = newData;
            this.oldName = oldName;
            this.newName = newName;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {data.getPrimaryFile().getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(TldMoveClassRefactoring.class, "TXT_TaglibTeiClassReferenceMoveClassOtherProject"), args);
        }

        /** Returns file that the element affects (relates to)
         * @return File
         */
        public FileObject getParentFile() {
            if (data != null) {
                return data.getPrimaryFile();                
            }
            return null;
        }        

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            if (data != null) {
                FileObject tldFO = data.getPrimaryFile();
                TLDDataObject tdo = ((TLDDataObject)data);

                FileObject newTldFO = newData.getPrimaryFile();
                TLDDataObject newTdo = ((TLDDataObject)newData);
                
                Taglib taglib = null;
                Taglib newTaglib = null;
                try {
                    taglib = tdo.getTaglib();
                    newTaglib = newTdo.getTaglib();
                } catch (IOException ioe) { 
                    //ignore 
                }
                if ((taglib != null) && (newTaglib != null)) /* TODO check validity */ {
                    err.log("perform external change: TaglibTagClassReferenceMoveClassOtherProject");
                    TagType tag = null;
                    TagType[] tags = taglib.getTag();
                    for (int i=0; i < tags.length; i++) {
                        String teiClass = tags[i].getTeiClass();
                        if (oldName.equals(teiClass)) {
                            tag = tags[i];
                            break;
                        }
                    }
                    if (tag != null) {
                        taglib.removeTag(tag);
                        tag.setTeiClass(newName);
                        newTaglib.addTag(tag);
                        try {
                            if (tdo != null) {
                                tdo.write(taglib);
                            }
                            if (newTdo != null) {
                                newTdo.write(newTaglib);
                            }
                        } catch (IOException ioe) {
                            ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ioe.getMessage());
                        }
                    }
                }
            }
        }
        
        public void undoExternalChange() {
            if (data != null) {
                FileObject tldFO = data.getPrimaryFile();
                TLDDataObject tdo = ((TLDDataObject)data);

                FileObject newTldFO = newData.getPrimaryFile();
                TLDDataObject newTdo = ((TLDDataObject)newData);
                
                Taglib taglib = null;
                Taglib newTaglib = null;
                try {
                    taglib = tdo.getTaglib();
                    newTaglib = newTdo.getTaglib();
                } catch (IOException ioe) { 
                    //ignore 
                }
                if ((taglib != null) && (newTaglib != null)) /* TODO check validity */ {
                    err.log("undo external change: TaglibTagClassReferenceMoveClassOtherProject");
                    TagType tag = null;
                    TagType[] tags = newTaglib.getTag();
                    for (int i=0; i < tags.length; i++) {
                        String teiClass = tags[i].getTeiClass();
                        if (newName.equals(teiClass)) {
                            tag = tags[i];
                            break;
                        }
                    }
                    if (tag != null) {
                        newTaglib.removeTag(tag);
                        tag.setTeiClass(oldName);
                        taglib.addTag(tag);
                        try {
                            if (tdo != null) {
                                tdo.write(taglib);
                            }
                            if (newTdo != null) {
                                newTdo.write(newTaglib);
                            }
                        } catch (IOException ioe) {
                            ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ioe.getMessage());
                        }
                    }
                }
            }
        }
    }    
    
    
    public final class TaglibFunctionClassMoveClassRefactoringElement extends AbstractMoveClassRefactoringElement implements ExternalChange {

        protected DataObject data;

        /** Creates a new instance of TaglibFunctionClassMoveClassRefactoringElement */
        public TaglibFunctionClassMoveClassRefactoringElement(DataObject data, String oldName, String newName) { 
            this.data = data;
            this.oldName = oldName;
            this.newName = newName;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {data.getPrimaryFile().getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(TldMoveClassRefactoring.class, "TXT_TaglibFunctionClassMoveClass"), args);
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        /** Returns file that the element affects (relates to)
         * @return File
         */
        public FileObject getParentFile() {
            if (data != null) {
                return data.getPrimaryFile();                
            }
            return null;
        }        

        public void performExternalChange() {
            if (data != null) {
                FileObject tldFO = data.getPrimaryFile();
                TLDDataObject tdo = ((TLDDataObject)data);
                Taglib taglib = null;
                try {
                    taglib = tdo.getTaglib();
                } catch (IOException ioe) { 
                    //ignore 
                }
                if (taglib != null) /* TODO check validity */ {            
                    FunctionType function = null;
                    FunctionType[] functions = taglib.getFunction();
                    for (int i=0; i < functions.length; i++) {
                        String functionClass = functions[i].getFunctionClass();
                        if (oldName.equals(functionClass)) {
                            function = functions[i];
                            break;
                        }
                    }
                    if (function!=null) {
                        function.setFunctionClass(newName);
                        try {
                            if (tdo != null) {
                                tdo.write(taglib);
                            }
                        } catch (IOException ioe) {
                            ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ioe.getMessage());
                        }
                    }
                }
            }
        }
        
        public void undoExternalChange() {
            if (data != null) {
                FileObject tldFO = data.getPrimaryFile();
                TLDDataObject tdo = ((TLDDataObject)data);
                Taglib taglib = null;
                try {
                    taglib = tdo.getTaglib();
                } catch (IOException ioe) { 
                    //ignore 
                }
                if (taglib != null) /* TODO check validity */ {
                    FunctionType function = null;
                    FunctionType[] functions = taglib.getFunction();
                    for (int i=0; i < functions.length; i++) {
                        String functionClass = functions[i].getFunctionClass();
                        if (newName.equals(functionClass)) {
                            function = functions[i];
                            break;
                        }
                    }
                    if (function!=null) {
                        function.setFunctionClass(oldName);
                        try {
                            if (tdo != null) {
                                tdo.write(taglib);
                            }
                        } catch (IOException ioe) {
                            ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ioe.getMessage());
                        }
                    }
                }
            }
        }
    }
    
    
    public final class TaglibFunctionClassReferenceMoveClassOtherProjectRefactoringElement extends AbstractMoveClassRefactoringElement implements ExternalChange {

        protected DataObject data = null;
        protected DataObject newData = null;

        /** Creates a new instance of TaglibFunctionClassReferenceMoveClassOtherProjectRefactoringElement */
        public TaglibFunctionClassReferenceMoveClassOtherProjectRefactoringElement(DataObject data, DataObject newData, String oldName, String newName) { 
            this.data = data;
            this.newData = newData;
            this.oldName = oldName;
            this.newName = newName;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {data.getPrimaryFile().getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(TldMoveClassRefactoring.class, "TXT_TaglibFunctionClassReferenceMoveClassOtherProject"), args);
        }

        /** Returns file that the element affects (relates to)
         * @return File
         */
        public FileObject getParentFile() {
            if (data != null) {
                return data.getPrimaryFile();                
            }
            return null;
        }        

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            if (data != null) {
                FileObject tldFO = data.getPrimaryFile();
                TLDDataObject tdo = ((TLDDataObject)data);

                FileObject newTldFO = newData.getPrimaryFile();
                TLDDataObject newTdo = ((TLDDataObject)newData);
                
                Taglib taglib = null;
                Taglib newTaglib = null;
                try {
                    taglib = tdo.getTaglib();
                    newTaglib = newTdo.getTaglib();
                } catch (IOException ioe) { 
                    //ignore 
                }
                if ((taglib != null) && (newTaglib != null)) /* TODO check validity */ {
                    err.log("perform external change: TaglibFunctionClassReferenceMoveClassOtherProjectRefactoringElement");
                    FunctionType function = null;
                    FunctionType[] functions = taglib.getFunction();
                    for (int i=0; i < functions.length; i++) {
                        String functionClass = functions[i].getFunctionClass();
                        if (oldName.equals(functionClass)) {
                            function = functions[i];
                            break;
                        }
                    }
                    if (function != null) {
                        taglib.removeFunction(function);
                        function.setFunctionClass(newName);
                        newTaglib.addFunction(function);
                        try {
                            if (tdo != null) {
                                tdo.write(taglib);
                            }
                            if (newTdo != null) {
                                newTdo.write(newTaglib);
                            }
                        } catch (IOException ioe) {
                            ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ioe.getMessage());
                        }
                    }
                }
            }
        }
        
        public void undoExternalChange() {
            if (data != null) {
                FileObject tldFO = data.getPrimaryFile();
                TLDDataObject tdo = ((TLDDataObject)data);

                FileObject newTldFO = newData.getPrimaryFile();
                TLDDataObject newTdo = ((TLDDataObject)newData);
                
                Taglib taglib = null;
                Taglib newTaglib = null;
                try {
                    taglib = tdo.getTaglib();
                    newTaglib = newTdo.getTaglib();
                } catch (IOException ioe) { 
                    //ignore 
                }
                if ((taglib != null) && (newTaglib != null)) /* TODO check validity */ {
                    err.log("undo external change: TaglibFunctionClassReferenceMoveClassOtherProjectRefactoringElement");
                    FunctionType function = null;
                    FunctionType[] functions = newTaglib.getFunction();
                    for (int i=0; i < functions.length; i++) {
                        String functionClass = functions[i].getFunctionClass();
                        if (newName.equals(functionClass)) {
                            function = functions[i];
                            break;
                        }
                    }
                    if (function != null) {
                        newTaglib.removeFunction(function);
                        function.setFunctionClass(oldName);
                        taglib.addFunction(function);
                        try {
                            if (tdo != null) {
                                tdo.write(taglib);
                            }
                            if (newTdo != null) {
                                newTdo.write(newTaglib);
                            }
                        } catch (IOException ioe) {
                            ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ioe.getMessage());
                        }
                    }
                }
            }
        }
    }        
    
    public final class TaglibValidatorClassMoveClassRefactoringElement extends AbstractMoveClassRefactoringElement implements ExternalChange {

        protected DataObject data;

        /** Creates a new instance of TaglibValidatorClassMoveClassRefactoringElement */
        public TaglibValidatorClassMoveClassRefactoringElement(DataObject data, String oldName, String newName) { 
            this.data = data;
            this.oldName = oldName;
            this.newName = newName;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {data.getPrimaryFile().getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(TldMoveClassRefactoring.class, "TXT_TaglibValidatorClassMoveClass"), args);
        }

        /** Returns file that the element affects (relates to)
         * @return File
         */
        public FileObject getParentFile() {
            if (data != null) {
                return data.getPrimaryFile();                
            }
            return null;
        }        

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            if (data != null) {
                FileObject tldFO = data.getPrimaryFile();
                TLDDataObject tdo = ((TLDDataObject)data);
                Taglib taglib = null;
                try {
                    taglib = tdo.getTaglib();
                } catch (IOException ioe) { 
                    //ignore 
                }
                if (taglib != null) /* TODO check validity */ {            
                    ValidatorType validator = taglib.getValidator();
                    if (validator!=null) {
                        validator.setValidatorClass(newName);
                        try {
                            if (tdo != null) {
                                tdo.write(taglib);
                            }
                        } catch (IOException ioe) {
                            ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ioe.getMessage());
                        }
                    }
                }
            }
        }
        
        public void undoExternalChange() {
            if (data != null) {
                FileObject tldFO = data.getPrimaryFile();
                Taglib taglib = null;
                TLDDataObject tdo = ((TLDDataObject)data);                
                try {
                    taglib = tdo.getTaglib();
                } catch (IOException ioe) { 
                    //ignore 
                }
                if (taglib != null) /* TODO check validity */ {
                    ValidatorType validator = taglib.getValidator();
                    if (validator!=null) {
                        validator.setValidatorClass(oldName);
                        try {
                            if (tdo != null) {
                                tdo.write(taglib);
                            }
                        } catch (IOException ioe) {
                            ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ioe.getMessage());
                        }
                    }
                }
            }
        }
    }

    public final class TaglibValidatorClassReferenceMoveClassOtherProjectRefactoringElement extends AbstractMoveClassRefactoringElement implements ExternalChange {

        protected DataObject data = null;
        protected DataObject newData = null;

        /** Creates a new instance of TaglibValidatorClassReferenceMoveClassOtherProjectRefactoringElement */
        public TaglibValidatorClassReferenceMoveClassOtherProjectRefactoringElement(DataObject data, DataObject newData, String oldName, String newName) { 
            this.data = data;
            this.newData = newData;
            this.oldName = oldName;
            this.newName = newName;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {data.getPrimaryFile().getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(TldMoveClassRefactoring.class, "TXT_TaglibValidatorClassReferenceMoveClassOtherProject"), args);
        }

        /** Returns file that the element affects (relates to)
         * @return File
         */
        public FileObject getParentFile() {
            if (data != null) {
                return data.getPrimaryFile();                
            }
            return null;
        }        

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            if (data != null) {
                FileObject tldFO = data.getPrimaryFile();
                TLDDataObject tdo = ((TLDDataObject)data);

                FileObject newTldFO = newData.getPrimaryFile();
                TLDDataObject newTdo = ((TLDDataObject)newData);
                
                Taglib taglib = null;
                Taglib newTaglib = null;
                try {
                    taglib = tdo.getTaglib();
                    newTaglib = newTdo.getTaglib();
                } catch (IOException ioe) { 
                    //ignore 
                }
                if ((taglib != null) && (newTaglib != null)) /* TODO check validity */ {
                    err.log("perform external change: TaglibValidatorClassReferenceMoveClassOtherProjectRefactoringElement");
                    ValidatorType validator = taglib.getValidator();
                    if (validator != null) {
                        String validatorClass = validator.getValidatorClass();
                        if (oldName.equals(validatorClass)) {
                            
                            // TODO - this is missing in the TLD api, why?
//                            taglib.removeValidator(validator);
//                            validator.setValidatorClass(newName);
//                            newTaglib.addValidator(validator);
                            try {
                                if (tdo != null) {
                                    tdo.write(taglib);
                                }
                                if (newTdo != null) {
                                    newTdo.write(newTaglib);
                                }
                            } catch (IOException ioe) {
                                ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ioe.getMessage());
                            }
                        }
                    }
                }
            }
        }
        
        public void undoExternalChange() {
            if (data != null) {
                FileObject tldFO = data.getPrimaryFile();
                TLDDataObject tdo = ((TLDDataObject)data);

                FileObject newTldFO = newData.getPrimaryFile();
                TLDDataObject newTdo = ((TLDDataObject)newData);
                
                Taglib taglib = null;
                Taglib newTaglib = null;
                try {
                    taglib = tdo.getTaglib();
                    newTaglib = newTdo.getTaglib();
                } catch (IOException ioe) { 
                    //ignore 
                }
                if ((taglib != null) && (newTaglib != null)) /* TODO check validity */ {
                    err.log("undo external change: TaglibValidatorClassReferenceMoveClassOtherProjectRefactoringElement");
                    ValidatorType validator = newTaglib.getValidator();
                    if (validator != null) {
                        String validatorClass = validator.getValidatorClass();
                        if (newName.equals(validatorClass)) {
                                // TODO - this is missing in the TLD api, why?
    //                        newTaglib.removeValidator(validator);
    //                        function.setValidatorClass(oldName);
    //                        taglib.addValidator(validator);
                            try {
                                if (tdo != null) {
                                    tdo.write(taglib);
                                }
                                if (newTdo != null) {
                                    newTdo.write(newTaglib);
                                }
                            } catch (IOException ioe) {
                                ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ioe.getMessage());
                            }
                        }
                    }
                }
            }
        }
    }        
    
    public final class TaglibListenerClassMoveClassRefactoringElement extends AbstractMoveClassRefactoringElement implements ExternalChange {

        protected DataObject data;

        /** Creates a new instance of TaglibListenerClassMoveClassRefactoringElement */
        public TaglibListenerClassMoveClassRefactoringElement(DataObject data, String oldName, String newName) { 
            this.data = data;
            this.oldName = oldName;
            this.newName = newName;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {data.getPrimaryFile().getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(TldMoveClassRefactoring.class, "TXT_TaglibListenerClassMoveClass"), args);
        }

        /** Returns file that the element affects (relates to)
         * @return File
         */
        public FileObject getParentFile() {
            if (data != null) {
                return data.getPrimaryFile();                
            }
            return null;
        }        

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            if (data != null) {
                FileObject tldFO = data.getPrimaryFile();
                TLDDataObject tdo = ((TLDDataObject)data);
                Taglib taglib = null;
                try {
                    taglib = tdo.getTaglib();
                } catch (IOException ioe) { 
                    //ignore 
                }
                if (taglib != null) /* TODO check validity */ {            
                    org.netbeans.modules.web.taglib.model.ListenerType listener = null;
                    org.netbeans.modules.web.taglib.model.ListenerType[] listeners = taglib.getListener();
                    for (int i=0; i < listeners.length; i++) {
                        String listenerClass = listeners[i].getListenerClass();
                        if (oldName.equals(listenerClass)) {
                            listener = listeners[i];
                            break;
                        }
                    }
                    if (listener!=null) {
                        listener.setListenerClass(newName);
                        try {
                            if (tdo != null) {
                                tdo.write(taglib);
                            }
                        } catch (IOException ioe) {
                            ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ioe.getMessage());
                        }
                    }
                }
            }
        }
        
        public void undoExternalChange() {
            if (data != null) {
                FileObject tldFO = data.getPrimaryFile();
                TLDDataObject tdo = ((TLDDataObject)data);
                Taglib taglib = null;
                try {
                    taglib = tdo.getTaglib();
                } catch (IOException ioe) { 
                    //ignore 
                }
                if (taglib != null) /* TODO check validity */ {
                    org.netbeans.modules.web.taglib.model.ListenerType listener = null;
                    org.netbeans.modules.web.taglib.model.ListenerType[] listeners = taglib.getListener();
                    for (int i=0; i < listeners.length; i++) {
                        String listenerClass = listeners[i].getListenerClass();
                        if (newName.equals(listenerClass)) {
                            listener = listeners[i];
                            break;
                        }
                    }
                    if (listener!=null) {
                        listener.setListenerClass(oldName);
                        try {
                            if (tdo != null) {
                                tdo.write(taglib);
                            }
                        } catch (IOException ioe) {
                            ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ioe.getMessage());
                        }
                    }
                }
            }
        }
    }
    
    
    public final class TaglibListenerClassReferenceMoveClassOtherProjectRefactoringElement extends AbstractMoveClassRefactoringElement implements ExternalChange {

        protected DataObject data = null;
        protected DataObject newData = null;

        /** Creates a new instance of TaglibListenerClassReferenceMoveClassOtherProjectRefactoringElement */
        public TaglibListenerClassReferenceMoveClassOtherProjectRefactoringElement(DataObject data, DataObject newData, String oldName, String newName) { 
            this.data = data;
            this.newData = newData;
            this.oldName = oldName;
            this.newName = newName;
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {data.getPrimaryFile().getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(TldMoveClassRefactoring.class, "TXT_TaglibListenerClassReferenceMoveClassOtherProject"), args);
        }

        /** Returns file that the element affects (relates to)
         * @return File
         */
        public FileObject getParentFile() {
            if (data != null) {
                return data.getPrimaryFile();                
            }
            return null;
        }        

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            if (data != null) {
                FileObject tldFO = data.getPrimaryFile();
                TLDDataObject tdo = ((TLDDataObject)data);

                FileObject newTldFO = newData.getPrimaryFile();
                TLDDataObject newTdo = ((TLDDataObject)newData);
                
                Taglib taglib = null;
                Taglib newTaglib = null;
                try {
                    taglib = tdo.getTaglib();
                    newTaglib = newTdo.getTaglib();
                } catch (IOException ioe) { 
                    //ignore 
                }
                if ((taglib != null) && (newTaglib != null)) /* TODO check validity */ {
                    err.log("perform external change: TaglibListenerClassReferenceMoveClassOtherProjectRefactoringElement");
                    ListenerType listener = null;
                    ListenerType[] listeners = taglib.getListener();
                    for (int i=0; i < listeners.length; i++) {
                        String listenerClass = listeners[i].getListenerClass();
                        if (oldName.equals(listenerClass)) {
                            listener = listeners[i];
                            break;
                        }
                    }
                    if (listener != null) {
                        taglib.removeListener(listener);
                        listener.setListenerClass(newName);
                        newTaglib.addListener(listener);
                        try {
                            if (tdo != null) {
                                tdo.write(taglib);
                            }
                            if (newTdo != null) {
                                newTdo.write(newTaglib);
                            }
                        } catch (IOException ioe) {
                            ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ioe.getMessage());
                        }
                    }
                }
            }
        }
        
        public void undoExternalChange() {
            if (data != null) {
                FileObject tldFO = data.getPrimaryFile();
                TLDDataObject tdo = ((TLDDataObject)data);

                FileObject newTldFO = newData.getPrimaryFile();
                TLDDataObject newTdo = ((TLDDataObject)newData);
                
                Taglib taglib = null;
                Taglib newTaglib = null;
                try {
                    taglib = tdo.getTaglib();
                    newTaglib = newTdo.getTaglib();
                } catch (IOException ioe) { 
                    //ignore 
                }
                if ((taglib != null) && (newTaglib != null)) /* TODO check validity */ {
                    err.log("undo external change: TaglibListenerClassReferenceMoveClassOtherProjectRefactoringElement");
                    ListenerType listener = null;
                    ListenerType[] listeners = newTaglib.getListener();
                    for (int i=0; i < listeners.length; i++) {
                        String listenerClass = listeners[i].getListenerClass();
                        if (newName.equals(listenerClass)) {
                            listener = listeners[i];
                            break;
                        }
                    }
                    if (listener != null) {
                        newTaglib.removeListener(listener);
                        listener.setListenerClass(oldName);
                        taglib.addListener(listener);
                        try {
                            if (tdo != null) {
                                tdo.write(taglib);
                            }
                            if (newTdo != null) {
                                newTdo.write(newTaglib);
                            }
                        } catch (IOException ioe) {
                            ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ioe.getMessage());
                        }
                    }
                }
            }
        }
    }    
    
}
