/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.j2ee.refactoring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.jmi.javamodel.AnnotableElement;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceUtils;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.Entity;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

/**
 * Utility methods for persistence related refactorings.
 * @author Erno Mononen
 */
public class PersistenceRefactoringUtil {
    
    private PersistenceRefactoringUtil() {
    }
    
    /**
     * @return list of FileObjects representing persistence dd files
     * in the project of the given <code>javaClass</code>.
     */
    public static List<FileObject> getPersistence(JavaClass javaClass){
        
        List<FileObject> result = new ArrayList<FileObject>();
        
        Project project = getProject(javaClass);
        if (project != null){
            PersistenceScope[] persistenceScopes = PersistenceUtils.getPersistenceScopes(project);
            for (int i = 0; i < persistenceScopes.length; i++) {
                result.add(persistenceScopes[i].getPersistenceXml());
            }
        }
        
        return result;
    }
    
    /**
     * @return the project of the given <code>javaClass</code>.
     */
    public static Project getProject(JavaClass javaClass){
        Resource res = javaClass.getResource();
        FileObject fo = JavaModel.getFileObject(res);
        return FileOwnerQuery.getOwner(fo);
    }
    
    /**
     * Gets all entities from the project to which given <code>javaClass</code>
     * belongs to.
     */
    public static List<JavaClass> getEntitiesInProject(JavaClass javaClass){
        List<JavaClass> result = new ArrayList<JavaClass>();
        Project project = getProject(javaClass);
        
        Set<Entity> entities = null;
        try {
            entities = PersistenceUtils.getEntityClasses(project);
        } catch (IOException e) {
            ErrorManager.getDefault().notify(e);
            return Collections.emptyList();
        }
        
        JMIUtils.beginJmiTransaction();
        boolean rollback = true;
        try{
            for (Entity entity : entities) {
                JavaClass jc = (JavaClass) JavaModel.getDefaultExtent().getType().resolve(entity.getClass2());
                result.add(jc);
            }
            rollback = false;
        } finally {
            JMIUtils.endJmiTransaction(rollback);
        }
        return result;
    }
    
    /**
     * @return true if given element represents an annotated entity.
     */
    public static boolean isEntity(AnnotableElement element){
        
        if (element == null || element.getAnnotations() == null){
            return false;
        }
        
        String entityAnnotation = "javax.persistence.Entity";
        Annotation annots[] = (Annotation[]) element.getAnnotations().toArray(new Annotation[]{});
        
        for (Annotation ann : annots) {
            AnnotationType atype = ann.getType();
            if (atype != null && entityAnnotation.equals(atype.getName())){
                return true;
            }
        }
        
        return false;
    }
    
}
