/* *************************************************************************
 *
 *          Copyright (c) 2005, SeeBeyond Technology Corporation,
 *          All Rights Reserved
 *
 *          This program, and all the routines referenced herein,
 *          are the proprietary properties and trade secrets of
 *          SEEBEYOND TECHNOLOGY CORPORATION.
 *
 *          Except as provided for by license agreement, this
 *          program shall not be duplicated, used, or disclosed
 *          without  written consent signed by an officer of
 *          SEEBEYOND TECHNOLOGY CORPORATION.
 *
 ***************************************************************************/
package org.netbeans.modules.workflow.project.anttasks;

import javax.xml.namespace.QName;

public class WorkflowMapEntry {
    public static final String REQUEST_REPLY_SERVICE = "requestReplyService";
    public static final String FILTER_ONE_WAY = "filterOneWay";
    public static final String FILTER_REQUEST_REPLY = "filterRequestReply";
    
    public static final String INPUT_MESSAGE_TYPE = "input";
    public static final String OUTPUT_MESSAGE_TYPE = "output";
    public static final String REPLY_MESSAGE_TYPE = "reply";

    private String mType;
    private QName mPartnerLink;
    private QName mPortType;
    private String mRoleName;
    
    private QName mOutPartnerLink;
    private QName mOutPortType;
    private String mOutRoleName;
    
    
    /**
     * Creates a new instance of PortMapEntry
     */
    private WorkflowMapEntry(String type, 
                         QName partnerLink, 
                         QName portType, 
                         String roleName, 
                         QName outPartnerLink, 
                         QName outPortType, 
                         String outRoleName) 
    {
        mType = type;
        mPartnerLink = partnerLink;
        mPortType = portType;
        mRoleName = roleName;
        
        mOutPartnerLink = outPartnerLink;
        mOutPortType = outPortType;
        mOutRoleName = outRoleName;
    }
    
    public static WorkflowMapEntry newRequestReplyService(QName partnerLink, 
                                                      QName portType, 
                                                      String roleName) 
    {
        return new WorkflowMapEntry(REQUEST_REPLY_SERVICE, 
                                partnerLink, 
                                portType, 
                                roleName, 
                                null, null, null); 
    }
    
    public static WorkflowMapEntry newFilterOneWay(QName partnerLink, 
                                               QName portType, 
                                               String roleName,
                                               QName outPartnerLink, 
                                               QName outPortType, 
                                               String outRoleName) 
    {
        return new WorkflowMapEntry(FILTER_ONE_WAY, 
                                partnerLink, 
                                portType, 
                                roleName, 
                                outPartnerLink, 
                                outPortType, 
                                outRoleName); 
    }
    
    public static WorkflowMapEntry newFilterRequestReply(QName partnerLink, 
                                                     QName portType, 
                                                     String roleName,
                                                     QName outPartnerLink, 
                                                     QName outPortType, 
                                                     String outRoleName) 
    {
        return new WorkflowMapEntry(FILTER_REQUEST_REPLY, 
                                partnerLink, 
                                portType, 
                                roleName, 
                                outPartnerLink, 
                                outPortType, 
                                outRoleName); 
    }
    
    public String getType() {
        assert mType != null;
        return mType;
    }
    
    public QName getPartnerLink() {
        assert mPartnerLink != null;
        return mPartnerLink;
    }
    
    public QName getPortType() {
        return mPortType;
    }
    
    public String getRoleName() {
        return mRoleName;
    }
    
    public QName getOutPartnerLink() {
        return mOutPartnerLink;
    }
    
    public QName getOutPortType() {
        return mOutPortType;
    }
    
    public String getOutRoleName() {
        return mOutRoleName;
    }
    
}
