/*
 * UsersTableModel.java
 * 
 * Created on Jun 22, 2007, 3:27:34 PM
 * 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.netbeans.modules.worklist.wizard;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

/**
 *
 * @author radval
 */
public class GroupsTableModel extends AbstractTableModel {

        private List<Group> groups = new ArrayList<Group>();
        
        public int getRowCount() {
            return groups.size();
        }

        public int getColumnCount() {
            return 1;
        }

        public List<Group> getGroups() {
            return this.groups;
        }
        
        public Object getValueAt(int rowIndex, int columnIndex) {
            Group group = groups.get(rowIndex);
            if(group != null) {
                return group.getGroupName();
            }
            
            return "";
        }
        
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            Group group = groups.get(rowIndex);
            if(group != null) {
                group.setGroupName((String)aValue);
            }
        }
         
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }
         
        public void addNewGroup(Group group) {
            if(group != null) {
                groups.add(group);
                fireTableDataChanged();
            }
        }
        
        public void addNewRow() {
            Group group = new Group("");
            groups.add(group);
            fireTableDataChanged();
        }
        
        public void removeRow(int row) {
            if(groups.size() > row)  {
                groups.remove(row);
            }
            fireTableDataChanged();
        }
        
        
        public class Group {
            
            private String group;
            
            public Group(String group) {
                this.group = group;
            }
            
            public void setGroupName(String group) {
                this.group = group;
            }
            
            public String getGroupName() {
                return this.group;
            }
            
            public String toString() {
                return this.group;
            }
        }
}
