/*
 * TaskDefinitionPanel.java
 *
 * Created on May 24, 2007, 3:21 PM
 */

package org.netbeans.modules.worklist.editor.multiview.assignment;


import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.wlm.model.api.TAssignment;
import org.netbeans.modules.wlm.model.api.TTask;
import org.netbeans.modules.wlm.model.api.User;
import org.netbeans.modules.wlm.model.api.WLMComponentFactory;
import org.netbeans.modules.wlm.model.api.WLMModel;
import org.netbeans.modules.worklist.dataloader.WorklistDataObject;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;

/**
 *
 * @author  radval
 */
public class UsersPanel extends SectionInnerPanel {
    
    private WorklistDataObject dObj;
    
    private UserTableModel usersTableModel;
    
    private TAssignment assignment;
    
     /** Creates new form AssignmentPanel */
    public UsersPanel(SectionView sectionView, 
                      WorklistDataObject dObj) {
        
        super(sectionView);
        this.dObj=dObj;
        
        initComponents();
        initGUI();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        usersTable = new javax.swing.JTable();
        addButton = new javax.swing.JButton();
        removeButton = new javax.swing.JButton();

        usersTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        jScrollPane1.setViewportView(usersTable);

        addButton.setLabel(org.openide.util.NbBundle.getMessage(UsersPanel.class, "UsersPanel.addButton.label")); // NOI18N
        addButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addButtonActionPerformed(evt);
            }
        });

        removeButton.setLabel(org.openide.util.NbBundle.getMessage(UsersPanel.class, "UsersPanel.removeButton.label")); // NOI18N
        removeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                removeButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(addButton)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(removeButton))
                    .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 375, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(15, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(12, 12, 12)
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 126, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(addButton)
                    .add(removeButton))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

private void removeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeButtonActionPerformed
    int selectedRow = usersTable.getSelectedRow();
    usersTableModel.removeRow(selectedRow);
}//GEN-LAST:event_removeButtonActionPerformed

    private void addButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addButtonActionPerformed
     usersTableModel.addNewRow();
     if(usersTableModel.getRowCount() != 0) {
        usersTable.setRowSelectionInterval(usersTableModel.getRowCount() -1, usersTableModel.getRowCount()-1);
     }
}//GEN-LAST:event_addButtonActionPerformed
    
    public void linkButtonPressed(Object ddBean, String property) {
    }
    
    public javax.swing.JComponent getErrorComponent(String name) {
        return null;
    }
    
    public void setValue(JComponent source, Object value)  {
        
    }
    
    public void documentChanged(javax.swing.text.JTextComponent comp, String value) {
    }
    
    public void rollbackValue(javax.swing.text.JTextComponent source) {
    }
    
    private void initGUI() {
        usersTableModel = new UserTableModel();
        usersTable.setModel(usersTableModel);
        usersTable.setTableHeader(null);
        usersTable.getSelectionModel().addListSelectionListener(new UsersTableListSelectionListener());
        
        dObj.getModel().addComponentListener(new AssignmentComponentListener());
    }
    
    public void refreshUsers(TAssignment assignment) {
            this.assignment = assignment;
            usersTableModel.clear();
            if(assignment != null) {
                List<User> users = assignment.getUsers();
                if(users != null) {
                    Iterator <User> itUser = users.iterator();
                    while(itUser.hasNext()) {
                        User user = itUser.next();
                        usersTableModel.addNewUser(user);
                    }
                }


            }
        
        
    }
    

    class UsersTableListSelectionListener implements ListSelectionListener {

        public void valueChanged(ListSelectionEvent e) {
             int selectedRows = usersTable.getSelectedRowCount();
             boolean rowSelected = selectedRows != 0 ? true : false;
             
             removeButton.setEnabled(rowSelected);
        }
        
    }
    class UserTableModel extends AbstractTableModel {

        private List<User> users = new ArrayList<User>();
        
        public int getRowCount() {
            return users.size();
        }

        public int getColumnCount() {
            return 1;
        }
        
        public void clear() {
            this.users.clear();
        }
        
        public Object getValueAt(int rowIndex, int columnIndex) {
            User user = users.get(rowIndex);
            if(user != null) {
                return user.getContent();
            }
            
            return "";
        }
        
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            User user = users.get(rowIndex);
            if(user != null) {
                WLMModel model = dObj.getModel();
                if(model != null) {
                    model.startTransaction();
                    user.setContent((String)aValue);
                    model.endTransaction();
                }
            }
        }
         
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }
         
        public void addNewUser(User user) {
            if(user != null) {
                users.add(user);
                fireTableDataChanged();
            }
        }
        
        public void addNewRow() {
            WLMModel model = dObj.getModel();
            if(model != null && assignment != null) {
                WLMComponentFactory factory = model.getFactory();
                User user = factory.createUser(model);
                model.startTransaction();
                assignment.addUser(user);
                users.add(user);
                model.endTransaction();
                fireTableDataChanged();
            }
            
            
        }
        
        public void removeRow(int row) {
            if(users.size() > row)  {
                users.remove(row);
            }
            fireTableDataChanged();
        }
    }
    
    private class AssignmentComponentListener implements ComponentListener {

        public void valueChanged(ComponentEvent evt) {
            refresh(evt);
        }

        public void childrenAdded(ComponentEvent evt) {
            refresh(evt);
        }

        public void childrenDeleted(ComponentEvent evt) {
            refresh(evt);
        }
        
        private void refresh(ComponentEvent evt) {
            Object source = evt.getSource();
            if(source instanceof User) {
                refreshUsers(UsersPanel.this.assignment);
            }
        }
    }   
      
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton addButton;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JButton removeButton;
    private javax.swing.JTable usersTable;
    // End of variables declaration//GEN-END:variables
    
    
    
}
