/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * 
 * Copyright 2005 Sun Microsystems, Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */
package org.netbeans.modules.prjwizard.snmp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

/**
 * Wizard to for SNMP collaboration.
 */
public class SNMPWizardImpl extends SNMPWizard {
    
        /** Key name used to reference database sources in wizard context. */
    //public static final String DATABASE_SOURCES = "database_sources";
    public static final String DEVICE_NAME = "device_name";
    /** Key name used to reference JNDI Name. */
    

    public static final String LOGIN_NAME = "login_name";

    public static final String ENABLE_PASSWORD = "enable_password";

    public static final String DEVICE_PASSWORD = "device_password";
    

    public static final String READ_COMMUNITY = "read_community";

    public static final String WRITE_COMMUNITY = "write_community";

    public static final String TRANSPORT_TYPE = "transport_type";
    
    public static final String IP_ADDRESS = "ip_address";
    
    public static final String IP_ADDRESS_SELECTED = "ip_address_selected";

    public static final String DEVICE_PORT = "device_port";

    /** Key name used to reference List of source tables in wizard context. */
    public static final String SOURCE_TABLES = "source_tables";

    /* Defines panels to be displayed */
    private WizardDescriptor descriptor;

    /* Wizard iterator; handles display and movement among wizard panels */
    private DeviceManagerWizardIterator iterator;

    private Project project;

    
    /**
     * 
     *
     */
    public SNMPWizardImpl() {
    }

     public SNMPWizardImpl(Project prj) {
        this.project = prj;
    }

    public static WizardDescriptor.Iterator newTemplateIterator() {
        final SNMPWizardImpl wizard = new SNMPWizardImpl();
        wizard.initialize();
        return wizard.getIterator();
    }

    /**
     * @see SNMPWizard#getDescriptor
     */
    public WizardDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new Descriptor(this.iterator);
        }
        return this.descriptor;
    }

    public void setDescriptor(final WizardDescriptor wd) {
        this.descriptor = wd;
    }

    /**
     * @see JDBCWizard#getIterator
     */
    public WizardDescriptor.Iterator getIterator() {
        return this.iterator;
    }

    // public Project getProject() {
    // return project;
    // }

    /**
     * Initializes iterator and descriptor for this wizard.
     */
    public void initialize() {
        this.iterator = new WizardIterator(this);

    }

    /**
     * Performs processing to handle cancellation of this wizard.
     */
    protected void cancel() {
    }

    /**
     * Performs processing to cleanup any resources used by this wizard.
     */
    protected void cleanup() {
    }

    protected String getDialogTitle() {
        return NbBundle.getMessage(SNMPWizardImpl.class, "TITLE_dlg_new_collab");
    }

    
    class Descriptor extends SNMPWizardDescriptor {
        public Descriptor(final WizardDescriptor.Iterator iter) {
            super(iter, SNMPWizardImpl.this.context);
        }
    }

    class WizardIterator extends DeviceManagerWizardIterator {
        private WizardDescriptor.Panel collaborationNamePanel;
        private DeviceManagerWizardPanel1 credentialSetPanel;
        private DeviceManagerWizardPanel2 deviceDiscoveryPanel;
        private DeviceManagerWizardPanel3 devicesDiscoveredReportPanel;
        private List panels;
        private SNMPWizardImpl mWizard;

        public WizardIterator(final SNMPWizardImpl wizard) {
            this.mWizard = wizard;
            this.collaborationNamePanel = new DeviceManagerWizardPanel4(SNMPWizardImpl.this, NbBundle.getMessage(
                    SNMPWizardImpl.class, "TITLE_tblwizard_name"));
        }

        @Override
        public String name() {
            return "";
        }

        @Override
        public void initialize(final WizardDescriptor wiz) {
            this.mWizard.setDescriptor(wiz);
            super.initialize(wiz);
        }

        /**
         * Overrides parent implementation to test for duplicate collab name before advancing to
         * next panel, and skip join panel if fewer than two source tables are selected.
         * 
         * @see org.openide.WizardDescriptor.Iterator#nextPanel
         */
        public void nextPanel() {
            super.nextPanel(); // Otherwise allow advance.

        }

        /**
         * Overrides parent implementation to skip join panel if fewer than two source tables are
         * selected.
         * 
         * @see org.openide.WizardDescriptor.Iterator#previousPanel
         */
        public void previousPanel() {
            super.previousPanel(); // Otherwise use parent implementation.
        }

        @SuppressWarnings("unchecked")
        protected List createPanels(final WizardDescriptor wiz) {
            final List srcModel = new ArrayList();
            final List destModel = new ArrayList();

            final List dbModels = new ArrayList();

            final List sourceDBModels = new ArrayList();
            final List targetDBModels = new ArrayList();

            Project project = Templates.getProject(wiz);
            if (project != null) {
                Sources sources = ProjectUtils.getSources(project);
                SourceGroup[] groups = sources.getSourceGroups(Sources.TYPE_GENERIC);

                if (groups == null || groups.length < 1) {
                    groups = sources.getSourceGroups(Sources.TYPE_GENERIC);
                }
                // This panel happens to the finishable panel
                this.collaborationNamePanel = new DeviceManagerWizardPanel4(project, groups, null, false);
            }

            this.credentialSetPanel = new DeviceManagerWizardPanel1(NbBundle.getMessage(SNMPWizardImpl.class,
                    "TITLE_tblwizard_selecttableobjects"));
            this.credentialSetPanel.initialize(this.mWizard);
            this.deviceDiscoveryPanel = new DeviceManagerWizardPanel2(NbBundle.getMessage(SNMPWizardImpl.class,
                    "TITLE_tblwizard_selectsources"));

            this.devicesDiscoveredReportPanel = new DeviceManagerWizardPanel3(NbBundle.getMessage(SNMPWizardImpl.class,
                    "STEP_tblwizard_jndiname"));

            this.panels = new ArrayList(4);
            
            this.panels.add(this.credentialSetPanel);
            this.panels.add(this.deviceDiscoveryPanel);
            this.panels.add(this.devicesDiscoveredReportPanel);
            if (this.collaborationNamePanel != null) {
                this.panels.add(this.collaborationNamePanel);
            }
            return Collections.unmodifiableList(this.panels);
        }

        protected String[] createSteps() {
            try {
                return new String[] {
                        // TODO - need make wizard steps text match actual panel being viewed
                        NbBundle.getMessage(SNMPWizardImpl.class, "STEP_tblWizard_FileType"), 
                        NbBundle.getMessage(SNMPWizardImpl.class, "STEP_tblwizard_jndiname"), 
                        NbBundle.getMessage(SNMPWizardImpl.class, "STEP_tblwizard_name"),
                        NbBundle.getMessage(SNMPWizardImpl.class, "STEP_tblwizard_select"),
                        NbBundle.getMessage(SNMPWizardImpl.class, "STEP_tblwizard_sources")
                        
                };
            } catch (final MissingResourceException e) {
                return new String[] {};
            }
        }
    }
}
