/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.script.project.prjwizard;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;

/** 
 * @author Raghunadh Teegavarapu
 * @version 1.0
 */
public class PanelConfigureProject implements WizardDescriptor.FinishablePanel {

    private ChangeListenerSupport changeListenersSupport;
    private WizardDescriptor wizardDescriptor;
    private PanelConfigureProjectVisual component;
    private String defaultName;
    
    public PanelConfigureProject(String defaultName) {
        this.defaultName = defaultName;
        changeListenersSupport = new ChangeListenerSupport();
    }

    public boolean isFinishPanel() {
        return true;
    }

    public Component getComponent() {
        if (component == null) {
            component = new PanelConfigureProjectVisual(this);
        }
        return component;
    }

    // TODO m
    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public void readSettings(Object settings) {
        assert settings instanceof WizardDescriptor;
        wizardDescriptor = (WizardDescriptor) settings;
        component.read(wizardDescriptor);
        
        // XXX hack, TemplateWizard in final setTemplateImpl() forces new wizard's title
        // this name is used in NewProjectWizard to modify the title
        Object substitute = ((JComponent) component).getClientProperty("NewProjectWizard_Title"); // NOI18N
        if (substitute != null) {
            wizardDescriptor.putProperty("NewProjectWizard_Title", substitute); // NOI18N
        }
    }

    public void storeSettings(Object settings) {
        assert settings instanceof WizardDescriptor;
        WizardDescriptor d = (WizardDescriptor) settings;
        component.store(d);
        ((WizardDescriptor) d).putProperty("NewProjectWizard_Title", null); // NOI18N
    }

    public boolean isValid() {
        getComponent();
        return component.valid(wizardDescriptor);
    }

    // todo m
    protected final void fireChangeEvent() {
        changeListenersSupport.fireChangeEvent(new ChangeEvent(this));
    }
    
    public void addChangeListener(ChangeListener l) {
        changeListenersSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        changeListenersSupport.removeChangeListener(l);
    }
    
}
