/*
 *  Copyright (c) 2005, 2006 Imola Informatica.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the LGPL License v2.1
 *  which accompanies this distribution, and is available at
 *  http://www.gnu.org/licenses/lgpl.html
 */


package it.imolinfo.jbi4cics.netbeansplugin.cpy2wsdlwizard;

import java.io.IOException;
import org.openide.filesystems.FileObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.text.DataEditorSupport;

public class CPYDataObject extends MultiDataObject {

    public CPYDataObject(final FileObject pf, final CPYDataLoader loader)
            throws IOException {
        super(pf, loader);
        CookieSet cookies = getCookieSet();

        cookies.add((Node.Cookie)
                    DataEditorSupport.create(this, getPrimaryEntry(), cookies));
    }

    @Override
    protected Node createNodeDelegate() {                       // Overridden
        return new CPYDataNode(this);
    }
}
