/*
 * The contents of this file are subject to the terms of the Common
 * Development and Distribution License (the License). You may not use this
 * file except in compliance with the License.  You can obtain a copy of the
 * License at http://www.netbeans.org/cddl.html

 * When distributing Covered Code, include this CDDL Header Notice in each
 * file and include the License. If applicable, add the following below the
 * CDDL Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"

 * Copyright 2006 Sun Microsystems, Inc. All Rights Reserved
 *
 */


package org.netbeans.modules.aspect.editor.multiview;

import org.netbeans.modules.aspect.editor.dataobject.AspectDataEditorSupport;
import org.netbeans.modules.aspect.editor.dataobject.AspectDataObject;
import org.openide.cookies.SaveCookie;
import org.openide.util.lookup.ProxyLookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.Lookup;
import org.openide.text.NbDocument;
import org.openide.text.CloneableEditor;
import org.openide.nodes.Node;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.core.spi.multiview.CloseOperationState;

import javax.swing.*;
import javax.swing.text.Document;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectInput;

/**
 *
 * @author Jeri Lockhart
 */
public class AspectSourceMultiViewElement extends CloneableEditor implements MultiViewElement {

    static final long serialVersionUID = 4403502726950453345L;

    transient private  JComponent toolbar;
    transient private  MultiViewElementCallback multiViewObserver;
    private AspectDataObject obj;


    // Do NOT remove. Only for externalization //
    public AspectSourceMultiViewElement() {
        super();
    }

    // Creates new editor //
    public AspectSourceMultiViewElement(AspectDataObject obj) {
        super(obj.getAspectDataEditorSupport());
        this.obj = obj;


        setActivatedNodes(new Node[] {obj.getNodeDelegate()});
        initialize();
    }

    public JComponent getToolbarRepresentation() {
        Document doc = getEditorPane().getDocument();
        if (doc instanceof NbDocument.CustomToolbar) {
            if (toolbar == null) {
                toolbar = ((NbDocument.CustomToolbar) doc).createToolbar(getEditorPane());
            }
            return toolbar;
        }
        return null;
    }

    public JComponent getVisualRepresentation() {
        return this;
    }

    public void setMultiViewCallback(MultiViewElementCallback callback) {
        multiViewObserver = callback;
    }

    @Override
    public void requestVisible() {
        if (multiViewObserver != null)
            multiViewObserver.requestVisible();
        else
            super.requestVisible();
    }

    @Override
    public void requestActive() {
        if (multiViewObserver != null)
            multiViewObserver.requestActive();
        else
            super.requestActive();
    }

    @Override
    protected String preferredID() {

        return "AspectSourceMultiViewElementTC";  //  NOI18N
    }

    /**
     * The close last method should be called only for the last clone.
     * If there are still existing clones this method must return false. The
     * implementation from the FormEditor always returns true but this is
     * not the expected behavior. The intention is to close the editor support
     * once the last editor has been closed, using the silent close to avoid
     * displaying a new dialog which is already being displayed via the
     * close handler.
     */
    @Override
    protected boolean closeLast() {
        AspectDataEditorSupport support = obj.getAspectDataEditorSupport();
        JEditorPane[] editors = support.getOpenedPanes();
        if (editors == null || editors.length == 0) {
            return support.silentClose();
        }
        return false;
    }

    public CloseOperationState canCloseElement() {
        // if this is not the last cloned xml editor component, closing is OK
        if (!AspectDataEditorSupport.isLastView(multiViewObserver.getTopComponent())) {
            return CloseOperationState.STATE_OK;
        }
        // return a placeholder state - to be sure our CloseHandler is called
        return MultiViewFactory.createUnsafeCloseState(
                "ID_TEXT_CLOSING", // dummy ID // NOI18N
                MultiViewFactory.NOOP_CLOSE_ACTION,
                MultiViewFactory.NOOP_CLOSE_ACTION);
    }

    @Override
    public void componentDeactivated() {
        super.componentDeactivated();
        AspectDataEditorSupport editor = obj.getAspectDataEditorSupport();
        SaveCookie save = (SaveCookie) obj.getCookie(SaveCookie.class);
        if(save != null) {
            editor.syncModel();    
        }        
    }

    @Override
    public void componentActivated() {
        super.componentActivated();
        AspectDataEditorSupport editor = obj.getAspectDataEditorSupport();
    }

    @Override
    public void componentClosed() {
        super.componentClosed();
    }

    @Override
    public void componentShowing() {
        super.componentShowing();
        AspectDataEditorSupport editor = obj.getAspectDataEditorSupport();
        SaveCookie save = (SaveCookie) obj.getCookie(SaveCookie.class);
        if(save != null) {
            editor.synchDocument();
        }        

    }

    @Override
    public void componentHidden() {
        super.componentHidden();
        AspectDataEditorSupport editor = obj.getAspectDataEditorSupport();
        // Sync model before having undo manager listen to the model,
        // lest we get redundant undoable edits added to the queue.
        editor.syncModel();
    }

    @Override
    public void componentOpened() {
        super.componentOpened();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(obj);
    }

    @Override
    public void readExternal(ObjectInput in)
    throws IOException, ClassNotFoundException {
        super.readExternal(in);
        Object firstObject = in.readObject();
        if (firstObject instanceof AspectDataObject) {
            obj = (AspectDataObject) firstObject;
            initialize();
        }
    }

    private void initialize() {    
    }

    protected boolean isActiveTC()
    {
        return getRegistry().getActivated() == multiViewObserver.getTopComponent();
    }
}