/*
 * The contents of this file are subject to the terms of the Common
 * Development and Distribution License (the License). You may not use this
 * file except in compliance with the License.  You can obtain a copy of the
 * License at http://www.netbeans.org/cddl.html

 * When distributing Covered Code, include this CDDL Header Notice in each
 * file and include the License. If applicable, add the following below the
 * CDDL Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"

 * Copyright 2006 Sun Microsystems, Inc. All Rights Reserved
 *
 */

package org.netbeans.modules.aspect.editor.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/**
 * This model holds the details of the aspectmap.
 * @author karthikeyan s
 */
public class AspectMapModel {
    
    private File aspectMap;
    
    private List<Aspect> aspects;
    
    private boolean isDirty = false;
    
    
    /**
     * Creates a new instance of AspectMapModel
     */
    public AspectMapModel(File aspectMap) {
        this.aspectMap = aspectMap;
        aspects = new ArrayList<Aspect>();
        parse();
    }
    
    private void parse() {
        Element root = parseXML();
        NodeList aspectElements = root.getElementsByTagName(AspectMap.ASPECT);
        for(int i = 0; i < aspectElements.getLength(); i++) {
            Element aspectElem = (Element)aspectElements.item(i);
            aspects.add(new Aspect(aspectElem));
        }
    }
    
    public List<Aspect> getAspects() {
        return aspects;
    }
    
    public void addAspect(Aspect asp) {
        aspects.add(asp);
        setDirty(true);
    }
    
    public void removeAspect(Aspect asp) {
        aspects.remove(asp);
        setDirty(true);
    }
    
    public void clearAspects() {
        aspects.clear();
    }
    
    public void setAspects(List<Aspect> aspList) {
        aspects = aspList;
    }

    private Element parseXML() {
        Element root = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(aspectMap);
            root = document.getDocumentElement();
        } catch (IOException ex) {
            //ignore
        } catch (ParserConfigurationException ex) {
            //ignore
        } catch (SAXException ex) {
            //ignore
        }
        return root;
    }
    
    public String toXMLString() {
        StringBuffer xmlString = new StringBuffer();
        xmlString.append("<aspectmap xmlns='http://xml.sun.jbi.aspects/schema/AspectMap' " +
                "xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' " +
                "xsi:schemaLocation='http://xml.sun.jbi.aspects/schema/AspectMap aspectmap.xsd'>\n");
        Iterator it = aspects.iterator();
        while(it.hasNext()) {
            Aspect asp = (Aspect)it.next();
            xmlString.append(asp.toXMLString() + "\n");
        }
        xmlString.append("</aspectmap>");
        return xmlString.toString();
    }

    public void setDirty(boolean dirty) {
        isDirty = dirty;
    }
    
    public boolean isDirty() {
        return isDirty;
    }
}