/*
 * The contents of this file are subject to the terms of the Common
 * Development and Distribution License (the License). You may not use this
 * file except in compliance with the License.  You can obtain a copy of the
 *  License at http://www.netbeans.org/cddl.html
 *
 * When distributing Covered Code, include this CDDL Header Notice in each
 * file and include the License. If applicable, add the following below the
 * CDDL Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All Rights Reserved
 *
 */

package org.netbeans.modules.aspect.editor.graph;

import java.awt.Dialog;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;

import org.netbeans.api.visual.action.AcceptProvider;
import org.netbeans.api.visual.action.ConnectorState;
import org.netbeans.api.visual.widget.Widget;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

import org.netbeans.modules.aspect.editor.dataobject.AspectDataObject;
import org.netbeans.modules.aspect.editor.graph.AspectEditorPane;
import org.netbeans.modules.aspect.editor.graph.panels.AddAdvicePanel;
import org.netbeans.modules.aspect.editor.jaxbmodel.AdviceType;
import org.netbeans.modules.aspect.editor.mapbuilder.AspectMapBuilder;
import org.netbeans.modules.aspect.editor.palette.Operator;

/**
 * This class implements the accept provider.
 * This can accept the palette items and act accordingly.
 *
 * @author karthikeyan s
 */
public class SceneAcceptProvider implements AcceptProvider {
    
    private AspectDataObject mObj;
    
    private AspectEditorPane pane;
    
    public SceneAcceptProvider(AspectDataObject dObj, AspectEditorPane pane) {
        this.mObj = dObj;
        this.pane = pane;
    }
    
    public ConnectorState isAcceptable(Widget widget, Point point, Transferable transferable) {
        boolean accept = true;
        try {
            Object node = transferable.getTransferData(
                    new DataFlavor(DataFlavor.javaJVMLocalObjectMimeType));
            Operator op = (Operator) node;
            String type = op.getName();
            if(type.equalsIgnoreCase("Nothing")) {
                accept = false;
            }
        } catch (Exception ex) {
            accept = false;
        }
        if(!accept) {
            return ConnectorState.REJECT_AND_STOP;
        }
        return ConnectorState.ACCEPT;
    }
    
    public void accept(Widget widget, Point point, Transferable transferable) {
        try {
            Object nd = transferable.getTransferData(new DataFlavor(DataFlavor.javaJVMLocalObjectMimeType));
            Operator node = (Operator) nd;
            String type = node.getName();
            if(AspectMapBuilder.getAspectMapBuilder().getAdviceListSize(pane.getCurrentAspect()) == 0){
                pane.insertAfterInput(type);
            } else{
                AddAdvicePanel panel = new AddAdvicePanel();
                panel.populateComboBox(AspectMapBuilder.getAspectMapBuilder().getAdviceList(pane.getCurrentAspect()));
                DialogDescriptor dd = new DialogDescriptor(panel, "Add Advice [" + type + "] After");
                Dialog dlg = DialogDisplayer.getDefault().createDialog(dd);
                dlg.setVisible(true);
                if (NotifyDescriptor.OK_OPTION.equals(dd.getValue())) {
                    Object obj = panel.getInsertAfter();
                    if(obj instanceof AdviceType){
                        pane.insertAfterAdvice((AdviceType)obj, type);
                    } else{
                        pane.insertAfterInput(type);
                    }
                }
                
            }
            
            
        } catch (Exception ex) {
            // pane.setLog("Error adding join view.");
        }
    }
    
}
