/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.iep.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.openide.cookies.OpenCookie;
import org.openide.cookies.CloseCookie;
import org.openide.util.NbBundle;

/**
 * IEP editor data object controller. The controller provide user with
 * interface to IEP data object cookie actions
 *
 * @author Bing Lu
 *
 */
public class PlanController implements OpenCookie, CloseCookie {
    private static final java.util.logging.Logger mLog = java.util.logging.Logger.getLogger(PlanController.class.getName());

    /**
     * The BPEL editor main view panel
     */
    private PlanTopComponent mView;


    /**
     * Describe constant <code>INVALID_MSG</code> here.
     */
    private static final String INVALID_MSG = NbBundle.getMessage(PlanController.class,"PlanController.This_XML_schema_is_corrupted") + "\n"
        + NbBundle.getMessage(PlanController.class,"PlanController.Unable_to_rectify_or_diagnose_further");

    /**
     * Describe constant <code>DIALOG_TITLE</code> here.
     */
    private static final String DIALOG_TITLE = NbBundle.getMessage(PlanController.class,"PlanController.Fatal_Error");
    
    
    /**
     * The Node that is being controlled by this object.
     */
    private PlanNode mNode;

    /**
     * Constructor to create the BPMS data object contoller.
     *
     * @param node the associated BPMS data node
     */
    public PlanController(PlanNode node) {
        super();
        mNode = node;
    }

    /**
     * Open the Plan Node.
     */
    public void open() {
        
        // the synchronize is required, because multiple events can
        // potentially call open(), and the instance variable mView
        // maynot be instantiated. Once the view is open, for any number
        // of subsequent calls this synchronize is just an overhead.
        synchronized (this) {
            if (mView == null || mView.isPlanDiscarded()) {
                createView();
            }
            if (mView != null) {
                mView.setName(mNode.getDisplayName());
                // mView.setEnabled(isLocked());
                mView.open();
            }
        }
    }

    /**
     * Closes the Plan.
     *
     * @return true if the close was successful.
     */
    public boolean close() {
        if (mView != null) {
            mView.close();
            mView = null;
        }
        return true;
    }

    /**
     * Get the Data Object for the internal mNode.
     *
     * @return The Data Object
     */
    public Object getDataObject() {
        return mNode.getDataObject();
    }

    /**
     * Creates and calls open on the TopComponent.
     */
    private void createView() {
        /*
        WindowManager.getDefault().getMainWindow().setCursor
            (Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
         */
        mView = new PlanTopComponent(mNode);
        /*
        WindowManager.getDefault().getMainWindow().setCursor
            (Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
         */
    }
}