/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.sql.framework.ui.view;

import java.util.Arrays;
import java.util.Comparator;

import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

/**
 * @author Jonathan Giron
 * @version $Revision: 1.2 $
 */
public class SortableTableModel extends AbstractTableModel {

    private class TableModelComparator implements Comparator {
        //private int _iColumn;
        private int _iAscending;

        public TableModelComparator(int iColumn) {
            this(iColumn, true);
        }

        public TableModelComparator(int iColumn, boolean ascending) {
            _iColumn = iColumn;
            if (ascending) {
                _iAscending = 1;
            } else {
                _iAscending = -1;
            }
        }

        /*
         * @see Comparator#compare(Object, Object)
         */
        public int compare(Object o1, Object o2) {
            final Integer i1 = (Integer) o1;
            final Integer i2 = (Integer) o2;

            final Object data1 = _actualModel.getValueAt(i1.intValue(), _iColumn);
            final Object data2 = _actualModel.getValueAt(i2.intValue(), _iColumn);
            try {
                if (data1 == null && data2 == null) {
                    return 0;
                }
                if (data1 == null) {
                    return 1 * _iAscending;
                }
                if (data2 == null) {
                    return -1 * _iAscending;
                }
                Comparable c1 = (Comparable) data1;
                return c1.compareTo(data2) * _iAscending;
            } catch (ClassCastException ex) {
                return data1.toString().compareTo(data2.toString()) * _iAscending;
            }
        }

    }

    protected class MyTableModelListener implements TableModelListener {
        public void tableChanged(TableModelEvent evt) {
            _indexes = new Integer[getRowCount()];
            for (int i = 0; i < _indexes.length; ++i) {
                _indexes[i] = new Integer(i);
            }
        }
    }

    protected boolean _bAscending;

    /** Column currently being sorted by. -1 means unsorted. */
    protected int _iColumn = -1;

    /** The autal model that this model is wrapped around. */
    private TableModel _actualModel;

    private MyTableModelListener _actualModelLis = new MyTableModelListener();

    /**
     * Contains the indexes within <TT>_actualModel</TT> after sorting. I.E. if after
     * sorting <TT>_actualModel[1]</TT> should be the first line and <TT>
     * _actualModel[0]</TT> should be the second line then <TT>_indexes</TT> will
     * contain <TT>{1,0}</TT>.
     */
    private Integer[] _indexes = new Integer[0];

    public SortableTableModel() {
        this(null);
    }

    public SortableTableModel(TableModel model) {
        super();
        setActualModel(model);
        setInitialIndices();
    }

    public TableModel getActualModel() {
        return _actualModel;
    }

    public int getActualModelRow(int row) {
        if (row < _indexes.length) {
            return _indexes[row].intValue();
        }

        return -1;
    }

    /*
     * @see TableModel#getColumnClass(int)
     */
    public Class getColumnClass(int col) {
        return _actualModel.getColumnClass(col);
    }

    /**
     * Return the number of columns in this table.
     * 
     * @return Number of columns in this table.
     */
    public int getColumnCount() {
        return _actualModel != null ? _actualModel.getColumnCount() : 0;
    }

    /*
     * @see TableModel#getColumnName(int)
     */
    public String getColumnName(int col) {
        return _actualModel.getColumnName(col);
    }

    /**
     * Return the number of rows in this table.
     * 
     * @return Number of rows in this table.
     */
    public int getRowCount() {
        return _actualModel != null ? _actualModel.getRowCount() : 0;
    }

    /**
     * Return the value at the specified row/column.
     * 
     * @param row Row to return data for.
     * @param col Column to return data for.
     * @return value at the specified row/column.
     */
    public Object getValueAt(int row, int col) {
        return _actualModel.getValueAt(_indexes[row].intValue(), col);
    }

    /**
     * The actual model may or may not be editable, so return the value returned by the
     * model when asked if this cell is editable.
     * 
     * @param row Row to return data for.
     * @param col Column to return data for.
     * @return value returned by actual model
     */
    public boolean isCellEditable(int row, int col) {
        return _actualModel.isCellEditable(row, col);
    }

    public void setActualModel(TableModel newModel) {
        if (_actualModel != null) {
            _actualModel.removeTableModelListener(_actualModelLis);
        }
        _actualModel = newModel;
        if (_actualModel != null) {
            _actualModel.addTableModelListener(_actualModelLis);
        }
    }

    /**
     * Set the value at the specified row/column.
     * 
     * @param value Value to place in cell.
     * @param row Row to return data for.
     * @param col Column to return data for.
     * @return value at the specified row/column.
     */
    public void setValueAt(Object value, int row, int col) {
        _actualModel.setValueAt(value, _indexes[row].intValue(), col);
    }

    /**
     * Sorts the column specified in a mode depending if the that column was last sorted
     * and then inverted that mode. If the column was not the previous sorted column then
     * it will be sorted in ascending mode.
     */
    public boolean sortByColumn(int column) {
        boolean b = true;
        if (column == _iColumn) {
            b = !_bAscending;
        }
        sortByColumn(column, b);
        return b;
    }

    /**
     * Sorts the table by the specified column.
     * 
     * @param column column to sort by
     * @param ascending sort ascending if <TT>true</TT> else descending.
     */
    public void sortByColumn(int column, boolean ascending) {
        _iColumn = column;
        _bAscending = ascending;
        TableModelComparator comparator = new TableModelComparator(column, ascending);
        // Should the data be first cloned so that the sorting doesn't take place
        // on the array that is used in getValue()
        // This is a must if sorting is done in a thread! ??
        Arrays.sort(_indexes, comparator);
        fireTableDataChanged();
    }

    private void setInitialIndices() {
        _indexes = new Integer[getRowCount()];
        for (int i = 0; i < _indexes.length; ++i) {
            _indexes[i] = new Integer(i);
        }
    }
}

