/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.sql.framework.highlighter;

import java.awt.Color;
import java.util.HashMap;

import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

/**
 * Style Names used as the key in the style Map
 * 
 * @author Ahimanikya Satapathy
 * @version $Revision: 1.2 $
 */
public class StyleHelper {
    public static String CATALOG = "catalogName";
    public static String COLUMN = "columnName";

    public static String COMMENT = "comment";
    public static String DATA_TYPE = "datatype";

    public static String DEFAULT_FONT = "Monospaced";
    public static String DOT = "dot";
    public static String ERROR = "error";

    // not used at this point
    public static String FUNCTION = "function";
    public static String IDENTIFIER = "identifier";
    public static String LITERAL = "literal";
    public static String OPERATOR = "operator";
    public static String QUALIFIER = "qualifier";
    public static String RESERVED_WORD = "reservedWord";
    public static String RUNTIME_ARGUMENT = "runtimeargument";
    public static String SCHEMA = "schemaName";
    public static String SEPARATOR = "separator";
    public static String TABLE = "tableName";
    public static String TABLE_ALIAS = "tableAlias";
    public static String TEXT = "text";
    public static String WHITESPACE = "whitespace";

    /**
     * A hash table containing the text styles. Simple attribute sets are hashed by name
     * (String)
     */
    private HashMap styles = new HashMap();

    /**
     * Create the styles and place them in the hash table.
     */
    public StyleHelper() {
        styles.put(RESERVED_WORD, createStyle(Color.blue, false, false));
        styles.put(IDENTIFIER, createStyle(Color.black, false, false));
        styles.put(LITERAL, createStyle(new Color(0xB03060), false, false));

        styles.put(SEPARATOR, createStyle(new Color(0xA50000), false, false));
        styles.put(DOT, createStyle(Color.blue, false, false));
        styles.put(OPERATOR, createStyle(new Color(0xB03060), false, false));
        styles.put(COMMENT, createStyle(new Color(0x3F5FBF), false, false));

        styles.put(TABLE, createStyle(new Color(0xA020F0).darker(), false, false));
        styles.put(SCHEMA, createStyle(new Color(0xA020F0).darker(), false, false));
        styles.put(CATALOG, createStyle(new Color(0xA020F0).darker(), false, false));
        styles.put(TABLE_ALIAS, createStyle(new Color(0xA020F0).darker(), false, false));

        styles.put(QUALIFIER, createStyle(new Color(0xA020F0).darker(), false, false));
        styles.put(RUNTIME_ARGUMENT, createStyle(new Color(0xB03060), false, false));
        styles.put(WHITESPACE, createStyle(Color.black, false, false));

        styles.put(ERROR, createStyle(Color.red, false, false)); // red
        styles.put("unknown", createStyle(Color.orange, false, false));
        styles.put("text", createStyle(Color.black, false, false));
    }

    /**
     * retrieve the style for the given type of text.
     * 
     * @param styleName the label for the type of text ("tag" for example) or null if the
     *        styleName is not known.
     * @return the style
     */
    public SimpleAttributeSet getStyle(String styleName) {
        return ((SimpleAttributeSet) styles.get(styleName));
    }

    private SimpleAttributeSet createStyle(Color fg, boolean bold, boolean italic) {
        SimpleAttributeSet style = new SimpleAttributeSet();
        StyleConstants.setFontFamily(style, DEFAULT_FONT);
        StyleConstants.setFontSize(style, 12);
        StyleConstants.setBackground(style, Color.white);
        StyleConstants.setForeground(style, fg);
        StyleConstants.setBold(style, bold);
        StyleConstants.setItalic(style, italic);
        return style;
    }

}

