/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.sql.framework.evaluators.database.base;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.TreeMap;

import org.netbeans.modules.sql.framework.evaluators.database.OperatorEvaluator;
import org.netbeans.modules.sql.framework.evaluators.database.StatementContext;
import org.netbeans.modules.sql.framework.model.SQLObject;
import org.netbeans.modules.sql.framework.model.SQLOperatorDefinition;

import com.sun.sql.framework.exception.BaseException;

/**
 * Handles evaluation of User function AKA generic function of format userFx(arg1, arg2...).
 * @author Girish Patil
 * @version $Revision: 1.3 $
 */
public class BaseUserFxEvaluator extends OperatorEvaluator {
    /**
     * genVariableExpression
     * 
     * @param params - SequencedHashMap
     * @param defn - SQLOperatorDefinition
     * @return String
     * @throws BaseException - exception
     */
    protected String genVariableExpression(LinkedHashMap params, SQLOperatorDefinition defn, StatementContext context) throws BaseException {
        TreeMap resolvedparams = new TreeMap();

        for (Iterator iter = params.keySet().iterator(); iter.hasNext();) {
            String key = (String) iter.next();
            SQLObject val = (SQLObject) params.get(key);

            if (val == null) {
                throw new BaseException("No input arguments for variable " + key);
            }

            resolvedparams.put(key, this.getEvaluatorFactory().evaluate(val, context));
        }

        String script = defn.getScript();
        if (script.indexOf("[") == -1 || script.indexOf("]") == -1) {
            throw new BaseException("Bad variable operator script.");
        }

        String functionName = (String) context.getClientProperty(StatementContext.USER_FUNCTION_NAME);
        if ((functionName == null) || ("".equals(functionName))){
            functionName = "userFx" ;
        }
        
        StringBuilder sb = new StringBuilder();
        sb.append(functionName);
        sb.append("(");
        Iterator i = (resolvedparams.keySet()).iterator();
        int count = 0;
        while (i.hasNext()) {
            sb.append( ((count > 0) ? "," : ""));
            sb.append( (String) resolvedparams.get(i.next()) );
            count++;
        }
        sb.append(")");
        return sb.toString();
    }

}
