/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.sql.framework.evaluators.database.base;

import org.netbeans.modules.sql.framework.evaluators.database.AbstractEvaluator;
import org.netbeans.modules.sql.framework.evaluators.database.StatementContext;
import org.netbeans.modules.sql.framework.model.SQLConstants;
import org.netbeans.modules.sql.framework.model.SQLDBColumn;
import org.netbeans.modules.sql.framework.model.SQLDBTable;
import org.netbeans.modules.sql.framework.model.SQLObject;

import com.sun.sql.framework.exception.BaseException;
import com.sun.sql.framework.utils.StringUtil;

/**
 * @author Ritesh Adval
 * @version $Revision: 1.3 $
 */
public class BaseColumnEvaluator extends AbstractEvaluator {

    public String evaluate(SQLObject obj, StatementContext context) throws BaseException {
        SQLDBColumn column = (SQLDBColumn) obj;

        StringBuilder result = new StringBuilder(50);
        String nestedIndent = (String) context.getClientProperty("nestedIndent");
        if (nestedIndent != null) {
            result.append(nestedIndent);
        }

        // This is to check for runtime input output, we need to refactor this (runtime
        // input holds source column, runtime output holds target columns so it comes
        // here) but for now do this check here
        SQLObject tableObj = (SQLObject) column.getParentObject();
        if (tableObj.getObjectType() == SQLConstants.RUNTIME_INPUT || tableObj.getObjectType() == SQLConstants.RUNTIME_OUTPUT) {
            result.append("$");
            result.append(column.getName());
        } else {
            String legalName = this.getDB().getEscapedName(column.getName());
            if ((column.getObjectType() == SQLConstants.TARGET_COLUMN && !context.isSuppressingTablePrefixForTargetColumn())
                || (column.getObjectType() == SQLConstants.SOURCE_COLUMN && !context.isSuppressingTablePrefixForSourceColumn())) {
                String prefix = getPrefix(column, context).trim();
                if (!StringUtil.isNullString(prefix)) {
                    result.append(prefix);
                    result.append(".");
                }
            }
            result.append(legalName);
        }

        return result.toString();
    }

    /**
     * Generates appropriate column prefix for the given column type and SQLObject.
     * 
     * @param type column type
     * @param object SQLObject (column) to be prefixed
     * @return appropriate column prefix
     * @throws BaseException if prefix cannot be generated
     */
    private String getPrefix(SQLDBColumn column, StatementContext context) throws BaseException {
        SQLDBTable table = (SQLDBTable) column.getParentObject();
        String alias = table.getAliasName();

        if ((column.getObjectType() == SQLConstants.SOURCE_COLUMN && context.isUseSourceTableAliasName())
            || (column.getObjectType() == SQLConstants.TARGET_COLUMN && context.isUseTargetTableAliasName())) {

            if (!StringUtil.isNullString(alias)) {
                return alias;
            }
        }
        return this.getEvaluatorFactory().evaluate(table, context);
    }
}
