/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.view.visitor;

import java.util.ArrayList;
import java.util.List;

import javax.swing.tree.TreeModel;
import org.netbeans.modules.bpel.xpath.model.node.visitor.NodeLocalVariablePrecedenceVisitor;
import org.netbeans.modules.bpel.xpath.model.nodes.Node;
import org.netbeans.modules.bpel.xpath.model.nodes.PartNode;
import org.netbeans.modules.bpel.xpath.model.nodes.VariableNode;
import org.netbeans.modules.bpel.xpath.model.nodes.VariablesNode;
import org.netbeans.modules.bpel.xpath.model.nodes.StandardRootNode;
import org.netbeans.modules.xml.wsdl.model.Part;

/**
 *
 * @author radval
 *
 */
public class MapperTreeUtility {
    
    /**
     * Returns a list of all global and local variables, in order of
     * precedence (i.e. variables that may hide other variables appear
     * earlier in the list).
     */
    public static List getAllVariables(TreeModel tModel) {
        List allVariables = new ArrayList();
        StandardRootNode variablesRootNode = (StandardRootNode) tModel.getRoot();
        VariablesNode variablesNode = variablesRootNode.getVariablesNode();
        
        // Local variables
        if (variablesNode != null && variablesNode.hasLocalVariables()) {
            NodeLocalVariablePrecedenceVisitor precedenceVisitor = 
                    new NodeLocalVariablePrecedenceVisitor();
            variablesNode.accept(precedenceVisitor);
            allVariables.addAll(precedenceVisitor.getVariablePrecedenceList());
        }
        
        // Global variables, simple search through the flat list.
        allVariables.addAll(variablesNode.getGlobalVariables());
        
        return allVariables;
    }
    
    public static VariableNode findVariable(String variableName, TreeModel tModel) {
        if (variableName == null) {
            return null;
        }
        
        StandardRootNode variablesRootNode = (StandardRootNode) tModel.getRoot();
        VariablesNode variablesNode = variablesRootNode.getVariablesNode();
        
        // First look through local variables at the deepest scope, then upwards
        // through the scope hierarchy. Finally, look through global variables.
        // In BPEL, variables hide more globally scoped variables of the same name.
        
        // Local variable scoping
        if (variablesNode != null && variablesNode.hasLocalVariables()) {
            NodeLocalVariablePrecedenceVisitor precedenceVisitor = 
                    new NodeLocalVariablePrecedenceVisitor();
            variablesNode.accept(precedenceVisitor);
            List localVariablesPrecedenceList = precedenceVisitor.getVariablePrecedenceList();
            VariableNode localVariableMatch = matchVariableName(localVariablesPrecedenceList, variableName);
            if (localVariableMatch != null) {
                return localVariableMatch;
            }
        }
        
        // Global variables, simple search through the flat list.
        return matchVariableName(variablesNode.getGlobalVariables(), variableName);
    }
    
    private static VariableNode matchVariableName(List variablesList, String variableName) {
        int noOfContainers = variablesList.size();
        for (int i = 0; i < noOfContainers; i++) {
            VariableNode iterNode = (VariableNode) variablesList.get(i);
            if (variableName.equals(iterNode.getName())) {
                return iterNode;
            }
        }
        
        return null;
    }
    
    public static Part findPart(
            String partName,
            VariableNode variable,
            TreeModel tModel) {
        if (partName == null || variable == null) {
            return null;
        }
        int noOfParts = tModel.getChildCount(variable);
        
        PartNode partNode = null;
        for (int i = 0; i < noOfParts; i++) {
            Node node = (Node) tModel.getChild(variable, i);
            if (node instanceof PartNode) {
                partNode = (PartNode) node;
                Part part = partNode.getPart();
                
                if (part != null && partName.equals(part.getName())) {
                    return part;
                }
            }
        }
        
        return null;
    }
}
