/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.bpel.xpath.view.expression.literal;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.soa.ui.form.RangeIntegerDocument;
import org.netbeans.modules.soa.ui.form.valid.DefaultValidator;
import org.netbeans.modules.soa.ui.form.valid.ValidStateManager;
import org.netbeans.modules.soa.ui.form.valid.ValidStateManager.ValidStateListener;
import org.netbeans.modules.soa.ui.form.valid.Validator;
import org.netbeans.modules.bpel.editors.api.utils.TimeEventUtil;
import org.netbeans.modules.soa.ui.form.ValidablePropertyCustomizer;
import org.netbeans.modules.bpel.editors.api.ui.valid.ErrorMessagesBundle;
import org.openide.awt.Mnemonics;

/**
 *  Implements a panel to input a Schema duration value.
 *
 *  @author     ew194106
 *  @version    
 *  @since      5.5
 */
public class DurationPropertyPanel extends ValidablePropertyCustomizer {
    
    /** Creates a Duration property panel.
     */
    public DurationPropertyPanel() {
        super();
        //
        initComponents();
        //
        getValidStateManager(true).addValidStateListener(new ValidStateListener() {
            public void stateChanged(ValidStateManager source, boolean isValid) {
                if (source.isValid()) {
                    lblErrorMessage.setText("");
                } else {
                    lblErrorMessage.setText(source.getHtmlReasons());
                }
            }
        });
        //
        fldYear.setDocument(new RangeIntegerDocument(0, Integer.MAX_VALUE));
        fldMonth.setDocument(new RangeIntegerDocument(0, Integer.MAX_VALUE));
        fldDay.setDocument(new RangeIntegerDocument(0, Integer.MAX_VALUE));
        fldHour.setDocument(new RangeIntegerDocument(0, Integer.MAX_VALUE));
        fldMinute.setDocument(new RangeIntegerDocument(0, Integer.MAX_VALUE));
        fldSecond.setDocument(new RangeIntegerDocument(0, Integer.MAX_VALUE));
        //
        DocumentListener docListener = new DocumentListener() {
            public void changedUpdate(DocumentEvent e) {
                revalidate(true);
            }
            public void insertUpdate(DocumentEvent e) {
                revalidate(true);
            }
            public void removeUpdate(DocumentEvent e) {
                revalidate(true);
            }
        };
        //
        fldYear.getDocument().addDocumentListener(docListener);
        fldMonth.getDocument().addDocumentListener(docListener);
        fldDay.getDocument().addDocumentListener(docListener);
        fldHour.getDocument().addDocumentListener(docListener);
        fldMinute.getDocument().addDocumentListener(docListener);
        fldSecond.getDocument().addDocumentListener(docListener);
        //
        FocusListener fl = new FocusAdapter() {
            public void focusLost(FocusEvent e) {
                revalidate(true);
            }
        };
        //
        fldYear.addFocusListener(fl);
        fldMonth.addFocusListener(fl);
        fldDay.addFocusListener(fl);
        fldHour.addFocusListener(fl);
        fldMinute.addFocusListener(fl);
        fldSecond.addFocusListener(fl);
        //
        Mnemonics.setLocalizedText(lblYear, lblYear.getText());
        Mnemonics.setLocalizedText(lblMonth, lblMonth.getText());
        Mnemonics.setLocalizedText(lblDay, lblDay.getText());
        Mnemonics.setLocalizedText(lblHour, lblHour.getText());
        Mnemonics.setLocalizedText(lblMinute, lblMinute.getText());
        Mnemonics.setLocalizedText(lblSecond, lblSecond.getText());
    }
    
    /** Initialize the Duration property panel.
     *  @param  value   Duration value.
     */
    public synchronized void init(String value) {
        if (value.startsWith(TimeEventUtil.QUOTE)) {
            value = value.substring(1, value.length());
        }
        if (value.endsWith(TimeEventUtil.QUOTE)) {
            value = value.substring(0, value.length() - 1);
        }
        //
        parseFor(value);
        revalidate(true);
    }
    
    private void parseFor(String text) {
        String value = text;
        
        if ((null == value) || (value.length() == 0)
                || (value.charAt(0) != TimeEventUtil.P_DELIM.charAt(0))) {
            fldYear.setText(TimeEventUtil.ZERO);
            fldMonth.setText(TimeEventUtil.ZERO);
            fldDay.setText(TimeEventUtil.ZERO);
            fldHour.setText(TimeEventUtil.ZERO);
            fldMinute.setText(TimeEventUtil.ZERO);
            fldSecond.setText(TimeEventUtil.ZERO);
            return;
        }
        value = value.substring(1, value.length());
        value = parse(TimeEventUtil.Y_DELIM, value, fldYear);
        value = parse(TimeEventUtil.M_DELIM, value, fldMonth);
        value = parse(TimeEventUtil.D_DELIM, value, fldDay);
        
        if ((null == value) || (value.length() == 0)
                || (value.charAt(0) != TimeEventUtil.T_DELIM.charAt(0))) {
            fldHour.setText(TimeEventUtil.ZERO);
            fldMinute.setText(TimeEventUtil.ZERO);
            fldSecond.setText(TimeEventUtil.ZERO);
            return;
        }
        value = value.substring(1, value.length());
        value = parse(TimeEventUtil.H_DELIM, value, fldHour);
        value = parse(TimeEventUtil.M_DELIM, value, fldMinute);
        value = parse(TimeEventUtil.S_DELIM, value, fldSecond);
    }
    
    private String parse(String delim, String text, JTextField field) {
        String value = text;
        int k = value.indexOf(delim);
        
        if (k == -1) {
            field.setText(TimeEventUtil.ZERO);
        } else {
            int n = TimeEventUtil.parseInt(value.substring(0, k));
            
            if (n < 0) {
                field.setText(TimeEventUtil.ZERO);
            } else {
                field.setText(TimeEventUtil.EMPTY + n);
            }
            value = value.substring(k + 1, value.length());
        }
        return value;
    }
    
    /** Gets the content of the Duration property panel.
     *  @return A XML Schema duration type value.
     */
    public String getContent() {
        return TimeEventUtil.getContent(true,
                TimeEventUtil.parseInt(fldYear.getText()),
                TimeEventUtil.parseInt(fldMonth.getText()),
                TimeEventUtil.parseInt(fldDay.getText()),
                TimeEventUtil.parseInt(fldHour.getText()),
                TimeEventUtil.parseInt(fldMinute.getText()),
                TimeEventUtil.parseInt(fldSecond.getText()));
    }
    
    /** ValidablePropertyCustomizer#createValidator()
     */
    public Validator createValidator() {
        return new MyValidator(this);
    }
    
    private class MyValidator extends DefaultValidator {
        
        public MyValidator(ValidStateManager.Provider vsmProvider) {
            super(vsmProvider, ErrorMessagesBundle.class);
        }
        
        public boolean doFastValidation() {
            boolean result = true;
            //
            if ( !check(fldYear)) {
                addReasonKey("ERR_INVALID_YEARS"); // NOI18N
                result = false;
            }
            if ( !check(fldMonth)) {
                addReasonKey("ERR_INVALID_MONTHS"); // NOI18N
                result = false;
            }
            if ( !check(fldDay)) {
                addReasonKey("ERR_INVALID_DAYS"); // NOI18N
                result = false;
            }
            if ( !check(fldHour)) {
                addReasonKey("ERR_INVALID_HOURS"); // NOI18N
                result = false;
            }
            if ( !check(fldMinute)) {
                addReasonKey("ERR_INVALID_MINUTES"); // NOI18N
                result = false;
            }
            if ( !check(fldSecond)) {
                addReasonKey("ERR_INVALID_SECONDS"); // NOI18N
                result = false;
            }
            return result;
        }
        
        private boolean check(JTextField field) {
            return TimeEventUtil.parseInt(field.getText()) >= 0;
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        lblYear = new javax.swing.JLabel();
        fldYear = new javax.swing.JTextField();
        lblMonth = new javax.swing.JLabel();
        fldMonth = new javax.swing.JTextField();
        lblDay = new javax.swing.JLabel();
        fldDay = new javax.swing.JTextField();
        lblHour = new javax.swing.JLabel();
        fldHour = new javax.swing.JTextField();
        lblMinute = new javax.swing.JLabel();
        fldMinute = new javax.swing.JTextField();
        lblSecond = new javax.swing.JLabel();
        fldSecond = new javax.swing.JTextField();
        lblErrorMessage = new javax.swing.JLabel();

        lblYear.setLabelFor(fldYear);
        lblYear.setText(org.openide.util.NbBundle.getMessage(DurationPropertyPanel.class, "LBL_Years"));
        lblYear.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(DurationPropertyPanel.class, "LBL_Years"));

        fldYear.setColumns(4);

        lblMonth.setLabelFor(fldMonth);
        lblMonth.setText(org.openide.util.NbBundle.getMessage(DurationPropertyPanel.class, "LBL_Months"));
        lblMonth.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(DurationPropertyPanel.class, "LBL_Months"));

        fldMonth.setColumns(4);

        lblDay.setLabelFor(fldDay);
        lblDay.setText(org.openide.util.NbBundle.getMessage(DurationPropertyPanel.class, "LBL_Days"));
        lblDay.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(DurationPropertyPanel.class, "LBL_Days"));

        fldDay.setColumns(4);

        lblHour.setLabelFor(fldHour);
        lblHour.setText(org.openide.util.NbBundle.getMessage(DurationPropertyPanel.class, "LBL_Hours"));
        lblHour.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(DurationPropertyPanel.class, "LBL_Hours"));

        fldHour.setColumns(4);

        lblMinute.setLabelFor(fldMinute);
        lblMinute.setText(org.openide.util.NbBundle.getMessage(DurationPropertyPanel.class, "LBL_Minutes"));
        lblMinute.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(DurationPropertyPanel.class, "LBL_Minutes"));

        fldMinute.setColumns(4);

        lblSecond.setLabelFor(fldSecond);
        lblSecond.setText(org.openide.util.NbBundle.getMessage(DurationPropertyPanel.class, "LBL_Seconds"));
        lblSecond.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(DurationPropertyPanel.class, "LBL_Seconds"));

        fldSecond.setColumns(4);

        lblErrorMessage.setForeground(new java.awt.Color(255, 0, 0));

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, lblErrorMessage, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 295, Short.MAX_VALUE)
                    .add(layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(org.jdesktop.layout.GroupLayout.TRAILING, lblYear)
                            .add(org.jdesktop.layout.GroupLayout.TRAILING, lblHour))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(fldYear, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 46, Short.MAX_VALUE)
                            .add(fldHour, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 46, Short.MAX_VALUE))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(org.jdesktop.layout.GroupLayout.TRAILING, lblMonth)
                            .add(org.jdesktop.layout.GroupLayout.TRAILING, lblMinute))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(fldMonth, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 45, Short.MAX_VALUE)
                            .add(fldMinute, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 45, Short.MAX_VALUE))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(org.jdesktop.layout.GroupLayout.TRAILING, lblDay)
                            .add(org.jdesktop.layout.GroupLayout.TRAILING, lblSecond))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(fldDay, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 46, Short.MAX_VALUE)
                            .add(fldSecond, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 46, Short.MAX_VALUE))))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(lblYear)
                    .add(fldYear, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(lblMonth)
                    .add(lblDay)
                    .add(fldDay, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(fldMonth, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(lblHour)
                    .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                        .add(lblMinute)
                        .add(lblSecond)
                        .add(fldHour, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .add(fldSecond, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .add(fldMinute, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(lblErrorMessage, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 49, Short.MAX_VALUE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField fldDay;
    private javax.swing.JTextField fldHour;
    private javax.swing.JTextField fldMinute;
    private javax.swing.JTextField fldMonth;
    private javax.swing.JTextField fldSecond;
    private javax.swing.JTextField fldYear;
    private javax.swing.JLabel lblDay;
    private javax.swing.JLabel lblErrorMessage;
    private javax.swing.JLabel lblHour;
    private javax.swing.JLabel lblMinute;
    private javax.swing.JLabel lblMonth;
    private javax.swing.JLabel lblSecond;
    private javax.swing.JLabel lblYear;
    // End of variables declaration//GEN-END:variables
    
}
