/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.bpel.project.anttasks;

import javax.xml.namespace.QName;
import java.io.File;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.Role;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PartnerLinkType;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.references.WSDLReference;

public class TestGetPortInfo {
    public TestGetPortInfo() {
    }
    public String execute(File sourceFile) {
        System.setProperty("org.openide.util.Lookup","org.netbeans.modules.bpel.project.anttasks.MyLookup" );    
        BpelModel bpelModel = null;
        String portInfo = null;
        String returnStr = null;
        try  {
             bpelModel = BPELCatalogModel.getDefault().getBPELModel(sourceFile.toURI());
             returnStr = "SUCCESS";
        }catch (Exception ex) {
            return  "FAIL:Creation of Bpel model failed!"+ex.toString();
        }
        
        PartnerLink[] pLinks = bpelModel.getProcess().getPartnerLinkContainer().getPartnerLinks();
        System.out.println("Got partner links!");
        for (int index =0; index < pLinks.length; index++) {
            String partnerLinkName = pLinks[index].getName();
            WSDLReference partnerLinkTypeWSDLRef = pLinks[index].getPartnerLinkType();
            QName partnerLinkQName = pLinks[index].getPartnerLinkType().getQName();
            String partnerLinkQNameNSPrefix = partnerLinkQName.getPrefix();
            String partnerLinkQNameLocalPart = partnerLinkQName.getLocalPart();
            String partnerLinkNameSpaceURI = partnerLinkQName.getNamespaceURI();
            PartnerLinkType pLTypeForPLinkType = (PartnerLinkType)partnerLinkTypeWSDLRef.get();
            if (pLTypeForPLinkType != null) {                 
                Role pLTypeForPLinkTypeRole1 = pLTypeForPLinkType.getRole1();
                if (pLTypeForPLinkTypeRole1 != null) {
                    NamedComponentReference nmrRole1 = pLTypeForPLinkTypeRole1.getPortType();
                    if (nmrRole1 != null ) {
                        QName portTypeQName1 = nmrRole1.getQName();
                        if (portTypeQName1 != null) {
                            portInfo = "Port Type1 = "+portTypeQName1.getLocalPart()+ " Prefix = "+portTypeQName1.getPrefix()+ "Port Type1 = "+portTypeQName1.getNamespaceURI();
                        }
                    }
                }

            Role pLTypeForPLinkTypeRole2 = pLTypeForPLinkType.getRole2();
            if (pLTypeForPLinkTypeRole2 != null) {
                NamedComponentReference nmrRole2 = pLTypeForPLinkTypeRole2.getPortType();
                if (nmrRole2 != null ) {
                    QName portTypeQName2 = nmrRole2.getQName();
                    if (portTypeQName2 != null) {
                        portInfo = "Port Type2 = "+portTypeQName2.getLocalPart()+ " Prefix = "+portTypeQName2.getPrefix()+ "Port Type = "+portTypeQName2.getNamespaceURI();
                        
                    }
                }
            }                     
            }
            if (portInfo != null) {
                System.out.println("PortInfo = "+portInfo);
                return "SUCCESS";
            } else {
                return "FAIL";
            }

        }
        
        return returnStr;
    }    
}
