/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.debugger.spi.plugin.event;

/**
 * Manager of incoming debugger events for a target
 * {@link org.netbeans.modules.bpel.debugger.spi.plugin.BpelEngine}.
 * Events are always grouped in
 * {@link org.netbeans.modules.bpel.debugger.spi.plugin.event.EventSet}s.
 * {@link org.netbeans.modules.bpel.debugger.spi.plugin.event.EventSet}s
 * generated by the BPEL Debugger Plugin can be read here.
 * There is one instance of EventQueue assigned to a particular
 * {@link org.netbeans.modules.bpel.debugger.spi.plugin.BpelEngine}. It's
 * provided by the BPEL Debugger Plugin and can be obtained by invoking
 * {@link org.netbeans.modules.bpel.debugger.spi.plugin.BpelEngine#getEventQueue}.
 * <br><br>
 * Some events cause the suspension of process instances -
 * those which are issued using
 * {@link org.netbeans.modules.bpel.debugger.spi.plugin.request.EventRequest}s
 * with a
 * {@link org.netbeans.modules.bpel.debugger.spi.plugin.request.EventRequest.SuspendPolicy
 * suspend policy} of
 * {@link org.netbeans.modules.bpel.debugger.spi.plugin.request.EventRequest.SuspendPolicy#SUSPEND_ALL}
 * or
 * {@link org.netbeans.modules.bpel.debugger.spi.plugin.request.EventRequest.SuspendPolicy#SUSPEND_EVENT_PROCESS_INSTANCE}.
 * If these suspensions are not resumed the corresponding process instances
 * will hang. Thus, it is always good policy to
 * {@link org.netbeans.modules.bpel.debugger.spi.plugin.event.EventQueue#remove}
 * every event set from the event queue until an
 * {@link org.netbeans.modules.bpel.debugger.spi.plugin.event.EventSet}
 * containing a
 * {@link org.netbeans.modules.bpel.debugger.spi.plugin.event.BpelEngineDisconnectedEvent}
 * is read.
 *
 * @author Alexander Zgursky
 */
public interface EventQueue {
    
    /**
     * Waits forever for the next available
     * {@link org.netbeans.modules.bpel.debugger.spi.plugin.event.EventSet}.
     * When
     * {@link org.netbeans.modules.bpel.debugger.spi.plugin.event.EventSet}
     * becomes available, removes it from the EventQueue
     * and returns as the result.
     *
     * @return the next
     * {@link org.netbeans.modules.bpel.debugger.spi.plugin.event.EventSet}
     *
     * @throws InterruptedException
     *  if another thread has interrupted this thread
     * @throws org.netbeans.modules.bpel.debugger.spi.plugin.BpelEngineDisconnectedException
     *  if the
     *  {@link org.netbeans.modules.bpel.debugger.spi.plugin.BpelEngine}
     *  has been disconnected. Note this will always
     *  be preceded by a
     *  {@link org.netbeans.modules.bpel.debugger.spi.plugin.event.BpelEngineDisconnectedEvent}.
     */
    EventSet remove() throws InterruptedException;
    
    /**
     * Waits a specified time for the next available
     * {@link org.netbeans.modules.bpel.debugger.spi.plugin.event.EventSet}.
     * When
     * {@link org.netbeans.modules.bpel.debugger.spi.plugin.event.EventSet}
     * becomes available, removes it from the EventQueue
     * and returns as the result.
     *
     * @return the next
     * {@link org.netbeans.modules.bpel.debugger.spi.plugin.event.EventSet},
     * or <code>null</code> if there is a timeout.
     *
     * @throws InterruptedException
     *  if another thread has interrupted this thread
     * @throws org.netbeans.modules.bpel.debugger.spi.plugin.BpelEngineDisconnectedException
     *  if the
     *  {@link org.netbeans.modules.bpel.debugger.spi.plugin.BpelEngine}
     *  has been disconnected. Note this will always
     *  be preceded by a
     *  {@link org.netbeans.modules.bpel.debugger.spi.plugin.event.BpelEngineDisconnectedEvent}.
     * @throws IllegalArgumentException
     *  if the timeout argument contains an illegal value
     */
    EventSet remove(long timeout) throws InterruptedException;
}
