/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */


package org.netbeans.modules.bpel.debugger.test.stub;

import org.netbeans.modules.bpel.debugger.api.Position;
import org.netbeans.modules.bpel.debugger.api.ProcessInstance;
import org.netbeans.modules.bpel.debugger.bdiclient.impl.ProcessInstancesModelImpl;


public class StubProcessInstance extends ProcessInstance {

    private boolean mResult_isAdded = false;
    private int mResult_state = STATE_UNKNOWN;
    private int mStartState = STATE_UNKNOWN;
    private ProcessInstancesModelImpl mProcessModel;

    private String mName;
    private int mLineNumber;
    private String mURL;

    
    public StubProcessInstance(ProcessInstancesModelImpl model) {
        mProcessModel = model;
    }
    
    public StubProcessInstance(String name, int lineNumber, String url) {
        mName = name;
        mLineNumber = lineNumber;
        mURL = url;
    }
    
    
    public boolean getResult_isAdded() {
        return mResult_isAdded;
    }
    
    public int getResult_state() {
        return mResult_state;
    }
    
    public void setResult_isAdded(boolean isAdded) {
        mResult_isAdded = isAdded;
    }
    
    public void setResult_state(int state) {
        mResult_state = state;
    }
    
    public void setState(int newState) {
        int oldState = mStartState;
        mStartState = newState;
        mProcessModel.changeState(this, oldState, newState);
    }


//  ProcessInstance interface methods
//  ProcessInstance interface methods
//  ProcessInstance interface methods
    
    
    public Position getCurrentPosition() {
        return new Position(mURL, mLineNumber);
    }
    
    public String getName() {
        return mName;
    }
    
    public int getState() {
        return mStartState;
    }
    
    public void resume() {
    }
}
