/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.bpel.model.impl;

import java.util.Collection;

import org.netbeans.modules.bpel.model.api.BpelContainer;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.From;
import org.netbeans.modules.bpel.model.api.Literal;
import org.netbeans.modules.bpel.model.api.Query;
import org.netbeans.modules.bpel.model.api.ServiceRef;
import org.netbeans.modules.bpel.model.spi.EntityFactory;
import org.netbeans.modules.bpel.model.xam.BpelElements;
import org.w3c.dom.Element;


/**
 * @author ads
 *
 */
class BpelChildEntitiesBuilder {
    
    BpelChildEntitiesBuilder( BpelModelImpl model ){
        myModel = model; 
    }
    

    BpelEntity create( Element element, BpelContainer parent ) {
        assert parent != null;
        
        String namespace = element.getNamespaceURI();
        if ( namespace == null && parent instanceof BpelContainerImpl ) {
            namespace = ((BpelContainerImpl) parent).lookupNamespaceURI(element
                    .getPrefix());
        }
        
        if ( BpelEntity.BUSINESS_PROCESS_NS_URI.equals(namespace) 
                && (parent instanceof BpelContainerImpl ))
        {
            // we create via "create" method only BPEL spec elements.
            return ((BpelContainerImpl)parent).create(element);
        }
        else if ( ServiceRef.SERVICE_REF_NS.equals(namespace)
                && BpelElements.SERVICE_REF.getName().
                                    equals( element.getLocalName() )
                && (parent instanceof BpelContainerImpl ))
        {    
            /*
             *  This is the case "service-ref" element.
             *  In the case of big quantity of such elements ( in external 
             *  namespace but not realy extension one need to implement
             *  this with visitor idiom
             */
            if ( parent instanceof From || parent instanceof Literal 
                    || parent instanceof Query ) 
            {
                    return new ServiceRefImpl( getModel() , element ); 
            }
        }
        else {
            Collection<EntityFactory> factories = 
                getModel().getEntityRegistry().getFactories();
            for (EntityFactory factory : factories) {
                if ( factory.isApplicable( element.getNamespaceURI()) ){
                    if ( factory.getElementNames().contains( 
                            element.getLocalName() )) 
                    {
                        BpelEntity entity = factory.create( parent , element );
                        if ( entity!= null ){
                            return entity;
                        }
                    }
                }
            }
            return null;
        }
        return null;
    }
    
    private BpelModelImpl getModel() {
        return myModel;
    }
    
    private BpelModelImpl myModel;
}
