/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

/**
 *
 */
package org.netbeans.modules.bpel.model.api.events;

import org.netbeans.modules.bpel.model.api.BpelEntity;

/**
 * @author ads
 */
public class EntityUpdateEvent<T extends BpelEntity> extends IndexedChangeEvent
        implements OutOfModelEvent
{

    private static final long serialVersionUID = 6512333724051189804L;

    /**
     * Constructor for EntityUpdateEvent with source ref.
     *
     * @param source
     *            source of event ( who produce this event ).
     * @param parent
     *            element in OM that contains event entity.
     * @param name
     *            entity name.
     * @param oldValue
     *            old entity value.
     * @param newValue
     *            old entity value.
     */
    public EntityUpdateEvent( Object source, BpelEntity parent, String name,
            T oldValue, T newValue )
    {
        super(source, parent, name, -1);
        myOldValue = oldValue;
        myNewValue = newValue;
    }

    /**
     * Constructor for EntityUpdateEvent with source ref and index.
     * 
     * @param source
     *            source of event ( who produce this event ).
     * @param parent
     *            element in OM that contains event entity.
     * @param name
     *            entity name.
     * @param oldValue
     *            old entity value.
     * @param newValue
     *            new entity value.
     * @param index
     *            index of child entity in parent.
     */
    public EntityUpdateEvent( Object source, BpelEntity parent, String name,
            T oldValue, T newValue, int index )
    {
        super(source, parent, name, index);
        myOldValue = oldValue;
        myNewValue = newValue;
    }

    /**
     * Constructor for EntityUpdateEvent without source ref.
     * 
     * @param parent
     *            element in OM that contains event entity.
     * @param name
     *            entity name.
     * @param oldValue
     *            old entity value.
     * @param newValue
     *            new entity value.
     */
    public EntityUpdateEvent( BpelEntity parent, String name, T oldValue,
            T newValue )
    {
        this(Thread.currentThread(), parent, name, oldValue, newValue);
    }

    /**
     * Constructor for EntityUpdateEvent with index and without source ref.
     * 
     * @param parent
     *            element in OM that contains event entity.
     * @param name
     *            entity name.
     * @param oldValue
     *            old entity value.
     * @param newValue
     *            new entity value.
     * @param index
     *            index of child entity in parent.
     */
    public EntityUpdateEvent( BpelEntity parent, String name, T oldValue,
            T newValue, int index )
    {
        this(Thread.currentThread(), parent, name, oldValue, newValue, index);
    }

    /**
     * @return old value.
     */
    public T getOldValue() {
        return myOldValue;
    }

    /**
     * @return new value.
     */
    public T getNewValue() {
        return myNewValue;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.netbeans.modules.soa.model.bpel.api.events.OutOfModelEvent#getOutOfModelEntity()
     */
    /** {@inheritDoc} */
    public BpelEntity getOutOfModelEntity() {
        return getOldValue();
    }

    private T myOldValue;

    private T myNewValue;

}
