/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

/**
 *
 */
package org.netbeans.modules.bpel.model.api.events;

import org.netbeans.modules.bpel.model.api.BpelEntity;

/**
 * @author ads
 */
public class EntityRemoveEvent<T extends BpelEntity> extends IndexedChangeEvent
        implements OutOfModelEvent
{

    private static final long serialVersionUID = -7222756911004830278L;

    /**
     * Constructor for EntityRemoveEvent with source ref.
     *
     * @param source
     *            source of event ( who produce this event ).
     * @param parent
     *            element in OM that contains event entity.
     * @param name
     *            entity name.
     * @param value
     *            old entity value.
     */
    public EntityRemoveEvent( Object source, BpelEntity parent, String name,
            T value )
    {
        super(source, parent, name, -1);
        myValue = value;
    }

    /**
     * Constructor for EntityRemoveEvent with source ref and index.
     * 
     * @param source
     *            source of event ( who produce this event ).
     * @param parent
     *            element in OM that contains event entity.
     * @param name
     *            entity name.
     * @param value
     *            old entity value.
     * @param index
     *            index of child entity in parent.
     */
    public EntityRemoveEvent( Object source, BpelEntity parent, String name,
            T value, int index )
    {
        super(source, parent, name, index);
        myValue = value;
    }

    /**
     * Constructor for EntityRemoveEvent without source ref.
     * 
     * @param parent
     *            element in OM that contains event entity.
     * @param name
     *            entity name.
     * @param value
     *            old entity value.
     */
    public EntityRemoveEvent( BpelEntity parent, String name, T value ) {
        this(Thread.currentThread(), parent, name, value);
    }

    /**
     * Constructor for EntityRemoveEvent with index and without source ref.
     * 
     * @param parent
     *            element in OM that contains event entity.
     * @param name
     *            entity name.
     * @param value
     *            old entity value.
     * @param index
     *            index of child entity in parent.
     */
    public EntityRemoveEvent( BpelEntity parent, String name, T value, int index )
    {
        this(Thread.currentThread(), parent, name, value, index);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.netbeans.modules.soa.model.bpel.api.events.OutOfModelEvent#getOutOfModelEntity()
     */
    /** {@inheritDoc} */
    public BpelEntity getOutOfModelEntity() {
        return getOldValue();
    }

    /**
     * @return inserted value.
     */
    public T getOldValue() {
        return myValue;
    }

    private T myValue;

}
