/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.editor.hints.options;

import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.netbeans.spi.editor.hints.ProviderDescription;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.awt.HtmlRenderer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/**
 *
 * @author  Jan Lahoda
 */
public class AdvancedPanelImpl extends javax.swing.JPanel {
    
    private ModelImpl model;
    
    /** Creates new form AdvancedPanelImpl */
    public AdvancedPanelImpl(ModelImpl model) {
	this.model = model;
        initComponents();
        
        loc(jCheckBox1, "CTL_enabled");
        loc(jLabel1, "CTL_eagerness");
        
        jTable1.setDefaultRenderer(Severity.class, new SeverityCellRenderer());
        JComboBox editor = new JComboBox(new Object[] {
            Severity.ERROR,
            Severity.WARNING,
            Severity.VERIFIER,
            Severity.HINT,
            Severity.TODO,
            Severity.DISABLED,
        });
        editor.setRenderer(new SeverityComboRenderer());
        jTable1.setDefaultEditor(Severity.class, new DefaultCellEditor(editor));
        TableColumn c = jTable1.getColumnModel().getColumn(0);
        c.setHeaderValue("XXXXXXXXX"); // NOI18N
        c.setHeaderRenderer(new HeaderTableCellRenderer());
        c.sizeWidthToFit();
        updateForCurrentProvider();
        
        eagerCombo.setModel(new javax.swing.DefaultComboBoxModel(new String[] { 
            loc("LBL_eagerness_on_project_open"), 
            loc("LBL_eagerness_on_demand"), 
            loc("LBL_eagerness_lazy")
        }));
        eagerCombo.setSelectedIndex(2/*model.getEagerness()*/);
    }
    
    private static String loc(String key) {
        return NbBundle.getMessage(AdvancedPanelImpl.class, key);
    }
    
    private static void loc(Component c, String key) {
        if (c instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton) c, loc(key));
        } else {
            Mnemonics.setLocalizedText((JLabel) c, loc(key));
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {

        jComboBox1 = new javax.swing.JComboBox();
        jCheckBox1 = new javax.swing.JCheckBox();
        jTable1 = new javax.swing.JTable();
        jLabel1 = new javax.swing.JLabel();
        eagerCombo = new javax.swing.JComboBox();

        jComboBox1.setModel(new ComboModelImpl());
        jComboBox1.setSelectedIndex(jComboBox1.getModel().getSize() > 0 ? 0 : (-1));
        jComboBox1.setRenderer(new RendererImpl());
        jComboBox1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBox1ActionPerformed(evt);
            }
        });

        jCheckBox1.setText("Enabled");
        jCheckBox1.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jCheckBox1.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jCheckBox1.setOpaque(false);
        jCheckBox1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBox1ActionPerformed(evt);
            }
        });

        jTable1.setModel(new OptionsTableModel());
        jTable1.setRowSelectionAllowed(false);
        jTable1.setShowHorizontalLines(false);
        jTable1.setShowVerticalLines(false);

        jLabel1.setText("Eagerness:");

        eagerCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                eagerComboActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jTable1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 454, Short.MAX_VALUE)
                    .add(jCheckBox1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 454, Short.MAX_VALUE)
                    .add(layout.createSequentialGroup()
                        .add(jLabel1)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(eagerCombo, 0, 396, Short.MAX_VALUE))
                    .add(jComboBox1, 0, 454, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel1)
                    .add(eagerCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jComboBox1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jTable1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jCheckBox1))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void eagerComboActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_eagerComboActionPerformed
        /*model.setEagerness(eagerCombo.getSelectedIndex());*/
    }//GEN-LAST:event_eagerComboActionPerformed

    private void jCheckBox1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBox1ActionPerformed
        model.setProviderEnabled(getProviderDescription().getKey(), jCheckBox1.isSelected());
        
        int index = jComboBox1.getSelectedIndex();
        
        ((ComboModelImpl) jComboBox1.getModel()).fireContentsChanged(index, index);
    }//GEN-LAST:event_jCheckBox1ActionPerformed

    private void jComboBox1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox1ActionPerformed
        updateForCurrentProvider();
    }//GEN-LAST:event_jComboBox1ActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    public javax.swing.JComboBox eagerCombo;
    public javax.swing.JCheckBox jCheckBox1;
    public javax.swing.JComboBox jComboBox1;
    public javax.swing.JLabel jLabel1;
    public javax.swing.JTable jTable1;
    // End of variables declaration//GEN-END:variables
    
    private void updateForCurrentProvider() {
        ProviderDescription desc = getProviderDescription();
        
        if (desc != null) {
            jCheckBox1.setSelected(model.isProviderEnabled(desc.getKey()));
            jCheckBox1.setEnabled(true);
        } else {
            jCheckBox1.setSelected(false);
            jCheckBox1.setEnabled(false);
        }
        
        ((OptionsTableModel) jTable1.getModel()).fireTableDataChanged();
    }
    
    private ProviderDescription getProviderDescription() {
        return (ProviderDescription) jComboBox1.getSelectedItem();
    }
    
    private final class ComboModelImpl extends DefaultComboBoxModel {

        public int getSize() {
            return model.getDescriptions().size();
        }

        public Object getElementAt(int index) {
            return model.getDescriptions().get(index);
        }
        
        public void fireContentsChanged(int start, int end) {
            super.fireContentsChanged(this, start, end);
        }

    }
    
    private static final class HeaderTableCellRenderer extends JLabel implements TableCellRenderer {
        
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            setText((String) value);
            return this;
        }
        
    }
    
    private final class RendererImpl implements ListCellRenderer {
	
	private ListCellRenderer delegateTo;
	
	public RendererImpl() {
	    delegateTo = HtmlRenderer.createRenderer();
	}
	
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String text;
            
            if (value == null) {
                text = "<none>";
            } else {
                text = ((ProviderDescription) value).getDisplayName();
                
                if (!model.isProviderEnabled(((ProviderDescription) value).getKey())) {
                    text = "<html><s>" + text;
                }
            }
            
            return delegateTo.getListCellRendererComponent(list, text, index, isSelected, cellHasFocus);
        }
    }
    
    private final class OptionsTableModel extends AbstractTableModel {
        
        public int getRowCount() {
            ProviderDescription desc = getProviderDescription();
            
            if (desc == null)
                return 0;
            
            return desc.getSupportedErrorKeys().size();
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0:
                    return "Severity";
                case 1:
                    return "Name";
                default:
                    throw new IllegalArgumentException("columnIndex=" + columnIndex);
            }
        }

        public Class getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0:
                    return Severity.class;
                case 1:
                    return String.class;
                default:
                    throw new IllegalArgumentException("columnIndex=" + columnIndex);
            }
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0:
                    return true;
                case 1:
                    return false;
                default:
                    throw new IllegalArgumentException("columnIndex=" + columnIndex);
            }
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            ProviderDescription desc = getProviderDescription();
            
            switch (columnIndex) {
                case 0:
                    return model.getErrorSeverity(desc.getKey(), (String) desc.getSupportedErrorKeys().get(rowIndex));
                case 1:
                    return desc.getErrorDisplayName((String) desc.getSupportedErrorKeys().get(rowIndex));
                default:
                    throw new IllegalArgumentException("columnIndex=" + columnIndex);
            }
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            ProviderDescription desc = getProviderDescription();
            
            switch (columnIndex) {
                case 0:
                    model.setSeverity(desc.getKey(), (String) desc.getSupportedErrorKeys().get(rowIndex), (Severity) aValue);
                    return ;
                default:
                    throw new IllegalArgumentException("columnIndex=" + columnIndex);
            }
        }

    }
    
    private static final class SeverityCellRenderer implements TableCellRenderer {
        
	private TableCellRenderer delegateTo;
	
	public SeverityCellRenderer() {
	    delegateTo = HtmlRenderer.createRenderer();
	}
	
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return delegateTo.getTableCellRendererComponent(table, SEVERITIES.get(((Severity) value).ordinal()), isSelected, hasFocus, row, column);
        }
    }

    private static final String[] SEVERITIES_ARRAY = new String[] {
        "<html><font color=\"#808080\">disabled",
        "<html><font color=\"#800000\">error",
        "<html><font color=\"#808000\">warning",
        "<html><font color=\"#000080\">verifier",
        "<html><font color=\"#000080\">hint",
        "<html><font color=\"#000080\">todo",
    };
    
    static final List SEVERITIES = Arrays.asList(SEVERITIES_ARRAY);
    
}
