/*
* Copyright 2005 Sun Microsystems, Inc. All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
*
* - Redistributions of source code must retain the above copyright
*   notice, this list of conditions and the following disclaimer.
*
* - Redistribution in binary form must reproduce the above copyright
*   notice, this list of conditions and the following disclaimer in
*   the documentation and/or other materials provided with the
*   distribution.
*
* Neither the name of Sun Microsystems, Inc. or the names of
* contributors may be used to endorse or promote products derived
* from this software without specific prior written permission.
*
* This software is provided "AS IS," without a warranty of any
* kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
* WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
* EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES
* SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
* DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN
* OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR
* FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR
* PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF
* LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE SOFTWARE,
* EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*
* You acknowledge that Software is not designed, licensed or intended
* for use in the design, construction, operation or maintenance of
* any nuclear facility.
*/

package com.sun.j2ee.blueprints.opc.workflowmanager.handlers;

import javax.jms.*;

import com.sun.j2ee.blueprints.opc.invoice.*;
import com.sun.j2ee.blueprints.opc.*;
import com.sun.j2ee.blueprints.processmanager.ejb.*;
import com.sun.j2ee.blueprints.servicelocator.*;
import com.sun.j2ee.blueprints.servicelocator.ejb.*;
import com.sun.j2ee.blueprints.opc.purchaseorder.ejb.*;
import com.sun.j2ee.blueprints.opc.utils.*;
import com.sun.j2ee.blueprints.opc.JNDINames;
import com.sun.j2ee.blueprints.opc.mailer.*;

/**
 * This is the Invoice handler that gets called by the
 * OPC Work Flow Manager. This handler calls the
 * workers that process the invoice
 */
public class InvoiceHandler {
    
    private ProcessManagerLocal processManager;    
    private ServiceLocator sl;
    
    public InvoiceHandler() throws HandlerException {
        try{
            sl = new ServiceLocator();
            ProcessManagerLocalHome pmHome =
                (ProcessManagerLocalHome)sl.getLocalHome(JNDINames.PM_EJB);
            processManager = pmHome.create();
        } catch (Exception exe) {
            System.err.println(exe);
            throw new HandlerException("OPC Exception creating InvoiceHandler"); 
        }
    }
    
    public void handle(Message message) throws HandlerException {
        Invoice invoice = null;
        String inv = null;
        String opcPoID = null;
        
        //extract the Invoice from the message
        try {
            if(message instanceof TextMessage){
                TextMessage txtMsg = (TextMessage) message;
                inv = txtMsg.getText();
            }    
            if(inv != null){ 
                invoice = Invoice.fromXML(inv);
                String supplierID = invoice.getSupplierId();
                opcPoID = invoice.getOpcPoId();
                String invStat = invoice.getStatus();
                if(supplierID.equals(JNDINames.ACTIVITY_INVOICE))
                    processManager.updateActivityOrderStatus(opcPoID, invStat);
                if(supplierID.equals(JNDINames.LODGING_INVOICE))
                    processManager.updateLodgingOrderStatus(opcPoID, invStat);
                if(supplierID.equals(JNDINames.AIRLINE_INVOICE))
                    processManager.updateAirlineOrderStatus(opcPoID, invStat);                                  
           }
        } catch (XMLException exe) {
            System.err.println(exe);
            //call process manager and set error status
            try{ 
                /* 
                 * The status is set to invoice xml error, indicating that an error
                 * occurred while deserializing the invoice. Advanced error handling 
                 * will be done for a later release, with the status having additional
                 * information about the supplier(lodging, activity, or airline)
                 */
                processManager.updateStatus(opcPoID,OrderStatusNames.INVOICE_XML_ERROR);
                processManager.updateOrderErrorStatus(opcPoID, true);
            } catch(Exception xe){
                System.err.println(xe);
            }    
        } catch (Exception exe) {
            System.err.println(exe);
            throw new HandlerException("OPC Exception handling invoice");
        }    
    }
   
    public void sendOrderCompletedMail(String orderID) throws HandlerException{
        boolean sendMail = sl.getBoolean(JNDINames.SEND_MAIL);
        try{
            //get email id and call CRM
            if(sendMail){
                PurchaseOrderLocalHome poHome = 
                  (PurchaseOrderLocalHome)sl.getLocalHome(JNDINames.PO_EJB);
                PurchaseOrderLocal poLocal = poHome.findByPrimaryKey(orderID);
                String msg = "Your order (# " + orderID  + " ) has been completed.";
                msg += " Thank you for shopping with us and we hope to see you again soon";
                Mail mail = new Mail(poLocal.getEmailId(),
                       " Your Adventure Builder order has been completed ", msg); 
                String xmlMail = mail.toXML();
                JMSUtils.sendMessage(JNDINames.CRM_MDB_QUEUE, 
                                JNDINames.DOC_TYPE, JNDINames.MAIL_DOCUMENT, xmlMail);
            }
        } catch (Exception exe) {
            System.err.println(exe);
            throw new HandlerException("OPC Exception sending mail");
        }     

    }
}
