/*
* Copyright 2005 Sun Microsystems, Inc. All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
*
* - Redistributions of source code must retain the above copyright
*   notice, this list of conditions and the following disclaimer.
*
* - Redistribution in binary form must reproduce the above copyright
*   notice, this list of conditions and the following disclaimer in
*   the documentation and/or other materials provided with the
*   distribution.
*
* Neither the name of Sun Microsystems, Inc. or the names of
* contributors may be used to endorse or promote products derived
* from this software without specific prior written permission.
*
* This software is provided "AS IS," without a warranty of any
* kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
* WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
* EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES
* SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
* DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN
* OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR
* FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR
* PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF
* LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE SOFTWARE,
* EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*
* You acknowledge that Software is not designed, licensed or intended
* for use in the design, construction, operation or maintenance of
* any nuclear facility.
*/

package com.sun.j2ee.blueprints.opc.webservicebroker.requestor;

import javax.jms.*;
import javax.ejb.*;

import com.sun.j2ee.blueprints.opc.JNDINames;

public class BrokerRequestorBean implements
       MessageDrivenBean, MessageListener {

    private  MessageDrivenContext context; 

    public void setMessageDrivenContext(MessageDrivenContext context) {
        this.context=context;
    }  
      
    public void ejbCreate() {}
      
    public void onMessage(Message message) {
  WSClient target = null;

  try {
      // Step 1 : Retrieve property that indicates to whom this doc is 
      // to be sent
      String docType = message.getStringProperty(JNDINames.DOC_TYPE);
            
      // Step 2 : Get the client implementation through the factory
      if(docType.equals(JNDINames.ACTIVITY_ORDER))
    target = WSClientFactory.getWSClient(JNDINames.ACTIVITY_SUPPLIER_CLIENT);
      else if(docType.equals(JNDINames.LODGING_ORDER))
    target = WSClientFactory.getWSClient(JNDINames.LODGING_SUPPLIER_CLIENT);
      else if(docType.equals(JNDINames.AIRLINE_ORDER))
    target = WSClientFactory.getWSClient(JNDINames.AIRLINE_SUPPLIER_CLIENT);

      // Step 3 : Send the document
      if(target != null) {
    TextMessage msg = (TextMessage) message;
    String po = msg.getText();
    String retVal = target.sendRequest(po);
      }
  } catch (JMSException jex) {
      throw new EJBException(jex);
  }
    }
    
    public void ejbRemove() {}
}

