/*
* Copyright 2005 Sun Microsystems, Inc. All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
*
* - Redistributions of source code must retain the above copyright
*   notice, this list of conditions and the following disclaimer.
*
* - Redistribution in binary form must reproduce the above copyright
*   notice, this list of conditions and the following disclaimer in
*   the documentation and/or other materials provided with the
*   distribution.
*
* Neither the name of Sun Microsystems, Inc. or the names of
* contributors may be used to endorse or promote products derived
* from this software without specific prior written permission.
*
* This software is provided "AS IS," without a warranty of any
* kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
* WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
* EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES
* SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
* DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN
* OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR
* FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR
* PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF
* LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE SOFTWARE,
* EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*
* You acknowledge that Software is not designed, licensed or intended
* for use in the design, construction, operation or maintenance of
* any nuclear facility.
*/

package com.sun.j2ee.blueprints.opc.purchaseorder;

import java.util.*;
import java.text.*;
import java.io.*;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;
import javax.xml.transform.*;
import javax.xml.transform.dom.*;
import javax.xml.transform.stream.*;

public class Activity implements Serializable{

  protected String activityId;
  protected String name;
  protected float price;
  protected String location;
  protected Calendar startDate;
  protected Calendar endDate;
  protected int headCount;

  // Constructor
  public Activity() {}

  public Activity(String activityId, String name, float price, String location,
                  Calendar startDate, Calendar endDate, int headCount) {
    this.activityId = activityId;
    this.name = name;
    this.price = price;
    this.location = location;
    this.startDate = startDate;
    this.endDate = endDate;
    this.headCount = headCount;
  }

  // getter methods
  public String getActivityId() {
    return activityId;
  }

  public String getName() {
    return name;
  }

  public float getPrice() {
    return price;
  }

  public String getLocation() {
    return location;
  }

  public Calendar getStartDate() {
    return startDate;
  }

  public Calendar getEndDate() {
    return endDate;
  }

  public int getHeadCount() {
    return headCount;
  }

  // setter methods
  public void setActivityId(String activityId) {
    this.activityId = activityId;
  }

  public void setName(String name) {
    this.name = name;
  }

  public void setPrice(float price) {
    this.price = price;
  }

  public void setLocation(String location) {
    this.location = location;
  }

  public void setStartDate(Calendar startDate) {
    this.startDate = startDate;
  }

  public void setEndDate(Calendar endDate) {
    this.endDate = endDate;
  }

  public void setHeadCount(int headCount) {
    this.headCount = headCount;
  }
  
  //XML serialization methods
  public String toXML(String poId) throws XMLException{
          
      String actyPO = null;      
      try{
          
          //construct the DOM tree
          DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
          docBuilderFactory.setNamespaceAware(true);
          DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
          Document doc = docBuilder.newDocument();          
          Element  actyElem = doc.createElement("Activity");
          doc.appendChild(actyElem);          
          Element  elem = doc.createElement("OPCPoId");          
          elem.appendChild(doc.createTextNode(poId));
          actyElem.appendChild(elem);          
          elem = doc.createElement("ActivityId");          
          elem.appendChild(doc.createTextNode(activityId));
          actyElem.appendChild(elem);          
          elem = doc.createElement("StartDate");
          elem.appendChild(doc.createTextNode((new SimpleDateFormat("MM-dd-yy")).format(startDate.getTime())));
          actyElem.appendChild(elem);          
          elem = doc.createElement("EndDate");
          elem.appendChild(doc.createTextNode((new SimpleDateFormat("MM-dd-yy")).format(endDate.getTime())));
          actyElem.appendChild(elem);          
          elem = doc.createElement("HeadCount");        
          elem.appendChild(doc.createTextNode(Integer.toString(headCount)));
          actyElem.appendChild(elem);          
                   
          //process the source tree
          ByteArrayOutputStream baStream = new ByteArrayOutputStream();
          Result res = new StreamResult(baStream);
          TransformerFactory transFactory = TransformerFactory.newInstance();
          Transformer transformer = transFactory.newTransformer();
          transformer.setOutputProperty(OutputKeys.METHOD, "xml");          
          transformer.setOutputProperty(OutputKeys.ENCODING, "UTF-8");
      transformer.setOutputProperty(OutputKeys.INDENT, "yes");
      transformer.transform(new DOMSource(doc), res);
          actyPO = baStream.toString("UTF-8");  
          
      } catch(Exception exe){
          throw new XMLException(exe);         
      }
      return actyPO;   
  }
}
