/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.client;

import java.util.List;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.client.Client;
import org.codehaus.xfire.exchange.MessageExchange;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.handler.HandlerPipeline;
import org.codehaus.xfire.service.Binding;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.binding.ServiceInvocationHandler;
import org.codehaus.xfire.soap.Soap11;
import org.codehaus.xfire.soap.Soap11Binding;
import org.codehaus.xfire.soap.Soap12;
import org.codehaus.xfire.soap.Soap12Binding;

public class Invocation {
    static final String CONTEXT_KEY = "client.call";
    private Object[] response;
    private MessageContext context;
    private Exception fault;
    private Client client;

    public Invocation(Client client) {
        this.client = client;
    }

    public MessageContext getContext() {
        return this.context;
    }

    Object[] invoke(OperationInfo op, Object[] params) throws Exception {
        try {
            OutMessage msg = new OutMessage(this.client.getUrl());
            msg.setBody(params);
            msg.setChannel(this.client.getOutChannel());
            Binding binding = this.client.getBinding();
            if (binding instanceof Soap11Binding) {
                msg.setSoapVersion(Soap11.getInstance());
            } else if (binding instanceof Soap12Binding) {
                msg.setSoapVersion(Soap12.getInstance());
            }
            this.context = new MessageContext();
            this.context.setService(this.client.getService());
            this.context.setXFire(this.client.getXFire());
            this.context.setBinding(binding);
            this.context.setProperty("client.mode", Boolean.TRUE);
            this.context.setClient(this.client);
            this.context.setProperty(CONTEXT_KEY, this);
            MessageExchange exchange = new MessageExchange(this.context);
            exchange.setOperation(op);
            exchange.setOutMessage(msg);
            this.context.setCurrentMessage(msg);
            HandlerPipeline outPipe = new HandlerPipeline(this.client.getXFire().getOutPhases());
            outPipe.addHandlers(this.client.getXFire().getOutHandlers());
            outPipe.addHandlers(this.client.getOutHandlers());
            outPipe.addHandlers(this.client.getTransport().getOutHandlers());
            this.context.setOutPipeline(outPipe);
            ServiceInvocationHandler.writeHeaders(this.context, null);
            outPipe.invoke(this.context);
        }
        catch (Exception e1) {
            throw XFireFault.createFault(e1);
        }
        this.waitForResponse();
        if (this.fault != null) {
            Exception localFault = this.fault;
            this.fault = null;
            throw localFault;
        }
        Object[] localResponse = this.response;
        this.response = null;
        return localResponse;
    }

    protected void waitForResponse() {
        if (!this.client.getOutChannel().isAsync() || this.response != null || this.fault != null || !this.context.getExchange().getOperation().hasOutput()) {
            return;
        }
        for (int count = 0; this.response == null && this.fault == null && count < this.client.getTimeout(); count += 50) {
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    public void receive(Object response) {
        this.response = ((List)response).toArray();
    }

    public void receiveFault(Exception fault) {
        this.fault = fault;
    }
}

