/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.main.JavacOption;
import com.sun.tools.javac.main.OptionName;
import com.sun.tools.javac.main.RecognizedOptions;
import com.sun.tools.javac.util.BaseFileObject;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Paths;
import com.sun.tools.javac.util.Version;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.lang.model.SourceVersion;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Version(value="@(#)JavacFileManager.java\t1.48 07/05/05")
public class JavacFileManager
implements StandardJavaFileManager {
    protected Log log;
    private Paths paths;
    private Options options;
    private final File uninited = new File("U N I N I T E D");
    private final Set<JavaFileObject.Kind> sourceOrClass = EnumSet.of(JavaFileObject.Kind.SOURCE, JavaFileObject.Kind.CLASS);
    private File classOutDir = this.uninited;
    private File sourceOutDir = this.uninited;
    protected boolean mmappedIO;
    protected boolean ignoreSymbolFile;
    protected Charset charset;
    private static final boolean fileSystemIsCaseSensitive = File.separatorChar == '/';
    Map<File, Archive> archives = new HashMap<File, Archive>();
    private static final String[] symbolFileLocation = new String[]{"lib", "ct.sym"};
    private static final String symbolFilePrefix = "META-INF/sym/rt.jar/";
    private Map<JavaFileObject, SoftReference<CharBuffer>> contentCache = new HashMap<JavaFileObject, SoftReference<CharBuffer>>();
    private String defaultEncodingName;
    private final ByteBufferCache byteBufferCache;
    private static JavacOption[] javacFileManagerOptions = RecognizedOptions.getJavacFileManagerOptions(new RecognizedOptions.GrumpyHelper());

    public static char[] toArray(CharBuffer buffer) {
        if (buffer.hasArray()) {
            return ((CharBuffer)buffer.compact().flip()).array();
        }
        return buffer.toString().toCharArray();
    }

    public static void preRegister(final Context context) {
        context.put(JavaFileManager.class, new Context.Factory<JavaFileManager>(){

            @Override
            public JavaFileManager make() {
                return new JavacFileManager(context, true, null);
            }
        });
    }

    public JavacFileManager(Context context, boolean register, Charset charset) {
        if (register) {
            context.put(JavaFileManager.class, this);
        }
        this.byteBufferCache = new ByteBufferCache();
        this.charset = charset;
        this.setContext(context);
    }

    public void setContext(Context context) {
        this.log = Log.instance(context);
        if (this.paths == null) {
            this.paths = Paths.instance(context);
        } else {
            this.paths.setContext(context);
        }
        this.options = Options.instance(context);
        this.mmappedIO = this.options.get("mmappedIO") != null;
        this.ignoreSymbolFile = this.options.get("ignore.symbol.file") != null;
    }

    public JavaFileObject getFileForInput(String name) {
        return this.getRegularFile(new File(name));
    }

    public JavaFileObject getRegularFile(File file) {
        return new RegularFileObject(file);
    }

    public JavaFileObject getFileForOutput(String classname, JavaFileObject.Kind kind, JavaFileObject sibling) throws IOException {
        return this.getJavaFileForOutput(StandardLocation.CLASS_OUTPUT, classname, kind, sibling);
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromStrings(Iterable<String> names) {
        ListBuffer<File> files = new ListBuffer<File>();
        for (String name : names) {
            files.append(new File(JavacFileManager.nullCheck(name)));
        }
        return this.getJavaFileObjectsFromFiles(files.toList());
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(String ... names) {
        return this.getJavaFileObjectsFromStrings(Arrays.asList((Object[])JavacFileManager.nullCheck(names)));
    }

    protected JavaFileObject.Kind getKind(String extension) {
        if (extension.equals(JavaFileObject.Kind.CLASS.extension)) {
            return JavaFileObject.Kind.CLASS;
        }
        if (extension.equals(JavaFileObject.Kind.SOURCE.extension)) {
            return JavaFileObject.Kind.SOURCE;
        }
        if (extension.equals(JavaFileObject.Kind.HTML.extension)) {
            return JavaFileObject.Kind.HTML;
        }
        return JavaFileObject.Kind.OTHER;
    }

    private static boolean isValidName(String name) {
        for (String s : name.split("\\.", -1)) {
            if (SourceVersion.isIdentifier(s)) continue;
            return false;
        }
        return true;
    }

    private static void validateClassName(String className) {
        if (!JavacFileManager.isValidName(className)) {
            throw new IllegalArgumentException("Invalid class name: " + className);
        }
    }

    private static void validatePackageName(String packageName) {
        if (packageName.length() > 0 && !JavacFileManager.isValidName(packageName)) {
            throw new IllegalArgumentException("Invalid packageName name: " + packageName);
        }
    }

    public static void testName(String name, boolean isValidPackageName, boolean isValidClassName) {
        try {
            JavacFileManager.validatePackageName(name);
            if (!isValidPackageName) {
                throw new AssertionError((Object)("Invalid package name accepted: " + name));
            }
            JavacFileManager.printAscii("Valid package name: \"%s\"", name);
        }
        catch (IllegalArgumentException e) {
            if (isValidPackageName) {
                throw new AssertionError((Object)("Valid package name rejected: " + name));
            }
            JavacFileManager.printAscii("Invalid package name: \"%s\"", name);
        }
        try {
            JavacFileManager.validateClassName(name);
            if (!isValidClassName) {
                throw new AssertionError((Object)("Invalid class name accepted: " + name));
            }
            JavacFileManager.printAscii("Valid class name: \"%s\"", name);
        }
        catch (IllegalArgumentException e) {
            if (isValidClassName) {
                throw new AssertionError((Object)("Valid class name rejected: " + name));
            }
            JavacFileManager.printAscii("Invalid class name: \"%s\"", name);
        }
    }

    private static void printAscii(String format, Object ... args) {
        String message;
        try {
            String ascii = "US-ASCII";
            message = new String(String.format(null, format, args).getBytes("US-ASCII"), "US-ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            throw new AssertionError((Object)ex);
        }
        System.out.println(message);
    }

    private static String externalizeFileName(CharSequence name) {
        return ((Object)name).toString().replace('.', File.separatorChar);
    }

    private static String externalizeFileName(CharSequence n, JavaFileObject.Kind kind) {
        return JavacFileManager.externalizeFileName(n) + kind.extension;
    }

    private static String baseName(String fileName) {
        return fileName.substring(fileName.lastIndexOf(File.separatorChar) + 1);
    }

    private void listDirectory(File directory, String subdirectory, Set<JavaFileObject.Kind> fileKinds, boolean recurse, ListBuffer<JavaFileObject> l) {
        block13: {
            File d;
            block12: {
                List<String> files;
                Archive archive = this.archives.get(directory);
                if (archive == null && !directory.isFile()) break block12;
                if (archive == null) {
                    try {
                        archive = this.openArchive(directory);
                    }
                    catch (IOException ex) {
                        this.log.error("error.reading.file", directory, ex.getLocalizedMessage());
                        return;
                    }
                }
                if (subdirectory.length() != 0 && !(subdirectory = subdirectory.replace('\\', '/')).endsWith("/")) {
                    subdirectory = subdirectory + "/";
                }
                if ((files = archive.getFiles(subdirectory)) != null) {
                    while (!files.isEmpty()) {
                        String file = (String)files.head;
                        if (this.isValidFile(file, fileKinds)) {
                            l.append(archive.getFileObject(subdirectory, file));
                        }
                        files = files.tail;
                    }
                }
                if (!recurse) break block13;
                for (String s : archive.getSubdirectories()) {
                    if (!s.startsWith(subdirectory) || s.equals(subdirectory)) continue;
                    this.listDirectory(directory, s, fileKinds, false, l);
                }
                break block13;
            }
            File file = d = subdirectory.length() != 0 ? new File(directory, subdirectory) : directory;
            if (!this.caseMapCheck(d, subdirectory)) {
                return;
            }
            File[] files = d.listFiles();
            if (files == null) {
                return;
            }
            for (File f : files) {
                String fname = f.getName();
                if (f.isDirectory()) {
                    if (!recurse || !SourceVersion.isIdentifier(fname)) continue;
                    this.listDirectory(directory, subdirectory + File.separator + fname, fileKinds, recurse, l);
                    continue;
                }
                if (!this.isValidFile(fname, fileKinds)) continue;
                RegularFileObject fe = new RegularFileObject(fname, new File(d, fname));
                l.append(fe);
            }
        }
    }

    private boolean isValidFile(String s, Set<JavaFileObject.Kind> fileKinds) {
        int lastDot = s.lastIndexOf(".");
        String extn = lastDot == -1 ? s : s.substring(lastDot);
        JavaFileObject.Kind kind = this.getKind(extn);
        return fileKinds.contains((Object)kind);
    }

    private boolean caseMapCheck(File f, String name) {
        String path;
        if (fileSystemIsCaseSensitive) {
            return true;
        }
        try {
            path = f.getCanonicalPath();
        }
        catch (IOException ex) {
            return false;
        }
        char[] pcs = path.toCharArray();
        char[] ncs = name.toCharArray();
        int i = pcs.length - 1;
        int j = ncs.length - 1;
        while (i >= 0 && j >= 0) {
            while (i >= 0 && pcs[i] == File.separatorChar) {
                --i;
            }
            while (j >= 0 && ncs[j] == File.separatorChar) {
                --j;
            }
            if (i < 0 || j < 0) continue;
            if (pcs[i] != ncs[j]) {
                return false;
            }
            --i;
            --j;
        }
        return j < 0;
    }

    protected Archive openArchive(File zipFileName) throws IOException {
        Archive archive = this.archives.get(zipFileName);
        if (archive == null) {
            File origZipFileName = zipFileName;
            if (!this.ignoreSymbolFile && this.paths.isBootClassPathRtJar(zipFileName)) {
                File file = zipFileName.getParentFile().getParentFile();
                if (new File(file.getName()).equals(new File("jre"))) {
                    file = file.getParentFile();
                }
                for (String name : symbolFileLocation) {
                    file = new File(file, name);
                }
                if (file.exists()) {
                    zipFileName = file;
                }
            }
            try {
                ZipFile zdir = new ZipFile(zipFileName);
                archive = origZipFileName == zipFileName ? new ZipArchive(zdir) : new SymbolArchive(origZipFileName, zdir);
            }
            catch (FileNotFoundException ex) {
                archive = new MissingArchive(zipFileName);
            }
            catch (IOException ex) {
                this.log.error("error.reading.file", zipFileName, ex.getLocalizedMessage());
                archive = new MissingArchive(zipFileName);
            }
            this.archives.put(origZipFileName, archive);
        }
        return archive;
    }

    @Override
    public void flush() {
        this.contentCache.clear();
    }

    @Override
    public void close() {
        Iterator<Archive> i = this.archives.values().iterator();
        while (i.hasNext()) {
            Archive a = i.next();
            i.remove();
            try {
                a.close();
            }
            catch (IOException iOException) {}
        }
    }

    private String getDefaultEncodingName() {
        if (this.defaultEncodingName == null) {
            this.defaultEncodingName = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
        }
        return this.defaultEncodingName;
    }

    protected String getEncodingName() {
        String encName = this.options.get(OptionName.ENCODING);
        if (encName == null) {
            return this.getDefaultEncodingName();
        }
        return encName;
    }

    protected Source getSource() {
        String sourceName = this.options.get(OptionName.SOURCE);
        Source source = null;
        if (sourceName != null) {
            source = Source.lookup(sourceName);
        }
        return source != null ? source : Source.DEFAULT;
    }

    private ByteBuffer makeByteBuffer(InputStream in) throws IOException {
        int limit = in.available();
        if (this.mmappedIO && in instanceof FileInputStream) {
            FileInputStream fin = (FileInputStream)in;
            return fin.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, limit);
        }
        if (limit < 1024) {
            limit = 1024;
        }
        ByteBuffer result = this.byteBufferCache.get(limit);
        int position = 0;
        while (in.available() != 0) {
            int count;
            if (position >= limit) {
                result = ByteBuffer.allocate(limit <<= 1).put((ByteBuffer)result.flip());
            }
            if ((count = in.read(result.array(), position, limit - position)) < 0) break;
            result.position(position += count);
        }
        return (ByteBuffer)result.flip();
    }

    private CharsetDecoder getDecoder(String encodingName, boolean ignoreEncodingErrors) {
        Charset charset = this.charset == null ? Charset.forName(encodingName) : this.charset;
        CharsetDecoder decoder = charset.newDecoder();
        CodingErrorAction action = ignoreEncodingErrors ? CodingErrorAction.REPLACE : CodingErrorAction.REPORT;
        return decoder.onMalformedInput(action).onUnmappableCharacter(action);
    }

    private CharBuffer decode(ByteBuffer inbuf, boolean ignoreEncodingErrors) {
        CoderResult result;
        CharsetDecoder decoder;
        String encodingName = this.getEncodingName();
        try {
            decoder = this.getDecoder(encodingName, ignoreEncodingErrors);
        }
        catch (IllegalCharsetNameException e) {
            this.log.error("unsupported.encoding", encodingName);
            return (CharBuffer)CharBuffer.allocate(1).flip();
        }
        catch (UnsupportedCharsetException e) {
            this.log.error("unsupported.encoding", encodingName);
            return (CharBuffer)CharBuffer.allocate(1).flip();
        }
        float factor = decoder.averageCharsPerByte() * 0.8f + decoder.maxCharsPerByte() * 0.2f;
        CharBuffer dest = CharBuffer.allocate(10 + (int)((float)inbuf.remaining() * factor));
        while (true) {
            result = decoder.decode(inbuf, dest, true);
            dest.flip();
            if (result.isUnderflow()) {
                if (dest.limit() == dest.capacity()) {
                    dest = CharBuffer.allocate(dest.capacity() + 1).put(dest);
                    dest.flip();
                }
                return dest;
            }
            if (result.isOverflow()) {
                int newCapacity = 10 + dest.capacity() + (int)((float)inbuf.remaining() * decoder.maxCharsPerByte());
                dest = CharBuffer.allocate(newCapacity).put(dest);
                continue;
            }
            if (!result.isMalformed() && !result.isUnmappable()) break;
            if (!this.getSource().allowEncodingErrors()) {
                this.log.error(new JCDiagnostic.SimpleDiagnosticPosition(dest.limit()), "illegal.char.for.encoding", this.charset == null ? encodingName : this.charset.name());
            } else {
                this.log.warning(new JCDiagnostic.SimpleDiagnosticPosition(dest.limit()), "illegal.char.for.encoding", this.charset == null ? encodingName : this.charset.name());
            }
            inbuf.position(inbuf.position() + result.length());
            dest.position(dest.limit());
            dest.limit(dest.capacity());
            dest.put('\ufffd');
        }
        throw new AssertionError(result);
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        JavacFileManager.nullCheck(location);
        Iterable<? extends File> path = this.getLocation(location);
        if (path == null) {
            return null;
        }
        ListBuffer<URL> lb = new ListBuffer<URL>();
        for (File file : path) {
            try {
                lb.append(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
        }
        return new URLClassLoader(lb.toArray(new URL[lb.size()]), this.getClass().getClassLoader());
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        JavacFileManager.nullCheck(packageName);
        JavacFileManager.nullCheck(kinds);
        Iterable<? extends File> path = this.getLocation(location);
        if (path == null) {
            return List.nil();
        }
        String subdirectory = JavacFileManager.externalizeFileName(packageName);
        ListBuffer<JavaFileObject> results = new ListBuffer<JavaFileObject>();
        for (File file : path) {
            this.listDirectory(file, subdirectory, kinds, recurse, results);
        }
        return results.toList();
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        file.getClass();
        location.getClass();
        Iterable<? extends File> path = this.getLocation(location);
        if (path == null) {
            return null;
        }
        if (file instanceof RegularFileObject) {
            RegularFileObject r = (RegularFileObject)file;
            String rPath = r.getPath();
            for (File file2 : path) {
                String dPath = file2.getPath();
                if (!dPath.endsWith(File.separator)) {
                    dPath = dPath + File.separator;
                }
                if (!rPath.regionMatches(true, 0, dPath, 0, dPath.length()) || !new File(rPath.substring(0, dPath.length())).equals(new File(dPath))) continue;
                String relativeName = rPath.substring(dPath.length());
                return JavacFileManager.removeExtension(relativeName).replace(File.separatorChar, '.');
            }
        } else {
            if (file instanceof ZipFileObject) {
                ZipFileObject z = (ZipFileObject)file;
                String entryName = z.getZipEntryName();
                if (entryName.startsWith(symbolFilePrefix)) {
                    entryName = entryName.substring(symbolFilePrefix.length());
                }
                return JavacFileManager.removeExtension(entryName).replace('/', '.');
            }
            throw new IllegalArgumentException(file.getClass().getName());
        }
        return null;
    }

    private static String removeExtension(String fileName) {
        int lastDot = fileName.lastIndexOf(".");
        return lastDot == -1 ? fileName : fileName.substring(0, lastDot);
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        JavacFileManager.nullCheck(a);
        JavacFileManager.nullCheck(b);
        if (!(a instanceof BaseFileObject)) {
            throw new IllegalArgumentException("Not supported: " + a);
        }
        if (!(b instanceof BaseFileObject)) {
            throw new IllegalArgumentException("Not supported: " + b);
        }
        return a.equals(b);
    }

    @Override
    public boolean handleOption(String current, Iterator<String> remaining) {
        for (JavacOption o : javacFileManagerOptions) {
            if (!o.matches(current)) continue;
            if (o.hasArg() ? remaining.hasNext() && !o.process(this.options, current, remaining.next()) : !o.process(this.options, current)) {
                return true;
            }
            throw new IllegalArgumentException(current);
        }
        return false;
    }

    @Override
    public int isSupportedOption(String option) {
        for (JavacOption o : javacFileManagerOptions) {
            if (!o.matches(option)) continue;
            return o.hasArg() ? 1 : 0;
        }
        return -1;
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return this.getLocation(location) != null;
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        JavacFileManager.nullCheck(location);
        JavacFileManager.nullCheck(className);
        JavacFileManager.nullCheck(kind);
        if (!this.sourceOrClass.contains((Object)kind)) {
            throw new IllegalArgumentException("Invalid kind " + (Object)((Object)kind));
        }
        return this.getFileForInput(location, JavacFileManager.externalizeFileName(className, kind));
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        JavacFileManager.nullCheck(location);
        JavacFileManager.nullCheck(packageName);
        if (!JavacFileManager.isRelativeUri(URI.create(relativeName))) {
            throw new IllegalArgumentException("Invalid relative name: " + relativeName);
        }
        String name = packageName.length() == 0 ? relativeName : new File(JavacFileManager.externalizeFileName(packageName), relativeName).getPath();
        return this.getFileForInput(location, name);
    }

    private JavaFileObject getFileForInput(JavaFileManager.Location location, String name) throws IOException {
        Iterable<? extends File> path = this.getLocation(location);
        if (path == null) {
            return null;
        }
        for (File file : path) {
            if (file.isDirectory()) {
                File f = new File(file, name.replace('/', File.separatorChar));
                if (!f.exists()) continue;
                return new RegularFileObject(f);
            }
            Archive a = this.openArchive(file);
            if (!a.contains(name)) continue;
            int i = name.lastIndexOf(47);
            String dirname = name.substring(0, i + 1);
            String basename = name.substring(i + 1);
            return a.getFileObject(dirname, basename);
        }
        return null;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        JavacFileManager.nullCheck(location);
        JavacFileManager.nullCheck(className);
        JavacFileManager.nullCheck(kind);
        if (!this.sourceOrClass.contains((Object)kind)) {
            throw new IllegalArgumentException("Invalid kind " + (Object)((Object)kind));
        }
        return this.getFileForOutput(location, JavacFileManager.externalizeFileName(className, kind), sibling);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        JavacFileManager.nullCheck(location);
        JavacFileManager.nullCheck(packageName);
        if (!JavacFileManager.isRelativeUri(URI.create(relativeName))) {
            throw new IllegalArgumentException("relativeName is invalid");
        }
        String name = packageName.length() == 0 ? relativeName : new File(JavacFileManager.externalizeFileName(packageName), relativeName).getPath();
        return this.getFileForOutput(location, name, sibling);
    }

    /*
     * Enabled aggressive block sorting
     */
    private JavaFileObject getFileForOutput(JavaFileManager.Location location, String fileName, FileObject sibling) throws IOException {
        File dir;
        block7: {
            if (location == StandardLocation.CLASS_OUTPUT) {
                if (this.getClassOutDir() != null) {
                    dir = this.getClassOutDir();
                    break block7;
                } else {
                    File siblingDir = null;
                    if (sibling != null && sibling instanceof RegularFileObject) {
                        siblingDir = ((RegularFileObject)sibling).f.getParentFile();
                    }
                    return new RegularFileObject(new File(siblingDir, JavacFileManager.baseName(fileName)));
                }
            }
            if (location == StandardLocation.SOURCE_OUTPUT) {
                dir = this.getSourceOutDir() != null ? this.getSourceOutDir() : this.getClassOutDir();
            } else {
                Paths.Path path = this.paths.getPathForLocation(location);
                dir = null;
                Iterator i$ = path.iterator();
                if (i$.hasNext()) {
                    File f;
                    dir = f = (File)i$.next();
                }
            }
        }
        File file = dir == null ? new File(fileName) : new File(dir, fileName);
        return new RegularFileObject(file);
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromFiles(Iterable<? extends File> files) {
        ArrayList<RegularFileObject> result = files instanceof Collection ? new ArrayList(((Collection)files).size()) : new ArrayList<RegularFileObject>();
        for (File file : files) {
            result.add(new RegularFileObject(JavacFileManager.nullCheck(file)));
        }
        return result;
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(File ... files) {
        return this.getJavaFileObjectsFromFiles(Arrays.asList((Object[])JavacFileManager.nullCheck(files)));
    }

    @Override
    public void setLocation(JavaFileManager.Location location, Iterable<? extends File> path) throws IOException {
        File dir;
        JavacFileManager.nullCheck(location);
        this.paths.lazy();
        File file = dir = location.isOutputLocation() ? this.getOutputDirectory(path) : null;
        if (location == StandardLocation.CLASS_OUTPUT) {
            this.classOutDir = this.getOutputLocation(dir, OptionName.D);
        } else if (location == StandardLocation.SOURCE_OUTPUT) {
            this.sourceOutDir = this.getOutputLocation(dir, OptionName.S);
        } else {
            this.paths.setPathForLocation(location, path);
        }
    }

    private File getOutputDirectory(Iterable<? extends File> path) throws IOException {
        if (path == null) {
            return null;
        }
        Iterator<? extends File> pathIter = path.iterator();
        if (!pathIter.hasNext()) {
            throw new IllegalArgumentException("empty path for directory");
        }
        File dir = pathIter.next();
        if (pathIter.hasNext()) {
            throw new IllegalArgumentException("path too long for directory");
        }
        if (!dir.exists()) {
            throw new FileNotFoundException(dir + ": does not exist");
        }
        if (!dir.isDirectory()) {
            throw new IOException(dir + ": not a directory");
        }
        return dir;
    }

    private File getOutputLocation(File dir, OptionName defaultOptionName) {
        if (dir != null) {
            return dir;
        }
        String arg = this.options.get(defaultOptionName);
        if (arg == null) {
            return null;
        }
        return new File(arg);
    }

    @Override
    public Iterable<? extends File> getLocation(JavaFileManager.Location location) {
        JavacFileManager.nullCheck(location);
        this.paths.lazy();
        if (location == StandardLocation.CLASS_OUTPUT) {
            return this.getClassOutDir() == null ? null : List.of(this.getClassOutDir());
        }
        if (location == StandardLocation.SOURCE_OUTPUT) {
            return this.getSourceOutDir() == null ? null : List.of(this.getSourceOutDir());
        }
        return this.paths.getPathForLocation(location);
    }

    private File getClassOutDir() {
        if (this.classOutDir == this.uninited) {
            this.classOutDir = this.getOutputLocation(null, OptionName.D);
        }
        return this.classOutDir;
    }

    private File getSourceOutDir() {
        if (this.sourceOutDir == this.uninited) {
            this.sourceOutDir = this.getOutputLocation(null, OptionName.S);
        }
        return this.sourceOutDir;
    }

    protected static boolean isRelativeUri(URI uri) {
        if (uri.isAbsolute()) {
            return false;
        }
        String path = uri.normalize().getPath();
        if (path.length() == 0) {
            return false;
        }
        char first = path.charAt(0);
        return first != '.' && first != '/';
    }

    public static String getRelativeName(File file) {
        String result;
        if (!file.isAbsolute() && JavacFileManager.isRelativeUri(URI.create(result = file.getPath().replace(File.separatorChar, '/')))) {
            return result;
        }
        throw new IllegalArgumentException("Invalid relative path: " + file);
    }

    protected static String getJavacFileName(FileObject file) {
        if (file instanceof BaseFileObject) {
            return ((BaseFileObject)file).getPath();
        }
        URI uri = file.toUri();
        String scheme = uri.getScheme();
        if (scheme == null || scheme.equals("file") || scheme.equals("jar")) {
            return uri.getPath();
        }
        return uri.toString();
    }

    protected static String getJavacBaseFileName(FileObject file) {
        if (file instanceof BaseFileObject) {
            return ((BaseFileObject)file).getName();
        }
        URI uri = file.toUri();
        String scheme = uri.getScheme();
        if (scheme == null || scheme.equals("file") || scheme.equals("jar")) {
            String path = uri.getPath();
            if (path == null) {
                return null;
            }
            if (scheme != null && scheme.equals("jar")) {
                path = path.substring(path.lastIndexOf(33) + 1);
            }
            return path.substring(path.lastIndexOf(47) + 1);
        }
        return uri.toString();
    }

    private static <T> T nullCheck(T o) {
        o.getClass();
        return o;
    }

    private static <T> Iterable<T> nullCheck(Iterable<T> it) {
        for (T t : it) {
            t.getClass();
        }
        return it;
    }

    public class ZipFileObject
    extends BaseFileObject {
        private String name;
        ZipFile zdir;
        ZipEntry entry;

        public ZipFileObject(String name, ZipFile zdir, ZipEntry entry) {
            this.name = name;
            this.zdir = zdir;
            this.entry = entry;
        }

        public InputStream openInputStream() throws IOException {
            return this.zdir.getInputStream(this.entry);
        }

        public OutputStream openOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        protected CharsetDecoder getDecoder(boolean ignoreEncodingErrors) {
            return JavacFileManager.this.getDecoder(JavacFileManager.this.getEncodingName(), ignoreEncodingErrors);
        }

        public Writer openWriter() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        public String getName() {
            return this.name;
        }

        public boolean isNameCompatible(String cn, JavaFileObject.Kind k) {
            cn.getClass();
            if (k == JavaFileObject.Kind.OTHER && this.getKind() != k) {
                return false;
            }
            return this.name.equals(cn + k.extension);
        }

        @Deprecated
        public String getPath() {
            return this.zdir.getName() + "(" + this.entry + ")";
        }

        public long getLastModified() {
            return this.entry.getTime();
        }

        public boolean delete() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CharBuffer getCharContent(boolean ignoreEncodingErrors) throws IOException {
            CharBuffer cb;
            SoftReference r = (SoftReference)JavacFileManager.this.contentCache.get(this);
            CharBuffer charBuffer = cb = r == null ? null : (CharBuffer)r.get();
            if (cb == null) {
                InputStream in = this.zdir.getInputStream(this.entry);
                try {
                    ByteBuffer bb = JavacFileManager.this.makeByteBuffer(in);
                    JavaFileObject prev = JavacFileManager.this.log.useSource(this);
                    try {
                        cb = JavacFileManager.this.decode(bb, ignoreEncodingErrors);
                    }
                    finally {
                        JavacFileManager.this.log.useSource(prev);
                    }
                    JavacFileManager.this.byteBufferCache.put(bb);
                    if (!ignoreEncodingErrors) {
                        JavacFileManager.this.contentCache.put(this, new SoftReference<CharBuffer>(cb));
                    }
                }
                finally {
                    in.close();
                }
            }
            return cb;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ZipFileObject)) {
                return false;
            }
            ZipFileObject o = (ZipFileObject)other;
            return this.zdir.equals(o.zdir) || this.name.equals(o.name);
        }

        public int hashCode() {
            return this.zdir.hashCode() + this.name.hashCode();
        }

        public String getZipName() {
            return this.zdir.getName();
        }

        public String getZipEntryName() {
            return this.entry.getName();
        }

        public URI toUri() {
            String zipName = new File(this.getZipName()).toURI().normalize().getPath();
            String entryName = this.getZipEntryName();
            return URI.create("jar:" + zipName + "!" + entryName);
        }
    }

    private class RegularFileObject
    extends BaseFileObject {
        private boolean hasParents = false;
        private String name;
        final File f;

        public RegularFileObject(File f) {
            this(f.getName(), f);
        }

        public RegularFileObject(String name, File f) {
            if (f.isDirectory()) {
                throw new IllegalArgumentException("directories not supported");
            }
            this.name = name;
            this.f = f;
        }

        public InputStream openInputStream() throws IOException {
            return new FileInputStream(this.f);
        }

        protected CharsetDecoder getDecoder(boolean ignoreEncodingErrors) {
            return JavacFileManager.this.getDecoder(JavacFileManager.this.getEncodingName(), ignoreEncodingErrors);
        }

        public OutputStream openOutputStream() throws IOException {
            this.ensureParentDirectoriesExist();
            return new FileOutputStream(this.f);
        }

        public Writer openWriter() throws IOException {
            this.ensureParentDirectoriesExist();
            return new OutputStreamWriter((OutputStream)new FileOutputStream(this.f), JavacFileManager.this.getEncodingName());
        }

        private void ensureParentDirectoriesExist() throws IOException {
            if (!this.hasParents) {
                File parent = this.f.getParentFile();
                if (!(parent == null || parent.exists() || parent.mkdirs() || parent.exists() && parent.isDirectory())) {
                    throw new IOException("could not create parent directories");
                }
                this.hasParents = true;
            }
        }

        @Deprecated
        public String getName() {
            return this.name;
        }

        public boolean isNameCompatible(String cn, JavaFileObject.Kind kind) {
            cn.getClass();
            if (kind == JavaFileObject.Kind.OTHER && this.getKind() != kind) {
                return false;
            }
            String n = cn + kind.extension;
            if (this.name.equals(n)) {
                return true;
            }
            if (this.name.equalsIgnoreCase(n)) {
                try {
                    return this.f.getCanonicalFile().getName().equals(n);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            return false;
        }

        @Deprecated
        public String getPath() {
            return this.f.getPath();
        }

        public long getLastModified() {
            return this.f.lastModified();
        }

        public boolean delete() {
            return this.f.delete();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CharBuffer getCharContent(boolean ignoreEncodingErrors) throws IOException {
            CharBuffer cb;
            SoftReference r = (SoftReference)JavacFileManager.this.contentCache.get(this);
            CharBuffer charBuffer = cb = r == null ? null : (CharBuffer)r.get();
            if (cb == null) {
                FileInputStream in = new FileInputStream(this.f);
                try {
                    ByteBuffer bb = JavacFileManager.this.makeByteBuffer(in);
                    JavaFileObject prev = JavacFileManager.this.log.useSource(this);
                    try {
                        cb = JavacFileManager.this.decode(bb, ignoreEncodingErrors);
                    }
                    finally {
                        JavacFileManager.this.log.useSource(prev);
                    }
                    JavacFileManager.this.byteBufferCache.put(bb);
                    if (!ignoreEncodingErrors) {
                        JavacFileManager.this.contentCache.put(this, new SoftReference<CharBuffer>(cb));
                    }
                }
                finally {
                    ((InputStream)in).close();
                }
            }
            return cb;
        }

        public boolean equals(Object other) {
            if (!(other instanceof RegularFileObject)) {
                return false;
            }
            RegularFileObject o = (RegularFileObject)other;
            try {
                return this.f.equals(o.f) || this.f.getCanonicalFile().equals(o.f.getCanonicalFile());
            }
            catch (IOException e) {
                return false;
            }
        }

        public int hashCode() {
            return this.f.hashCode();
        }

        public URI toUri() {
            try {
                String path = this.f.getAbsolutePath().replace(File.separatorChar, '/');
                return new URI("file://" + path).normalize();
            }
            catch (URISyntaxException ex) {
                return this.f.toURI();
            }
        }
    }

    private static class ByteBufferCache {
        private ByteBuffer cached;

        private ByteBufferCache() {
        }

        ByteBuffer get(int capacity) {
            if (capacity < 20480) {
                capacity = 20480;
            }
            ByteBuffer result = this.cached != null && this.cached.capacity() >= capacity ? (ByteBuffer)this.cached.clear() : ByteBuffer.allocate(capacity + capacity >> 1);
            this.cached = null;
            return result;
        }

        void put(ByteBuffer x) {
            this.cached = x;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MissingArchive
    implements Archive {
        final File zipFileName;

        public MissingArchive(File name) {
            this.zipFileName = name;
        }

        @Override
        public boolean contains(String name) {
            return false;
        }

        @Override
        public void close() {
        }

        @Override
        public JavaFileObject getFileObject(String subdirectory, String file) {
            return null;
        }

        @Override
        public List<String> getFiles(String subdirectory) {
            return List.nil();
        }

        @Override
        public Set<String> getSubdirectories() {
            return Collections.emptySet();
        }
    }

    public class SymbolArchive
    extends ZipArchive {
        final File origFile;

        public SymbolArchive(File orig, ZipFile zdir) throws IOException {
            super(zdir);
            this.origFile = orig;
        }

        void addZipEntry(ZipEntry entry) {
            String name = entry.getName();
            if (!name.startsWith(JavacFileManager.symbolFilePrefix)) {
                return;
            }
            name = name.substring(JavacFileManager.symbolFilePrefix.length());
            int i = name.lastIndexOf(47);
            String dirname = name.substring(0, i + 1);
            String basename = name.substring(i + 1);
            if (basename.length() == 0) {
                return;
            }
            List<String> list = (List<String>)this.map.get(dirname);
            if (list == null) {
                list = List.nil();
            }
            list = list.prepend(basename);
            this.map.put(dirname, list);
        }

        public JavaFileObject getFileObject(String subdirectory, String file) {
            return super.getFileObject(JavacFileManager.symbolFilePrefix + subdirectory, file);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ZipArchive
    implements Archive {
        protected final Map<String, List<String>> map;
        protected final ZipFile zdir;

        public ZipArchive(ZipFile zdir) throws IOException {
            this.zdir = zdir;
            this.map = new HashMap<String, List<String>>();
            Enumeration<? extends ZipEntry> e = zdir.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry;
                try {
                    entry = e.nextElement();
                }
                catch (InternalError ex) {
                    IOException io = new IOException();
                    io.initCause(ex);
                    throw io;
                }
                this.addZipEntry(entry);
            }
        }

        void addZipEntry(ZipEntry entry) {
            String name = entry.getName();
            int i = name.lastIndexOf(47);
            String dirname = name.substring(0, i + 1);
            String basename = name.substring(i + 1);
            if (basename.length() == 0) {
                return;
            }
            List<String> list = this.map.get(dirname);
            if (list == null) {
                list = List.nil();
            }
            list = list.prepend(basename);
            this.map.put(dirname, list);
        }

        @Override
        public boolean contains(String name) {
            int i = name.lastIndexOf(47);
            String dirname = name.substring(0, i + 1);
            String basename = name.substring(i + 1);
            if (basename.length() == 0) {
                return false;
            }
            List<String> list = this.map.get(dirname);
            return list != null && list.contains(basename);
        }

        @Override
        public List<String> getFiles(String subdirectory) {
            return this.map.get(subdirectory);
        }

        @Override
        public JavaFileObject getFileObject(String subdirectory, String file) {
            ZipEntry ze = this.zdir.getEntry(subdirectory + file);
            return new ZipFileObject(file, this.zdir, ze);
        }

        @Override
        public Set<String> getSubdirectories() {
            return this.map.keySet();
        }

        @Override
        public void close() throws IOException {
            this.zdir.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Archive {
        public void close() throws IOException;

        public boolean contains(String var1);

        public JavaFileObject getFileObject(String var1, String var2);

        public List<String> getFiles(String var1);

        public Set<String> getSubdirectories();
    }
}

