/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.api;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.api.JavacScope;
import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.main.CommandLine;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.main.Main;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.model.JavacTypes;
import com.sun.tools.javac.parser.Parser;
import com.sun.tools.javac.parser.Scanner;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.ClientCodeException;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JavacFileManager;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.processing.Processor;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavacTaskImpl
extends JavacTask {
    private JavacTool tool;
    private Main compilerMain;
    private JavaCompiler compiler;
    private String[] args;
    private Context context;
    private List<JavaFileObject> fileObjects;
    private Map<JavaFileObject, JCTree.JCCompilationUnit> notYetEntered;
    private ListBuffer<Env<AttrContext>> genList;
    private TaskListener taskListener;
    private AtomicBoolean used = new AtomicBoolean();
    private Iterable<? extends Processor> processors;
    private Integer result = null;
    private boolean parsed = false;

    JavacTaskImpl(JavacTool tool, Main compilerMain, String[] args, Context context, List<JavaFileObject> fileObjects) {
        this.tool = tool;
        this.compilerMain = compilerMain;
        this.args = args;
        this.context = context;
        this.fileObjects = fileObjects;
        compilerMain.getClass();
        args.getClass();
        context.getClass();
        fileObjects.getClass();
    }

    JavacTaskImpl(JavacTool tool, Main compilerMain, Iterable<String> flags, Context context, Iterable<String> classes, Iterable<? extends JavaFileObject> fileObjects) {
        this(tool, compilerMain, JavacTaskImpl.toArray(flags, classes), context, JavacTaskImpl.toList(fileObjects));
    }

    private static String[] toArray(Iterable<String> flags, Iterable<String> classes) {
        ListBuffer<String> result = new ListBuffer<String>();
        if (flags != null) {
            for (String flag : flags) {
                result.append(flag);
            }
        }
        if (classes != null) {
            for (String cls : classes) {
                result.append(cls);
            }
        }
        return result.toArray(new String[result.length()]);
    }

    private static List<JavaFileObject> toList(Iterable<? extends JavaFileObject> fileObjects) {
        if (fileObjects == null) {
            return List.nil();
        }
        ListBuffer<JavaFileObject> result = new ListBuffer<JavaFileObject>();
        for (JavaFileObject javaFileObject : fileObjects) {
            result.append(javaFileObject);
        }
        return result.toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() {
        if (!this.used.getAndSet(true)) {
            this.beginContext();
            try {
                this.compilerMain.setFatalErrors(true);
                this.result = this.compilerMain.compile(this.args, this.context, this.fileObjects, this.processors);
            }
            finally {
                this.endContext();
            }
            this.compilerMain = null;
            this.args = null;
            this.context = null;
            this.fileObjects = null;
            return this.result == 0;
        }
        throw new IllegalStateException("multiple calls to method 'call'");
    }

    @Override
    public void setProcessors(Iterable<? extends Processor> processors) {
        processors.getClass();
        if (this.used.get()) {
            throw new IllegalStateException();
        }
        this.processors = processors;
    }

    @Override
    public void setLocale(Locale locale) {
        if (this.used.get()) {
            throw new IllegalStateException();
        }
    }

    private void prepareCompiler() throws IOException {
        if (!this.used.getAndSet(true)) {
            this.beginContext();
            Options options = Options.instance(this.context);
            this.compilerMain.setOptions(options);
            this.compilerMain.filenames = new ListBuffer();
            List<File> filenames = this.compilerMain.processArgs(CommandLine.parse(this.args));
            if (!filenames.isEmpty()) {
                throw new IllegalArgumentException("Malformed arguments " + filenames.toString(" "));
            }
            this.compiler = JavaCompiler.instance(this.context);
            this.compiler.initProcessAnnotations(this.processors);
            this.notYetEntered = new HashMap<JavaFileObject, JCTree.JCCompilationUnit>();
            this.compiler.initNotYetEntered(this.notYetEntered);
            for (JavaFileObject file : this.fileObjects) {
                this.notYetEntered.put(file, null);
            }
            this.genList = new ListBuffer();
            this.args = null;
        }
    }

    private void beginContext() {
        this.context.put(JavacTaskImpl.class, this);
        if (this.context.get(TaskListener.class) != null) {
            this.context.put(TaskListener.class, (TaskListener)null);
        }
        if (this.taskListener != null) {
            this.context.put(TaskListener.class, this.wrap(this.taskListener));
        }
        this.tool.beginContext(this.context);
    }

    private TaskListener wrap(final TaskListener tl) {
        tl.getClass();
        return new TaskListener(){

            public void started(TaskEvent e) {
                try {
                    tl.started(e);
                }
                catch (Throwable t) {
                    throw new ClientCodeException(t);
                }
            }

            public void finished(TaskEvent e) {
                try {
                    tl.finished(e);
                }
                catch (Throwable t) {
                    throw new ClientCodeException(t);
                }
            }
        };
    }

    private void endContext() {
        this.tool.endContext();
    }

    public JavaFileObject asJavaFileObject(File file) {
        JavacFileManager fm = (JavacFileManager)this.context.get(JavaFileManager.class);
        return fm.getRegularFile(file);
    }

    @Override
    public void setTaskListener(TaskListener taskListener) {
        this.taskListener = taskListener;
    }

    /*
     * WARNING - void declaration
     */
    public Iterable<? extends CompilationUnitTree> parse(JavaFileObject ... files) throws IOException {
        void var5_7;
        this.prepareCompiler();
        LinkedList<CompilationUnitTree> trees = new LinkedList<CompilationUnitTree>();
        this.fileObjects = List.nil();
        JavaFileObject[] arr$ = files;
        int len$ = arr$.length;
        boolean bl = false;
        while (var5_7 < len$) {
            JavaFileObject file = arr$[var5_7];
            CompilationUnitTree tree = this.getTreeForFile(file);
            if (tree != null) {
                trees.add(tree);
            } else {
                this.fileObjects = this.fileObjects.append(file);
                if (this.notYetEntered != null) {
                    assert (!this.notYetEntered.containsKey(file));
                    this.notYetEntered.put(file, null);
                }
            }
            ++var5_7;
        }
        if (!this.fileObjects.isEmpty()) {
            Iterable<? extends CompilationUnitTree> newTrees = this.parse();
            for (CompilationUnitTree compilationUnitTree : newTrees) {
                trees.add(compilationUnitTree);
            }
        }
        return trees;
    }

    private CompilationUnitTree getTreeForFile(JavaFileObject file) {
        assert (file != null);
        Enter enter = Enter.instance(this.context);
        JCTree.JCCompilationUnit tree = enter.getCompilationUnit(file);
        return tree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<? extends CompilationUnitTree> parse() throws IOException {
        try {
            this.prepareCompiler();
            List<JCTree.JCCompilationUnit> units = this.compiler.parseFiles(this.fileObjects);
            for (JCTree.JCCompilationUnit unit : units) {
                JavaFileObject file = unit.getSourceFile();
                if (!this.notYetEntered.containsKey(file)) continue;
                this.notYetEntered.put(file, unit);
            }
            List<JCTree.JCCompilationUnit> list = units;
            return list;
        }
        finally {
            this.parsed = true;
            if (this.compiler != null && this.compiler.log != null) {
                this.compiler.log.flush();
            }
        }
    }

    public Iterable<? extends TypeElement> enter() throws IOException {
        return this.enter(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<? extends TypeElement> enter(Iterable<? extends CompilationUnitTree> trees) throws IOException {
        this.prepareCompiler();
        ListBuffer<JCTree.JCCompilationUnit> roots = null;
        if (trees == null) {
            if (this.notYetEntered.size() > 0) {
                if (!this.parsed) {
                    this.parse();
                }
                for (JavaFileObject javaFileObject : this.fileObjects) {
                    JCTree.JCCompilationUnit unit = this.notYetEntered.remove(javaFileObject);
                    if (unit == null) continue;
                    if (roots == null) {
                        roots = new ListBuffer();
                    }
                    roots.append(unit);
                }
                this.notYetEntered.clear();
            }
        } else {
            for (CompilationUnitTree compilationUnitTree : trees) {
                if (compilationUnitTree instanceof JCTree.JCCompilationUnit) {
                    if (roots == null) {
                        roots = new ListBuffer<JCTree.JCCompilationUnit>();
                    }
                    roots.append((JCTree.JCCompilationUnit)compilationUnitTree);
                    this.notYetEntered.remove(compilationUnitTree.getSourceFile());
                    continue;
                }
                throw new IllegalArgumentException(compilationUnitTree.toString());
            }
        }
        if (roots == null) {
            return List.nil();
        }
        try {
            List<JCTree.JCCompilationUnit> units = this.compiler.enterTrees(roots.toList());
            if (this.notYetEntered.isEmpty()) {
                this.compiler = this.compiler.processAnnotations(units);
            }
            ListBuffer<Symbol.ClassSymbol> listBuffer = new ListBuffer<Symbol.ClassSymbol>();
            for (JCTree.JCCompilationUnit unit : units) {
                for (JCTree node : unit.defs) {
                    if (node.getTag() != 3) continue;
                    listBuffer.append(((JCTree.JCClassDecl)node).sym);
                }
            }
            List list = listBuffer.toList();
            return list;
        }
        finally {
            this.compiler.log.flush();
        }
    }

    public Iterable<? extends TypeElement> enterTrees(Iterable<? extends CompilationUnitTree> trees) throws IOException {
        ArrayList<CompilationUnitTree> toEnter = new ArrayList<CompilationUnitTree>();
        ArrayList<TypeElement> result = new ArrayList<TypeElement>();
        for (CompilationUnitTree compilationUnitTree : trees) {
            Collection<TypeElement> collection = this.getEnteredElement(compilationUnitTree);
            if (collection.isEmpty()) {
                toEnter.add(compilationUnitTree);
                continue;
            }
            result.addAll(collection);
        }
        if (!toEnter.isEmpty()) {
            Iterable<? extends TypeElement> classes = this.enter(toEnter);
            for (TypeElement typeElement : classes) {
                result.add(typeElement);
            }
        }
        return result;
    }

    private Collection<TypeElement> getEnteredElement(CompilationUnitTree tree) {
        assert (tree != null);
        List todo = this.compiler.todo.toList();
        ArrayList<TypeElement> result = new ArrayList<TypeElement>();
        for (Env env : todo) {
            if (!env.toplevel.getSourceFile().toUri().equals(((JCTree.JCCompilationUnit)tree).getSourceFile().toUri())) continue;
            this.notYetEntered.remove(((JCTree.JCCompilationUnit)tree).getSourceFile());
            result.add(((JCTree.JCClassDecl)env.tree).sym);
        }
        return result;
    }

    @Override
    public Iterable<? extends Element> analyze() throws IOException {
        return this.analyze(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<? extends Element> analyze(Iterable<? extends TypeElement> classes) throws IOException {
        this.enter(null);
        final ListBuffer<Element> results = new ListBuffer<Element>();
        try {
            if (classes == null) {
                this.handleFlowResults(this.compiler.flow(this.compiler.attribute(this.compiler.todo)), results);
            } else {
                Filter f = new Filter(){

                    @Override
                    public void process(Env<AttrContext> env) {
                        JavacTaskImpl.this.handleFlowResults(JavacTaskImpl.this.compiler.flow(JavacTaskImpl.this.compiler.attribute(env)), results);
                    }
                };
                f.run(this.compiler.todo, classes);
            }
        }
        finally {
            this.compiler.log.flush();
        }
        return results;
    }

    private void handleFlowResults(List<Env<AttrContext>> list, ListBuffer<Element> elems) {
        for (Env<AttrContext> env : list) {
            switch (env.tree.getTag()) {
                case 3: {
                    JCTree.JCClassDecl cdef = (JCTree.JCClassDecl)env.tree;
                    if (cdef.sym == null) break;
                    elems.append(cdef.sym);
                    break;
                }
                case 1: {
                    JCTree.JCCompilationUnit unit = (JCTree.JCCompilationUnit)env.tree;
                    if (unit.packge == null) break;
                    elems.append(unit.packge);
                }
            }
        }
        this.genList.appendList(list);
    }

    @Override
    public Iterable<? extends JavaFileObject> generate() throws IOException {
        return this.generate(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<? extends JavaFileObject> generate(Iterable<? extends TypeElement> classes) throws IOException {
        final ListBuffer<JavaFileObject> results = new ListBuffer<JavaFileObject>();
        try {
            this.analyze(null);
            if (classes == null) {
                this.compiler.generate(this.compiler.desugar(this.genList.toList()), results);
                this.genList.clear();
            } else {
                Filter f = new Filter(){

                    @Override
                    public void process(Env<AttrContext> env) {
                        JavacTaskImpl.this.compiler.generate(JavacTaskImpl.this.compiler.desugar(List.of(env)), results);
                    }
                };
                f.run(this.genList, classes);
            }
            if (this.genList.isEmpty()) {
                this.compiler.reportDeferredDiagnostics();
                this.compiler.log.flush();
                this.endContext();
            }
        }
        finally {
            this.compiler.log.flush();
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateTypeElements(Iterable<? extends TypeElement> classes) throws IOException {
        assert (classes != null);
        try {
            this.analyze(classes);
            Filter f = new Filter(){

                @Override
                public void process(Env<AttrContext> env) {
                    JavacTaskImpl.this.compiler.generate(JavacTaskImpl.this.compiler.desugar(List.of(env)));
                }
            };
            f.run(this.genList, classes);
        }
        finally {
            this.compiler.log.flush();
        }
    }

    public void finish() {
        if (this.notYetEntered != null && !this.notYetEntered.isEmpty()) {
            this.notYetEntered.clear();
        }
        if (this.compiler != null && this.compiler.todo != null && !this.compiler.todo.isEmpty()) {
            this.compiler.todo.clear();
        }
        if (this.genList != null && !this.genList.isEmpty()) {
            assert (this.genList.size() == 1);
            this.genList.clear();
        }
        this.endContext();
    }

    @Override
    public TypeMirror getTypeMirror(Iterable<? extends Tree> path) {
        Tree last = null;
        Iterator<? extends Tree> i$ = path.iterator();
        while (i$.hasNext()) {
            Tree node;
            last = node = i$.next();
        }
        return ((JCTree)last).type;
    }

    @Override
    public JavacElements getElements() {
        if (this.context == null) {
            throw new IllegalStateException();
        }
        return JavacElements.instance(this.context);
    }

    @Override
    public JavacTypes getTypes() {
        if (this.context == null) {
            throw new IllegalStateException();
        }
        return JavacTypes.instance(this.context);
    }

    public Iterable<? extends Tree> pathFor(CompilationUnitTree unit, Tree node) {
        return TreeInfo.pathFor((JCTree)node, (JCTree.JCCompilationUnit)unit).reverse();
    }

    public Context getContext() {
        return this.context;
    }

    public void updateContext(Context newContext) {
        this.context = newContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type parseType(String expr, TypeElement scope) {
        if (expr == null || expr.equals("")) {
            throw new IllegalArgumentException();
        }
        this.compiler = JavaCompiler.instance(this.context);
        JavaFileObject prev = this.compiler.log.useSource(null);
        Scanner.Factory scannerFactory = Scanner.Factory.instance(this.context);
        Parser.Factory parserFactory = Parser.Factory.instance(this.context);
        Attr attr = Attr.instance(this.context);
        try {
            Scanner scanner = scannerFactory.newScanner((expr + "\u0000").toCharArray(), expr.length());
            Parser parser = parserFactory.newParser(scanner, false, false, true);
            JCTree.JCExpression tree = parser.type();
            Type type = attr.attribType((JCTree)tree, (Symbol.TypeSymbol)((Object)scope));
            return type;
        }
        finally {
            this.compiler.log.useSource(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCTree.JCStatement parseStatement(CharSequence stmt, SourcePositions[] pos) {
        if (stmt == null || pos != null && pos.length != 1) {
            throw new IllegalArgumentException();
        }
        this.compiler = JavaCompiler.instance(this.context);
        JavaFileObject prev = this.compiler.log.useSource(null);
        Scanner.Factory scannerFactory = Scanner.Factory.instance(this.context);
        Parser.Factory parserFactory = Parser.Factory.instance(this.context);
        try {
            Scanner scanner = scannerFactory.newScanner(stmt);
            Parser parser = parserFactory.newParser(scanner, false, true, true);
            if (pos != null) {
                pos[0] = new ParserSourcePositions(parser);
            }
            JCTree.JCStatement jCStatement = parser.statement();
            return jCStatement;
        }
        finally {
            this.compiler.log.useSource(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCTree.JCExpression parseExpression(CharSequence expr, SourcePositions[] pos) {
        if (expr == null || pos != null && pos.length != 1) {
            throw new IllegalArgumentException();
        }
        this.compiler = JavaCompiler.instance(this.context);
        JavaFileObject prev = this.compiler.log.useSource(null);
        Scanner.Factory scannerFactory = Scanner.Factory.instance(this.context);
        Parser.Factory parserFactory = Parser.Factory.instance(this.context);
        try {
            Scanner scanner = scannerFactory.newScanner(expr);
            Parser parser = parserFactory.newParser(scanner, false, true, true);
            if (pos != null) {
                pos[0] = new ParserSourcePositions(parser);
            }
            JCTree.JCExpression jCExpression = parser.expression();
            return jCExpression;
        }
        finally {
            this.compiler.log.useSource(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCTree.JCExpression parseVariableInitializer(CharSequence init, SourcePositions[] pos) {
        if (init == null || pos != null && pos.length != 1) {
            throw new IllegalArgumentException();
        }
        this.compiler = JavaCompiler.instance(this.context);
        JavaFileObject prev = this.compiler.log.useSource(null);
        Scanner.Factory scannerFactory = Scanner.Factory.instance(this.context);
        Parser.Factory parserFactory = Parser.Factory.instance(this.context);
        try {
            Scanner scanner = scannerFactory.newScanner(init);
            Parser parser = parserFactory.newParser(scanner, false, true, true);
            if (pos != null) {
                pos[0] = new ParserSourcePositions(parser);
            }
            JCTree.JCExpression jCExpression = parser.variableInitializer();
            return jCExpression;
        }
        finally {
            this.compiler.log.useSource(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCTree.JCBlock parseStaticBlock(CharSequence block, SourcePositions[] pos) {
        if (block == null || pos != null && pos.length != 1) {
            throw new IllegalArgumentException();
        }
        this.compiler = JavaCompiler.instance(this.context);
        JavaFileObject prev = this.compiler.log.useSource(null);
        Scanner.Factory scannerFactory = Scanner.Factory.instance(this.context);
        Parser.Factory parserFactory = Parser.Factory.instance(this.context);
        try {
            Scanner scanner = scannerFactory.newScanner(block);
            Parser parser = parserFactory.newParser(scanner, false, true, true);
            if (pos != null) {
                pos[0] = new ParserSourcePositions(parser);
            }
            List<JCTree> trees = parser.classOrInterfaceBodyDeclaration(null, false);
            JCTree.JCBlock jCBlock = trees.head != null && ((JCTree)trees.head).getTag() == 7 ? (JCTree.JCBlock)trees.head : null;
            return jCBlock;
        }
        finally {
            this.compiler.log.useSource(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type attributeTree(JCTree tree, Env<AttrContext> env) {
        Log log = Log.instance(this.context);
        Attr attr = Attr.instance(this.context);
        JavaFileObject prev = log.useSource(null);
        try {
            if (tree instanceof JCTree.JCExpression) {
                Type type = attr.attribExpr(tree, env, Type.noType);
                return type;
            }
            Type type = attr.attribStat(tree, env);
            return type;
        }
        finally {
            log.useSource(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavacScope attributeTreeTo(JCTree tree, Env<AttrContext> env, JCTree to) {
        Log log = Log.instance(this.context);
        Attr attr = Attr.instance(this.context);
        JavaFileObject prev = log.useSource(null);
        try {
            Env<AttrContext> ret = tree instanceof JCTree.JCExpression ? attr.attribExprToTree(tree, env, to) : attr.attribStatToTree(tree, env, to);
            JavacScope javacScope = new JavacScope(ret);
            return javacScope;
        }
        finally {
            log.useSource(prev);
        }
    }

    public String dumpTodo() {
        StringBuilder result = new StringBuilder();
        if (this.compiler != null && this.compiler.todo != null) {
            for (Env env : this.compiler.todo.toList()) {
                result.append(((JCTree.JCClassDecl)env.tree).sym.toString() + " from: " + env.toplevel.sourcefile.toUri());
            }
        }
        return result.toString();
    }

    public java.util.List<Env<AttrContext>> getTodo() {
        if (this.compiler != null && this.compiler.todo != null) {
            return new ArrayList<Env<AttrContext>>(this.compiler.todo.toList());
        }
        return Collections.emptyList();
    }

    private class ParserSourcePositions
    implements SourcePositions {
        private Parser parser;

        private ParserSourcePositions(Parser parser) {
            this.parser = parser;
        }

        public long getStartPosition(CompilationUnitTree file, Tree tree) {
            return this.parser.getStartPos((JCTree)tree);
        }

        public long getEndPosition(CompilationUnitTree file, Tree tree) {
            return this.parser.getEndPos((JCTree)tree);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Filter {
        /*
         * WARNING - void declaration
         */
        public void run(ListBuffer<Env<AttrContext>> list, Iterable<? extends TypeElement> classes) {
            void var5_9;
            HashSet<TypeElement> set = new HashSet<TypeElement>();
            for (TypeElement typeElement : classes) {
                set.add(typeElement);
            }
            List<Env<AttrContext>> defer = List.nil();
            while (list.nonEmpty()) {
                Env<AttrContext> env = list.next();
                Symbol.ClassSymbol csym = env.enclClass.sym;
                if (csym != null && set.contains(csym.outermostClass())) {
                    this.process(env);
                    continue;
                }
                defer = defer.prepend(env);
            }
            List<Env<AttrContext>> list2 = defer;
            while (var5_9.nonEmpty()) {
                list.prepend((Env<AttrContext>)var5_9.head);
                List list3 = var5_9.tail;
            }
        }

        public abstract void process(Env<AttrContext> var1);
    }
}

