/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy.properties;

import java.util.Hashtable;
import org.netbeans.modules.visualweb.gravy.properties.PropertyReader;
import org.netbeans.modules.visualweb.gravy.properties.PropertyReaderWriter;
import org.netbeans.modules.visualweb.gravy.properties.PropertySheetReaderWriter;

public class PropertyFactory {
    private PropertyReaderWriter debugrw = null;
    private String elementName;
    private PropertyReader[] preaders = null;
    private PropertyReaderWriter[] pwriters = null;
    private Hashtable prhash = new Hashtable();
    private Hashtable prwhash = new Hashtable();

    public PropertyFactory(String elementName) {
        this.elementName = elementName;
        this.initialize();
    }

    protected void initialize() {
        int i;
        this.preaders = new PropertyReader[1];
        this.pwriters = new PropertyReaderWriter[1];
        this.pwriters[0] = new PropertySheetReaderWriter();
        this.preaders[0] = this.pwriters[0];
        for (i = 0; i < this.getReadersNum(); ++i) {
            this.prhash.put(this.preaders[i].getName(), this.preaders[i]);
        }
        for (i = 0; i < this.getWritersNum(); ++i) {
            this.prwhash.put(this.pwriters[i].getName(), this.pwriters[i]);
        }
    }

    public int getReadersNum() {
        return this.preaders == null ? 0 : this.preaders.length;
    }

    public int getWritersNum() {
        return this.pwriters == null ? 0 : this.pwriters.length;
    }

    public void setValue(int writer, String name, Object value) {
        if (writer < 0 || writer >= this.getWritersNum()) {
            throw new ArrayIndexOutOfBoundsException(writer);
        }
        this.pwriters[writer].setPropertyValue(name, value);
        if (this.debugrw != null) {
            this.debugrw.setPropertyValue(name, value);
        }
    }

    public Object getValue(int reader, String name) {
        if (reader < 0 || reader >= this.getReadersNum()) {
            throw new ArrayIndexOutOfBoundsException(reader);
        }
        if (this.debugrw != null) {
            this.debugrw.getPropertyValue(name);
        }
        return this.preaders[reader].getPropertyValue(name);
    }

    public void setValue(String writer, String name, Object value) {
        if (!this.prwhash.containsKey(writer)) {
            throw new IllegalArgumentException("There is no PropertyReaderWriter with name " + writer);
        }
        ((PropertyReaderWriter)this.prwhash.get(writer)).setPropertyValue(name, value);
        if (this.debugrw != null) {
            this.debugrw.setPropertyValue(name, value);
        }
    }

    public Object getValue(String reader, String name) {
        if (!this.prhash.containsKey(reader)) {
            throw new IllegalArgumentException("There is no PropertyReader with name " + reader);
        }
        if (this.debugrw != null) {
            this.debugrw.getPropertyValue(name);
        }
        return ((PropertyReader)this.prhash.get(reader)).getPropertyValue(name);
    }
}

