/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy.model.project;

import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JLabelOperator;
import org.netbeans.modules.visualweb.gravy.Bundle;
import org.netbeans.modules.visualweb.gravy.ProjectNavigatorOperator;
import org.netbeans.modules.visualweb.gravy.TestUtils;
import org.netbeans.modules.visualweb.gravy.Util;
import org.netbeans.modules.visualweb.gravy.model.navigation.LinkManager;
import org.netbeans.modules.visualweb.gravy.model.project.ProjectDescriptor;
import org.netbeans.modules.visualweb.gravy.model.project.RootEntry;

public abstract class Project {
    private static final String bundle = "org.netbeans.modules.visualweb.gravy.model.project.Bundle";
    private static final String popupClose = Bundle.getStringTrimmed(Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.model.project.Bundle", "NBProjectsBundle"), Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.model.project.Bundle", "CloseProjectPopupItem"));
    private static final String popupRun = Bundle.getStringTrimmed(Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.model.project.Bundle", "WebProjectsBundle"), Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.model.project.Bundle", "RunProjectPopupItem"));
    private static final String STR_NO_VIEW = "<No View Available>";
    private static final String STR_MAIN = " [Main]";
    private ProjectDescriptor prjDescriptor;
    protected RootEntry root;
    private LinkManager linkMng;

    public Project(ProjectDescriptor prjDescriptor) {
        this.setDescriptor(prjDescriptor);
        this.root = new RootEntry(this);
    }

    public RootEntry getRoot() {
        return this.root;
    }

    public LinkManager getLinkManager() {
        if (this.linkMng == null) {
            this.linkMng = new LinkManager(this);
            return this.linkMng;
        }
        return this.linkMng;
    }

    public void rename(String newProjectName) {
        String name = this.prjDescriptor.getProperty("projectName");
        if (!name.equals(newProjectName)) {
            this.setName(newProjectName);
        }
    }

    public void close() {
        try {
            new ProjectNavigatorOperator();
            ProjectNavigatorOperator.pressPopupItemOnNode(this.getName(), popupClose);
        }
        catch (Exception e) {
            throw new JemmyException("Project can't be closed!", (Throwable)e);
        }
    }

    public void run() {
        try {
            new ProjectNavigatorOperator();
            ProjectNavigatorOperator.pressPopupItemOnNode(this.getName(), popupRun);
            TestUtils.wait(2000);
            String[] runFinished = new String[]{this.getName() + STR_MAIN, STR_NO_VIEW, ""};
            this.waitLabelString(1, runFinished);
        }
        catch (Exception e) {
            throw new JemmyException("Project can't be run!", (Throwable)e);
        }
        TestUtils.wait(3000);
    }

    private void waitLabelString(int index, String compareString) {
        String[] compareStrings = new String[]{compareString};
        this.waitLabelString(index, compareStrings);
    }

    private void waitLabelString(int index, String[] compareStrings) {
        JLabelOperator jlo = new JLabelOperator((ContainerOperator)Util.getMainWindow(), index);
        boolean isStringAppeared = false;
        block0: do {
            jlo = new JLabelOperator((ContainerOperator)Util.getMainWindow(), index);
            TestUtils.wait(1000);
            String labelText = jlo.getText();
            for (int i = 0; i < compareStrings.length; ++i) {
                if (labelText == null || !labelText.equals(compareStrings[i])) continue;
                isStringAppeared = true;
                continue block0;
            }
        } while (!isStringAppeared);
    }

    private void waitLabelStringDisappear(int index, String compareString) {
        JLabelOperator jlo = new JLabelOperator((ContainerOperator)Util.getMainWindow(), index);
        while (jlo.getText() == null || !jlo.getText().equals(compareString)) {
            jlo = new JLabelOperator((ContainerOperator)Util.getMainWindow(), index);
            TestUtils.wait(1000);
        }
        while (jlo.getText() != null && jlo.getText().equals(compareString)) {
            jlo = new JLabelOperator((ContainerOperator)Util.getMainWindow(), index);
            TestUtils.wait(1000);
        }
    }

    public void saveAll() {
    }

    public ProjectDescriptor getDescriptor() {
        return this.prjDescriptor;
    }

    private void setDescriptor(ProjectDescriptor prjDescriptor) {
        this.prjDescriptor = prjDescriptor;
    }

    public String getName() {
        return this.prjDescriptor.getProperty("projectName");
    }

    private void setName(String name) {
        String location = this.prjDescriptor.getProperty("projectLocation");
        this.prjDescriptor = new ProjectDescriptor(name, location);
    }

    public String getLocation() {
        return this.prjDescriptor.getProperty("projectLocation");
    }

    private void setLocation(String location) {
        String name = this.prjDescriptor.getProperty("projectName");
        this.prjDescriptor = new ProjectDescriptor(name, location);
    }

    public abstract Project saveAs(String var1);

    public abstract Project saveAs(String var1, String var2);
}

