/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy;

import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebResponse;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.nio.charset.MalformedInputException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import javax.swing.tree.TreePath;
import org.netbeans.core.windows.view.ui.tabcontrol.TabbedAdapter;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.NewProjectWizardOperator;
import org.netbeans.jellytools.OutputOperator;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Timeout;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.drivers.input.MouseRobotDriver;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JCheckBoxOperator;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JLabelOperator;
import org.netbeans.jemmy.operators.JListOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.JRadioButtonOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.modules.visualweb.gravy.OptionsOperator;
import org.netbeans.modules.visualweb.gravy.PageTopComponentOperator;
import org.netbeans.modules.visualweb.gravy.ProjectNavigatorOperator;
import org.netbeans.modules.visualweb.gravy.StatusWaitable;
import org.netbeans.modules.visualweb.gravy.Util;
import org.netbeans.modules.visualweb.gravy.actions.CloseProjectAction;
import org.netbeans.modules.visualweb.gravy.debugger.BuildOutputOperator;
import org.netbeans.modules.visualweb.gravy.designer.DesignerPaneOperator;
import org.netbeans.modules.visualweb.gravy.properties.Property;
import org.netbeans.modules.visualweb.gravy.properties.PropertySheetOperator;
import org.netbeans.modules.visualweb.gravy.properties.PropertySheetTabOperator;
import org.netbeans.modules.visualweb.gravy.properties.SheetTableOperator;
import org.netbeans.modules.visualweb.gravy.welcome.WelcomeOperator;
import org.openide.windows.TopComponent;

public class TestUtils {
    public static final String KEY_STRING_AFTER_PRJ_NAME_J2EE = "src";
    public static final String KEY_STRING_AFTER_PRJ_NAME_JSF = "web";
    private static final String SAVE_DIALOG_TITLE = "Save";
    private static final String SAVE_ALL = "Save All";
    private static final String CLOSE_PROJECT = "Close";
    private static String delim = "|";
    private static String fSep = System.getProperty("file.separator");
    private static String pathLastCreatedProject;
    private static final String CREATOR_SYSTEM_DIR;
    private static final String CREATOR_INSTALL_PROPERTIES_FILE_NAME = "com-sun-rave-install.properties";
    private static final String HTTP_PROTOCOL = "http";
    private static final String WEB_PORT_PROPERTY_NAME = "webPort";
    private static final String ADMIN_PORT_PROPERTY_NAME = "adminPort";
    private static final String LOCALHOST = "localhost";

    public static void createNewProject(String projectName) {
        TestUtils.createNewProjectAbsoluteLocation(null, projectName);
    }

    public static void createNewProjectTimeStamped(String projectName) {
        TestUtils.createNewProject(projectName + "_" + TestUtils.getCurrentDateAndTimeAsString());
    }

    public static void createNewProjectLocation(String location, String projectName) {
        TestUtils.createNewProjectLoc(location, projectName, false);
    }

    public static void createNewProjectAbsoluteLocation(String location, String projectName) {
        TestUtils.createNewProjectLoc(location, projectName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createNewPortletProjectLoc(String location, String projectName, boolean absoluteLocation, String projectCategory, String projectType) {
        NewProjectWizardOperator po = NewProjectWizardOperator.invoke();
        Waiter projectListWaiter = new Waiter(new Waitable(){

            public Object actionProduced(Object po) {
                JList projList = (JList)((ContainerOperator)po).findSubComponent((ComponentChooser)new JListOperator.JListFinder(), 1);
                JListOperator projListOper = new JListOperator(projList);
                projListOper.copyEnvironment((Operator)((ComponentOperator)po));
                if (projListOper.findItemIndex("Application") == -1 && projListOper.findItemIndex("Travel") == -1) {
                    return null;
                }
                return "";
            }

            public String getDescription() {
                return "Project list to be displayed";
            }
        });
        TestUtils.wait(1000);
        po.selectCategory(projectCategory);
        projectListWaiter.getTimeouts().setTimeout("Waiter.WaitingTime", 180000L);
        try {
            projectListWaiter.waitAction((Object)po);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        po.selectProject(projectType);
        TestUtils.wait(1000);
        po.next();
        TestUtils.wait(2000);
        if (projectName != null) {
            new JTextFieldOperator((ContainerOperator)po).setText(projectName);
        } else {
            projectName = new JTextFieldOperator((ContainerOperator)po).getText();
        }
        if (location != null) {
            if (!absoluteLocation) {
                location = new JTextFieldOperator((ContainerOperator)po, 1).getText() + "/" + location;
            }
            new JTextFieldOperator((ContainerOperator)po, 1).setText(location);
        } else {
            location = new JTextFieldOperator((ContainerOperator)po, 1).getText();
        }
        pathLastCreatedProject = location;
        TestUtils.wait(1000);
        po.next();
        TestUtils.wait(2000);
        po.finish();
        String timeoutName = "DialogWaiter.WaitDialogTimeout";
        long timeoutValue = JemmyProperties.getCurrentTimeout((String)timeoutName);
        JemmyProperties.getCurrentTimeouts().setTimeout(timeoutName, 8000L);
        try {
            new JButtonOperator((ContainerOperator)new JDialogOperator("Question"), "Yes").pushNoBlock();
        }
        catch (Exception e) {
        }
        finally {
            JemmyProperties.getCurrentTimeouts().setTimeout(timeoutName, timeoutValue);
        }
        Util.getMainWindow().getTimeouts().setTimeout("ComponentOperator.WaitComponentTimeout", 60000L);
        TestUtils.disableBrowser(projectName, location, true);
        return projectName;
    }

    @Deprecated
    public static String createNewJSFProject() {
        return TestUtils.createNewJSFProject(null);
    }

    @Deprecated
    public static String createNewJSFProject(String projectName) {
        return TestUtils.createNewProjectLoc(null, projectName, true, "Web", "Web Application");
    }

    public static String createNewProjectLoc(String location, String projectName, boolean absoluteLocation, String projectCategory, String projectType) {
        projectName = TestUtils.createNewProject(location, projectName, absoluteLocation, projectCategory, projectType, null, "J2EE 1.4");
        return projectName;
    }

    public static String createJavaEE5ProjectLoc(String location, String projectName, boolean absoluteLocation, String projectCategory, String projectType) {
        projectName = TestUtils.createNewProject(location, projectName, absoluteLocation, projectCategory, projectType, null, "Java EE 5");
        return projectName;
    }

    public static String createNewProject(String location, String projectName, boolean absoluteLocation, String projectCategory, String projectType, String sourceStructure, String J2EELevel) {
        projectName = TestUtils.createNewProject(location, projectName, absoluteLocation, projectCategory, projectType, sourceStructure, J2EELevel, null);
        return projectName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createNewProject(String location, String projectName, boolean absoluteLocation, String projectCategory, String projectType, String sourceStructure, String J2EELevel, String server) {
        new Operator.DefaultStringComparator(true, true);
        NewProjectWizardOperator po = NewProjectWizardOperator.invoke();
        Waiter projectListWaiter = new Waiter(new Waitable(){

            public Object actionProduced(Object po) {
                JList projList = (JList)((ContainerOperator)po).findSubComponent((ComponentChooser)new JListOperator.JListFinder(), 1);
                JListOperator projListOper = new JListOperator(projList);
                projListOper.copyEnvironment((Operator)((ComponentOperator)po));
                if (projListOper.findItemIndex("Application") == -1 && projListOper.findItemIndex("Travel") == -1) {
                    return null;
                }
                return "";
            }

            public String getDescription() {
                return "Project list to be displayed";
            }
        });
        TestUtils.wait(1000);
        po.selectCategory(projectCategory);
        projectListWaiter.getTimeouts().setTimeout("Waiter.WaitingTime", 180000L);
        try {
            projectListWaiter.waitAction((Object)po);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Operator.StringComparator comparator = po.getComparator();
        Operator.DefaultStringComparator stringComparator = new Operator.DefaultStringComparator(true, true);
        po.setComparator((Operator.StringComparator)stringComparator);
        TestUtils.wait(1000);
        po.selectProject(projectType);
        TestUtils.wait(2000);
        po.setComparator(comparator);
        TestUtils.wait(1000);
        po.next();
        TestUtils.wait(2000);
        if (projectName != null) {
            new JTextFieldOperator((ContainerOperator)po).setText(projectName);
        } else {
            projectName = new JTextFieldOperator((ContainerOperator)po).getText();
        }
        if (location != null) {
            if (!absoluteLocation) {
                location = new JTextFieldOperator((ContainerOperator)po, 1).getText() + "/" + location;
            }
            new JTextFieldOperator((ContainerOperator)po, 1).setText(location);
        } else {
            location = new JTextFieldOperator((ContainerOperator)po, 1).getText();
        }
        pathLastCreatedProject = location;
        TestUtils.wait(1000);
        if (server != null) {
            new JComboBoxOperator((ContainerOperator)po, 1).selectItem(server);
        }
        TestUtils.wait(1000);
        if (J2EELevel != null) {
            new JComboBoxOperator((ContainerOperator)po, 2).selectItem(J2EELevel);
        }
        TestUtils.wait(1000);
        if (new JButtonOperator((ContainerOperator)po, "Next").isEnabled()) {
            po.next();
            TestUtils.wait(1000);
            po.pushKey(40);
            TestUtils.wait(2000);
            po.pushKey(32);
            TestUtils.wait(2000);
        }
        po.finish();
        String timeoutName = "DialogWaiter.WaitDialogTimeout";
        long timeoutValue = JemmyProperties.getCurrentTimeout((String)timeoutName);
        JemmyProperties.getCurrentTimeouts().setTimeout(timeoutName, 10000L);
        Waiter waitProjectPropertiesDialog = new Waiter(new Waitable(){

            public Object actionProduced(Object obj) {
                try {
                    new JButtonOperator((ContainerOperator)new JDialogOperator("Edit Project Properties"), "Regenerate").push();
                    return null;
                }
                catch (TimeoutExpiredException e) {
                    return true;
                }
            }

            public String getDescription() {
                return "Wait all dialogs";
            }
        });
        waitProjectPropertiesDialog.getTimeouts().setTimeout("Waiter.WaitingTime", 60000L);
        try {
            waitProjectPropertiesDialog.waitAction(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            JemmyProperties.getCurrentTimeouts().setTimeout(timeoutName, timeoutValue);
        }
        TestUtils.disableBrowser(projectName, location, true);
        Waiter projectCreationWaiter = new Waiter(new Waitable(){

            public Object actionProduced(Object po) {
                try {
                    PageTopComponentOperator page;
                    int i = 0;
                    while (((String)(page = new PageTopComponentOperator("Page1", i++)).getDump().get("Tooltip text")).indexOf(TestUtils.KEY_STRING_AFTER_PRJ_NAME_JSF + File.separator + "Page1.jsp") == -1) {
                    }
                    new DesignerPaneOperator((ContainerOperator)page);
                    return "";
                }
                catch (TimeoutExpiredException e) {
                    return null;
                }
            }

            public String getDescription() {
                return "Project list to be displayed";
            }
        });
        TestUtils.wait(1000);
        projectCreationWaiter.getTimeouts().setTimeout("Waiter.WaitingTime", 600000L);
        System.out.println("TRACE: Start waiting: " + TestUtils.getCurrentDateAndTimeAsString());
        try {
            projectCreationWaiter.waitAction(null);
        }
        catch (Exception e) {
            throw new JemmyException("Exception when waiting Page1 opened", (Throwable)e);
        }
        System.out.println("TRACE: Stop waiting: " + TestUtils.getCurrentDateAndTimeAsString());
        return projectName;
    }

    public static String getPathLastCreatedProject() {
        return pathLastCreatedProject;
    }

    public static void openProject(String projectPath, boolean welcomeOperator) {
        if (welcomeOperator) {
            WelcomeOperator.getWelcomeButton(Bundle.getStringTrimmed((String)"com.sun.rave.welcome.Bundle", (String)"LBL_OpenProject")).pushNoBlock();
        } else {
            Util.getMainMenu().pushMenuNoBlock(Bundle.getStringTrimmed((String)"org.netbeans.core.Bundle", (String)"Menu/File") + "|" + Bundle.getStringTrimmed((String)"com.sun.rave.project.actions.Bundle", (String)"LBL_OpenProjectAction"));
        }
        Util.wait(3000);
        new JTextFieldOperator((ContainerOperator)new JDialogOperator(Bundle.getStringTrimmed((String)"org.netbeans.modules.project.ui.Bundle", (String)"LBL_PrjChooser_Title")), 1).typeText(projectPath);
        new JButtonOperator((ContainerOperator)new JDialogOperator(Bundle.getStringTrimmed((String)"org.netbeans.modules.project.ui.Bundle", (String)"LBL_PrjChooser_Title")), Bundle.getStringTrimmed((String)"org.netbeans.modules.project.ui.Bundle", (String)"BTN_PrjChooser_ApproveButtonText")).push();
        Util.wait(3000);
    }

    public static void openProject(String projectPath) {
        Util.getMainMenu().pushMenuNoBlock(Bundle.getStringTrimmed((String)"org.netbeans.core.Bundle", (String)"Menu/File") + "|" + "Open Project");
        Util.wait(3000);
        JDialogOperator openPrjDialog = new JDialogOperator("Open Project");
        new JTextFieldOperator((ContainerOperator)openPrjDialog, 1).setText(projectPath);
        new JButtonOperator((ContainerOperator)openPrjDialog, "Open Project").push();
        Util.wait(3000);
    }

    public static void openWebFormJavaFile(String projectName) {
        Util.getMainMenu().pushMenu(Bundle.getStringTrimmed((String)"org.netbeans.core.Bundle", (String)"Menu/View") + delim + Bundle.getStringTrimmed((String)"org.netbeans.core.Bundle", (String)"Projects"));
        JTreeOperator tree = new JTreeOperator((ContainerOperator)new ProjectNavigatorOperator());
        String path = projectName + "|Java Sources|" + projectName.toLowerCase() + "|Page1.java";
        TreePath treePath = tree.findPath(path, "|");
        new JPopupMenuOperator(tree.callPopupOnPath(treePath)).pushMenu("Open");
    }

    public static void closeCurrentProject() {
        try {
            Util.getMainMenu().pushMenu(Bundle.getStringTrimmed((String)"org.netbeans.core.Bundle", (String)"Menu/File") + delim + CLOSE_PROJECT);
        }
        catch (TimeoutExpiredException e) {
            System.out.println("Can't close current project. May be project doesn't exist");
            e.printStackTrace();
        }
    }

    public static void closeCurrentProjectSaveAll() {
        try {
            try {
                new CloseProjectAction().perform();
            }
            catch (TimeoutExpiredException e) {
                // empty catch block
            }
            JDialogOperator saveAll = new JDialogOperator(SAVE_DIALOG_TITLE);
            new JButtonOperator((ContainerOperator)saveAll, SAVE_ALL).pushNoBlock();
        }
        catch (TimeoutExpiredException e) {
            System.out.println("Can't close current project. May be project doesn't exist");
            e.printStackTrace();
        }
    }

    public static void closeProject(String prjName) {
        try {
            try {
                Util.getMainMenu().pushMenu(Bundle.getStringTrimmed((String)"org.netbeans.core.Bundle", (String)"Menu/File") + delim + CLOSE_PROJECT + " \"" + prjName + "\"");
            }
            catch (TimeoutExpiredException e) {
                // empty catch block
            }
            JDialogOperator saveAll = new JDialogOperator(SAVE_DIALOG_TITLE);
            new JButtonOperator((ContainerOperator)saveAll, SAVE_ALL).pushNoBlock();
        }
        catch (TimeoutExpiredException e) {
            System.out.println("Can't close current project. May be project doesn't exist");
            e.printStackTrace();
        }
    }

    public static void closeProjectByName(String prjName) {
        try {
            new ProjectNavigatorOperator();
            ProjectNavigatorOperator pno = ProjectNavigatorOperator.switchToProjects();
            ProjectNavigatorOperator.pressPopupItemOnNode(prjName, CLOSE_PROJECT);
        }
        catch (TimeoutExpiredException e) {
            throw new RuntimeException("Failed to close project", e);
        }
        JDialogOperator saveAll = null;
        try {
            saveAll = new JDialogOperator(SAVE_DIALOG_TITLE);
            new JButtonOperator((ContainerOperator)saveAll, SAVE_ALL).pushNoBlock();
        }
        catch (TimeoutExpiredException e) {
            if (saveAll == null) {
                System.out.println("No Save Dialog is shown");
            }
            System.out.println("Failed to save all");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isProjectOpened(String prjName) {
        ProjectNavigatorOperator pno = null;
        try {
            new ProjectNavigatorOperator();
            pno = ProjectNavigatorOperator.switchToProjects();
            JTreeOperator jto = pno.tree();
            Timeouts timeouts = jto.getTimeouts().cloneThis();
            jto.getTimeouts().setTimeout("JTreeOperator.WaitNextNodeTimeout", 3000L);
            try {
                jto.findPath(prjName);
            }
            finally {
                jto.setTimeouts(timeouts);
            }
        }
        catch (TimeoutExpiredException e) {
            if (pno == null) {
                throw new RuntimeException("Failed to open Project Navigator", e);
            }
            return false;
        }
        return true;
    }

    public static void closeProjectSaveAll(String prjName) {
        try {
            try {
                new CloseProjectAction().perform();
            }
            catch (TimeoutExpiredException e) {
                // empty catch block
            }
            JDialogOperator saveAll = new JDialogOperator(SAVE_DIALOG_TITLE);
            new JButtonOperator((ContainerOperator)saveAll, SAVE_ALL).push();
        }
        catch (TimeoutExpiredException e) {
            System.out.println("Can't close current project. May be project doesn't exist");
            e.printStackTrace();
        }
    }

    public static void closeProjectAfterSaveAll(String prjName) {
        try {
            Util.getMainMenu().pushMenu(Bundle.getStringTrimmed((String)"org.netbeans.core.Bundle", (String)"Menu/File") + delim + SAVE_ALL);
            Util.getMainMenu().pushMenu(Bundle.getStringTrimmed((String)"org.netbeans.core.Bundle", (String)"Menu/File") + delim + CLOSE_PROJECT + " \"" + prjName + "\"");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void pushPopupMenuItemOnMainDesignerTab(DesignerPaneOperator designerOperator, String menuItem) {
        TestUtils.clickMainDesignerTabForPopup(designerOperator);
        JPopupMenuOperator popupMenu = new JPopupMenuOperator();
        Util.wait(1000);
        popupMenu.setComparator((Operator.StringComparator)new Operator.DefaultStringComparator(false, false));
        popupMenu.pushMenu(menuItem);
        Util.wait(2000);
    }

    public static void createNewProjectLoc(String location, String projectName, boolean absoluteLocation) {
        TestUtils.createNewProjectLoc(location, projectName, absoluteLocation, "Web", "Visual Web Application");
    }

    private static void clickMainDesignerTabForPopup(DesignerPaneOperator designerOperator) {
        TabbedAdapter tabbedAdapter = TestUtils.getTabbedAdapter((ContainerOperator)designerOperator);
        int selectedIndex = tabbedAdapter.getSelectionModel().getSelectedIndex();
        Rectangle tabRect = tabbedAdapter.getTabBounds(selectedIndex);
        int clickX = tabRect.x + tabRect.width / 2;
        int clickY = tabRect.y + tabRect.height / 2;
        ComponentOperator componentOperator = new ComponentOperator((Component)tabbedAdapter);
        MouseRobotDriver mouseDriver = new MouseRobotDriver(new Timeout("", 300L));
        mouseDriver.clickMouse(componentOperator, clickX, clickY, 1, 4, 0, new Timeout("", 10L));
        Util.wait(1000);
    }

    public static String getCurrentProjectName() {
        return TestUtils.getCurrentProjectName(KEY_STRING_AFTER_PRJ_NAME_JSF);
    }

    public static String getCurrentProjectName(String keyStringAfterPrjName) {
        DesignerPaneOperator designerOperator = new DesignerPaneOperator();
        TopComponent topComponent = TestUtils.getSelectedTopComponent(designerOperator);
        String toolTip = topComponent.getToolTipText();
        System.out.println();
        System.out.println("+++ TopComconent's tooltip = [" + toolTip + "]");
        String prjName = toolTip.replace(File.separatorChar, '/');
        int substrIndex = prjName.lastIndexOf("/" + keyStringAfterPrjName);
        prjName = prjName.substring(0, substrIndex);
        substrIndex = prjName.lastIndexOf("/");
        prjName = prjName.substring(substrIndex + 1);
        System.out.println("+++ Current project name = " + prjName);
        System.out.println();
        return prjName;
    }

    public static boolean isMainTabOfDesignerSelected(DesignerPaneOperator designerOperator, String tabTitle) {
        TopComponent topComponent = TestUtils.getSelectedTopComponent(designerOperator);
        String name = TestUtils.getTopComponentName(topComponent).trim();
        System.out.println("+++ Tab Title = [" + tabTitle + "]");
        System.out.println("+++ TopComconent name = [" + name + "]");
        System.out.println();
        return name.equals(tabTitle.trim());
    }

    private static TabbedAdapter getTabbedAdapter(ContainerOperator containerOperator) {
        if (containerOperator == null) {
            return null;
        }
        for (Container container = containerOperator.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof TabbedAdapter)) continue;
            System.out.println();
            System.out.println("+++ Tabbed Adapter found = " + container);
            System.out.println();
            return (TabbedAdapter)container;
        }
        return null;
    }

    public static TopComponent[] getTabTopComponents(ContainerOperator containerOperator) {
        TabbedAdapter tabbedAdapter = TestUtils.getTabbedAdapter(containerOperator);
        if (tabbedAdapter == null) {
            return null;
        }
        TopComponent[] topComponents = tabbedAdapter.getTopComponents();
        return topComponents;
    }

    public static TopComponent getTabSelectedTopComponent(ContainerOperator containerOperator) {
        TabbedAdapter tabbedAdapter = TestUtils.getTabbedAdapter(containerOperator);
        if (tabbedAdapter == null) {
            return null;
        }
        int selectedIndex = tabbedAdapter.getSelectionModel().getSelectedIndex();
        TopComponent topComponent = tabbedAdapter.getSelectedTopComponent();
        return topComponent;
    }

    private static TopComponent getSelectedTopComponent(DesignerPaneOperator designerOperator) {
        TopComponent topComponent = TestUtils.getTabSelectedTopComponent((ContainerOperator)designerOperator);
        System.out.println();
        System.out.println("+++ TopComconent found = " + topComponent);
        System.out.println();
        return topComponent;
    }

    public static String getTopComponentName(TopComponent topComponent) {
        String name = topComponent.getDisplayName();
        if (name == null || name.length() < 1) {
            name = topComponent.getName();
        }
        return name;
    }

    public static boolean checkProjectBuilded() {
        BuildOutputOperator console = new BuildOutputOperator();
        return console.getTextOutput().indexOf("BUILD SUCCESSFUL") != -1;
    }

    public static void wait(int millisec) {
        Util.wait(millisec);
    }

    public static void waitStatusText(String line) {
        String[] variants = new String[]{line};
        StatusWaitable csw = new StatusWaitable(variants, false);
        String result = TestUtils.waitStatus(csw);
        if (result != null) {
            System.out.println("Error while waiting status text: " + result);
        }
    }

    public static String waitStatus(StatusWaitable csw) {
        Waiter w = new Waiter((Waitable)csw);
        try {
            w.waitAction((Object)csw);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return "Exception while waiting status text:" + e;
        }
        catch (TimeoutExpiredException e1) {
            e1.printStackTrace();
            return "Exception while waiting status text:" + (Object)((Object)e1);
        }
        return null;
    }

    public static void waitDeployed(OutputOperator output, int maxTimeout) throws InterruptedException {
        Waiter deploymentWaiter = new Waiter(new Waitable(){

            public Object actionProduced(Object output) {
                String text = ((OutputOperator)output).getText();
                if (text.indexOf("BUILD FAILED") != -1) {
                    throw new RuntimeException(new InterruptedException("BUILD FAILED String found in Output Window"));
                }
                if (text.indexOf("BUILD SUCCESSFUL") != -1) {
                    return "true";
                }
                return null;
            }

            public String getDescription() {
                return "Waiting Project Deployed";
            }
        });
        deploymentWaiter.getTimeouts().setTimeout("Waiter.WaitingTime", (long)maxTimeout);
        deploymentWaiter.waitAction((Object)output);
        output.close();
    }

    public static Point getComponentCoords() {
        PropertySheetOperator pso = new PropertySheetOperator((ContainerOperator)Util.getMainWindow());
        PropertySheetTabOperator psto = new PropertySheetTabOperator((ContainerOperator)pso);
        psto.setComparator((Operator.StringComparator)new Operator.DefaultStringComparator(true, true));
        Property pr = new Property((ContainerOperator)psto, "style");
        String propValue = pr.getValue();
        int xLoc = new Integer(propValue.substring(propValue.indexOf("left: ") + 6, propValue.indexOf("px", propValue.indexOf("left: "))));
        int yLoc = new Integer(propValue.substring(propValue.indexOf("top: ") + 5, propValue.indexOf("px", propValue.indexOf("top: "))));
        return new Point(xLoc, yLoc);
    }

    public static String getCurrentDateAndTimeAsString() {
        return new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
    }

    public static void exportWAR(String projectName, String pathToWAR, boolean platform) {
        ProjectNavigatorOperator.pressPopupItemOnNode(projectName, "Export WAR File");
        TestUtils.wait(2000);
        JDialogOperator newWF = new JDialogOperator("Export WAR");
        new JTextFieldOperator((ContainerOperator)newWF, 0).setText(pathToWAR + fSep + projectName + ".war");
        TestUtils.wait(1000);
        new JRadioButtonOperator((ContainerOperator)newWF, platform ? 0 : 1).setSelected(true);
        TestUtils.wait(1000);
        new JButtonOperator((ContainerOperator)newWF, "OK").pushNoBlock();
        newWF.waitClosed();
        TestUtils.wait(2000);
        long oldWaitTime = Util.getMainWindow().getTimeouts().getTimeout("DialogWaiter.WaitDialogTimeout");
        try {
            Util.getMainWindow().getTimeouts().setTimeout("DialogWaiter.WaitDialogTimeout", 5000L);
            JDialogOperator owdo = new JDialogOperator("Question");
            new JButtonOperator((ContainerOperator)owdo, "Yes").pushNoBlock();
            Util.getMainWindow().getTimeouts().setTimeout("DialogWaiter.WaitDialogTimeout", oldWaitTime);
        }
        catch (Exception e) {
            Util.getMainWindow().getTimeouts().setTimeout("DialogWaiter.WaitDialogTimeout", oldWaitTime);
        }
        System.out.println("WAR File exported in " + pathToWAR + fSep + projectName + ".war");
        while (new JLabelOperator((ContainerOperator)Util.getMainWindow(), 0).getText().indexOf("Finished") == -1 && new JLabelOperator((ContainerOperator)Util.getMainWindow(), 0).getText().indexOf("(export.war)") == -1) {
        }
        TestUtils.wait(2000);
    }

    public static void exportWAR(String projectName, String pathToWAR) {
        TestUtils.exportWAR(projectName, pathToWAR, true);
    }

    public static void printComponentList(ComponentOperator op) {
        Component cmp = op.getSource();
        if (cmp instanceof Container) {
            TestUtils.printComponentList((Container)cmp);
        } else {
            System.out.println("Not a container");
        }
    }

    public static void printComponentList(Container container) {
        TestUtils.printComponentList(container, 0);
    }

    private static void printComponentList(Container container, int tabCount) {
        TestUtils.printComponentList(System.out, container, tabCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printComponentList(String fileName, Container container) {
        PrintStream printOut = null;
        try {
            printOut = new PrintStream(new FileOutputStream(fileName, true));
            TestUtils.printComponentList(printOut, container, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                printOut.flush();
                printOut.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void printComponentList(PrintStream out, Container container, int tabCount) {
        Component[] components = container.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            out.println();
            out.println();
            for (int j = 0; j < tabCount; ++j) {
                out.print("\t");
            }
            out.print("+++ COMPONENT = " + component);
            out.println();
            if (!(component instanceof Container)) continue;
            TestUtils.printComponentList(out, (Container)component, tabCount + 1);
        }
    }

    public static URL getJ2EEApplicationURL(String projectName) {
        String webPort = TestUtils.getWebPortFromProperties();
        String unsensitiveProjectName = projectName.toLowerCase();
        try {
            return new URL(HTTP_PROTOCOL, LOCALHOST, Integer.parseInt(webPort), File.separator + unsensitiveProjectName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getWebPortFromProperties() {
        Properties installProperties = TestUtils.getCreatorInstallProperties();
        return installProperties == null ? null : installProperties.getProperty(WEB_PORT_PROPERTY_NAME);
    }

    public static String getAdminPortFromProperties() {
        Properties installProperties = TestUtils.getCreatorInstallProperties();
        return installProperties == null ? null : installProperties.getProperty(ADMIN_PORT_PROPERTY_NAME);
    }

    public static Properties getCreatorInstallProperties() {
        String installPropertiesFileName = System.getProperty("netbeans.home") + File.separator + ".." + File.separator + CREATOR_SYSTEM_DIR + File.separator + CREATOR_INSTALL_PROPERTIES_FILE_NAME;
        try {
            Properties installProperties = new Properties();
            installProperties.load(new FileInputStream(installPropertiesFileName));
            return installProperties;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void outMsg(String msg) {
        TestUtils.outMsg(msg, true, true);
    }

    public static void outMsg(String msg, boolean spaceBefore, boolean spaceAfter) {
        TestUtils.outMsg(System.out, msg, spaceBefore, spaceAfter);
    }

    public static void outMsg(String fileName, String msg) {
        TestUtils.outMsg(fileName, msg, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void outMsg(String fileName, String msg, boolean spaceBefore, boolean spaceAfter) {
        PrintStream printOut = null;
        try {
            printOut = new PrintStream(new FileOutputStream(fileName, true));
            TestUtils.outMsg(printOut, msg, spaceBefore, spaceAfter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                printOut.flush();
                printOut.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void outMsg(PrintStream out, String msg, boolean spaceBefore, boolean spaceAfter) {
        if (spaceBefore) {
            out.println();
        }
        out.println(msg);
        if (spaceAfter) {
            out.println();
        }
    }

    public static boolean isServerStarted() {
        String adminPort = "24848";
        System.out.println("adminPort = " + adminPort);
        return TestUtils.isServerStarted(LOCALHOST, adminPort);
    }

    public static boolean isServerStarted(String host, String port) {
        return TestUtils.isServerStarted(host, port, null, null);
    }

    public static boolean isServerStarted(String host, String port, String userName, String userPassword) {
        try {
            WebConversation conversation = new WebConversation();
            HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)false);
            HttpUnitOptions.setExceptionsThrownOnScriptError((boolean)false);
            if (userName != null && userPassword != null) {
                conversation.setAuthorization(userName, userPassword);
            }
            String url = "http://" + host + ":" + port;
            try {
                WebResponse response = conversation.getResponse(url);
            }
            catch (EOFException e) {
                TestUtils.outMsg("+++ Method [isServerStarted(...)]: an exception [" + e + "] after attempt to receive a response " + "from server [" + url + "]");
                e.printStackTrace();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.out.println("Exception in HTTP check : " + t);
            return false;
        }
        return true;
    }

    public static String getRequestPrefix(long timeout) {
        Waiter waiter = new Waiter(new Waitable(){

            public Object actionProduced(Object p) {
                String _requestPrefix = "";
                _requestPrefix = System.getProperty("test.netbeans.j2eeserver.clienturl");
                if (_requestPrefix != null && _requestPrefix.length() > 0) {
                    return _requestPrefix;
                }
                return null;
            }

            public String getDescription() {
                return "URL to be set";
            }
        });
        waiter.getTimeouts().setTimeout("Waiter.WaitingTime", timeout);
        try {
            return (String)waiter.waitAction(null);
        }
        catch (InterruptedException e) {
            return "";
        }
    }

    public static void disableBrowser(String prjName, boolean dis) {
        ProjectNavigatorOperator.pressPopupItemOnNode(prjName, "Properties");
        JDialogOperator propertiesDialog = new JDialogOperator("Project Properties - " + prjName);
        TestUtils.wait(1000);
        JTreeOperator tree = new JTreeOperator((ContainerOperator)propertiesDialog);
        tree.selectPath(tree.findPath("Run"));
        TestUtils.wait(2000);
        JCheckBoxOperator checkBox = new JCheckBoxOperator((ContainerOperator)propertiesDialog);
        checkBox.setSelected(!dis);
        TestUtils.wait(1000);
        new JButtonOperator((ContainerOperator)propertiesDialog, "OK").pushNoBlock();
        TestUtils.wait(1000);
    }

    public static void disableBrowser(String prjName, String prjLoc, boolean dis) {
        final String propFileStr = prjLoc + File.separator + prjName + File.separator + "nbproject" + File.separator + "project.properties";
        FileInputStream propIn = null;
        Waiter propertyFileWaiter = new Waiter(new Waitable(){

            public Object actionProduced(Object path) {
                File file = new File((String)path);
                if (file.exists()) {
                    return file;
                }
                return null;
            }

            public String getDescription() {
                return "\"" + propFileStr + "\" property file to be created";
            }
        });
        propertyFileWaiter.getTimeouts().setTimeout("Waiter.WaitingTime", 20000L);
        File propFile = null;
        try {
            propFile = (File)propertyFileWaiter.waitAction((Object)propFileStr);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        TestUtils.wait(1000);
        try {
            Properties prop = new Properties();
            TestUtils.wait(1000);
            propIn = new FileInputStream(propFile);
            TestUtils.wait(1000);
            prop.load(propIn);
            Boolean newVal = new Boolean(!dis);
            prop.setProperty("display.browser", newVal.toString());
            prop.store(new FileOutputStream(propFileStr), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Exception occured " + e);
        }
    }

    public static JMenuItem findPopupMenuItemByLabel(JPopupMenuOperator menuOperator, String menuItemLabel) {
        return TestUtils.findPopupMenuItemByLabel(menuOperator, menuItemLabel, true, false);
    }

    public static JMenuItem findPopupMenuItemByLabel(JPopupMenuOperator menuOperator, String menuItemLabel, boolean equalsMode, boolean ignoreCaseMode) {
        String labelText = ignoreCaseMode ? menuItemLabel.toUpperCase() : menuItemLabel;
        MenuElement[] menuItems = menuOperator.getSubElements();
        for (int i = 0; i < menuItems.length; ++i) {
            String menuItemText;
            JMenuItem menuItem = (JMenuItem)menuItems[i];
            String string = menuItemText = ignoreCaseMode ? menuItem.getText().toUpperCase() : menuItem.getText();
            if (!(equalsMode ? menuItemText.equals(labelText) : menuItemText.indexOf(labelText) > -1)) continue;
            return menuItem;
        }
        return null;
    }

    public static void downloadFile(String destinationUrl, String srcFile) throws MalformedInputException, IOException {
        int data;
        URL url = new URL(destinationUrl);
        InputStream in = url.openStream();
        BufferedInputStream bufIn = new BufferedInputStream(in);
        FileOutputStream outStr = new FileOutputStream(srcFile);
        while ((data = bufIn.read()) != -1) {
            ((OutputStream)outStr).write(data);
        }
        ((OutputStream)outStr).close();
    }

    public static String unzip(String file) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        System.out.println("Extracting from: " + zipFile.getName());
        String firstEntry = zipFile.entries().nextElement().getName();
        System.out.println("FIRST ENTRY = " + firstEntry);
        String startDir = firstEntry;
        if (firstEntry.indexOf(47) != -1) {
            startDir = firstEntry.substring(0, firstEntry.indexOf(47));
            System.out.println("dir = " + startDir);
            new File(startDir).mkdir();
        }
        String projectName = startDir;
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) {
                System.out.println("Extracting directory: " + entry.getName());
                new File(entry.getName()).mkdir();
                continue;
            }
            System.out.println("Extracting file: " + entry.getName());
            TestUtils.copyInputStream(zipFile.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(entry.getName())));
        }
        zipFile.close();
        return projectName;
    }

    protected static final void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }

    public static String parseLogs(String pathToFile, String strToFind) throws IOException {
        String lineSep = System.getProperty("line.separator");
        BufferedReader br = new BufferedReader(new FileReader(pathToFile));
        String nextLine = "";
        StringBuffer sb = new StringBuffer();
        while ((nextLine = br.readLine()) != null) {
            if (nextLine.indexOf(strToFind) == -1) continue;
            sb.append(nextLine);
            sb.append(lineSep);
        }
        return sb.toString();
    }

    public static void setHTTPProxy(String proxyHost, String proxyPort) {
        OptionsOperator opOper = OptionsOperator.invoke();
        opOper.selectOption("General Settings|System Settings");
        SheetTableOperator props = new SheetTableOperator((ContainerOperator)opOper);
        props.setComboBoxValue("Type of proxy configuration", "Use HTTP Proxy");
        props.setTextValue("Proxy Host", proxyHost);
        props.setTextValue("Proxy Port", proxyPort);
        opOper.close();
    }

    static {
        CREATOR_SYSTEM_DIR = "visualweb1" + File.separator + "config";
    }
}

