/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy;

import com.sun.rave.designtime.DesignBean;
import java.awt.Component;
import java.util.Arrays;
import javax.swing.tree.TreePath;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.modules.visualweb.gravy.Bundle;
import org.netbeans.modules.visualweb.gravy.TestUtils;

public class DocumentOutlineOperator
extends JComponentOperator {
    private JTreeOperator structureTree;

    public DocumentOutlineOperator(ContainerOperator contOper) {
        super(contOper, (ComponentChooser)new DocumentOutlineChooser());
    }

    public void verify() {
        this.getStructTreeOperator();
    }

    public TreePath findPath(String strTreePath) {
        this.verify();
        return this.structureTree.findPath(strTreePath);
    }

    public TreePath findPath(String strTreePath, int[] nodeIndexes, Operator.StringComparator comparator) {
        this.verify();
        String[] nodeNames = new Operator.DefaultPathParser("|").parse(strTreePath);
        if (nodeIndexes == null) {
            nodeIndexes = new int[nodeNames.length];
        }
        System.out.println("+++ DocumentOutlineOperator.findPath(...): nodeNames = " + Arrays.asList(nodeNames));
        System.out.print("+++ DocumentOutlineOperator.findPath(...): nodeIndexes = [");
        for (int i = 0; i < nodeIndexes.length; ++i) {
            System.out.print(nodeIndexes[i] + (i < nodeIndexes.length - 1 ? ", " : ""));
        }
        System.out.println("]");
        TreePath treePath = this.structureTree.findPath(nodeNames, nodeIndexes, comparator);
        return treePath;
    }

    public void clickOnPath(String strTreePath) {
        this.structureTree.clickOnPath(this.findPath(strTreePath));
    }

    public void expandPath(String strTreePath) {
        this.structureTree.expandPath(this.findPath(strTreePath));
    }

    public void selectPath(String strTreePath) {
        this.structureTree.selectPath(this.findPath(strTreePath));
    }

    public void clickForPopup(int i) {
        this.verify();
        this.structureTree.clickForPopup(i);
    }

    public JTreeOperator getStructTreeOperator() {
        if (this.structureTree == null) {
            this.structureTree = new JTreeOperator((ContainerOperator)this);
        }
        return this.structureTree;
    }

    public void pressButton(String btName) {
        new JButtonOperator((ContainerOperator)this, btName).pushNoBlock();
    }

    private DesignBean findChild(DesignBean parent, String componentName) {
        if (parent.getInstanceName().equals(componentName)) {
            return parent;
        }
        for (int i = 0; i < parent.getChildBeanCount(); ++i) {
            DesignBean lb = this.findChild(parent.getChildBean(i), componentName);
            if (lb == null) continue;
            return lb;
        }
        return null;
    }

    public boolean selectComponent(String componentName) {
        DesignBean[] lbs = null;
        Object rootChild = this.structureTree.getChildren(this.structureTree.getRoot())[0];
        for (int i = 0; i < this.structureTree.getChildCount(rootChild); ++i) {
            DesignBean lb = (DesignBean)this.structureTree.getChildren(rootChild)[i];
            DesignBean res = this.findChild(lb, componentName);
            if (res == null) continue;
            lbs = new DesignBean[]{res};
            break;
        }
        if (lbs != null) {
            TestUtils.wait(500);
            return true;
        }
        return false;
    }

    public void openPage(String page) {
        new JButtonOperator((ContainerOperator)this, page).clickForPopup();
        new JPopupMenuOperator().pushMenu(Bundle.getStringTrimmed("org.netbeans.modules.visualweb.outline.Bundle", "Open"));
    }

    public void openPageSource(String page) {
        new JButtonOperator((ContainerOperator)this, page).clickForPopup();
        new JPopupMenuOperator().pushMenu(Bundle.getStringTrimmed("org.netbeans.modules.visualweb.outline.Bundle", "ViewBF", new String[]{page}));
    }

    public static class DocumentOutlineChooser
    implements ComponentChooser {
        public boolean checkComponent(Component comp) {
            return comp.getClass().getName().equalsIgnoreCase("org.netbeans.modules.visualweb.outline.OutlinePanel");
        }

        public String getDescription() {
            return "Document Outline Operator";
        }
    }
}

