/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.workflow.model.utl;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Messages {
    private static final String DEFAULT_BUNDLE_NAME = "messages.Bundle";
    private String mBundleName;
    private ResourceBundle mResourceBundle;

    private Messages(Class clazz, Locale locale) {
        this.mBundleName = Messages.getBundleName(clazz);
        this.mResourceBundle = ResourceBundle.getBundle(this.mBundleName, locale, clazz.getClassLoader());
    }

    private static String getPackageName(Class clazz) {
        Package packageObj = clazz.getPackage();
        if (packageObj != null) {
            return packageObj.getName();
        }
        String fullClassName = clazz.getName();
        int lastIndex = fullClassName.lastIndexOf(".");
        if (lastIndex > 0) {
            return fullClassName.substring(0, lastIndex);
        }
        return "";
    }

    public static Messages getMessages(Class clazz) throws MissingResourceException {
        return new Messages(clazz, Locale.getDefault());
    }

    public static Messages getMessages(Class clazz, Locale locale) throws MissingResourceException {
        return new Messages(clazz, locale);
    }

    public static String getBundleName(Class clazz) throws MissingResourceException {
        String packageName = Messages.getPackageName(clazz);
        String bundleName = DEFAULT_BUNDLE_NAME;
        if (!packageName.equals("")) {
            bundleName = packageName + "." + DEFAULT_BUNDLE_NAME;
        }
        return bundleName;
    }

    public ResourceBundle getBundle() {
        return this.mResourceBundle;
    }

    public String getBundleName() {
        return this.mBundleName;
    }

    public String getString(String key) {
        try {
            return this.mResourceBundle.getString(key);
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }

    public String getString(String key, Object arg) {
        return this.getString(key, new Object[]{arg});
    }

    public String getString(String key, Object[] args) {
        String result = null;
        String rawValue = this.getString(key);
        try {
            result = MessageFormat.format(rawValue, args);
        }
        catch (IllegalArgumentException e) {
            result = rawValue;
        }
        return result;
    }
}

