/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.layout.graph;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import prefuse.action.layout.graph.TreeLayout;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Schema;
import prefuse.data.tuple.TupleSet;
import prefuse.util.ArrayLib;
import prefuse.visual.NodeItem;

public class RadialTreeLayout
extends TreeLayout {
    public static final int DEFAULT_RADIUS = 50;
    private static final int MARGIN = 30;
    protected int m_maxDepth = 0;
    protected double m_radiusInc = 50.0;
    protected double m_theta1 = 0.0;
    protected double m_theta2 = this.m_theta1 + Math.PI * 2;
    protected boolean m_setTheta = false;
    protected boolean m_autoScale = true;
    protected Point2D m_origin;
    protected NodeItem m_prevRoot = null;
    public static final String PARAMS = "_radialTreeLayoutParams";
    public static final Schema PARAMS_SCHEMA = new Schema();

    public RadialTreeLayout(String group) {
        super(group);
    }

    public RadialTreeLayout(String group, int radius) {
        this(group);
        this.m_radiusInc = radius;
        this.m_autoScale = false;
    }

    public double getRadiusIncrement() {
        return this.m_radiusInc;
    }

    public void setRadiusIncrement(double inc) {
        this.m_radiusInc = inc;
    }

    public boolean getAutoScale() {
        return this.m_autoScale;
    }

    public void setAutoScale(boolean s) {
        this.m_autoScale = s;
    }

    public void setAngularBounds(double theta, double width) {
        this.m_theta1 = theta;
        this.m_theta2 = theta + width;
        this.m_setTheta = true;
    }

    public void run(double frac) {
        Graph g = (Graph)this.m_vis.getGroup(this.m_group);
        this.initSchema(g.getNodes());
        this.m_origin = this.getLayoutAnchor();
        NodeItem n = this.getLayoutRoot();
        Params np = (Params)n.get(PARAMS);
        this.m_maxDepth = 0;
        this.calcAngularWidth(n, 0);
        if (this.m_autoScale) {
            this.setScale(this.getLayoutBounds());
        }
        if (!this.m_setTheta) {
            this.calcAngularBounds(n);
        }
        if (this.m_maxDepth > 0) {
            this.layout(n, this.m_radiusInc, this.m_theta1, this.m_theta2);
        }
        this.setX(n, null, this.m_origin.getX());
        this.setY(n, null, this.m_origin.getY());
        np.angle = this.m_theta2 - this.m_theta1;
    }

    protected void setScale(Rectangle2D bounds) {
        double r = Math.min(bounds.getWidth(), bounds.getHeight()) / 2.0;
        if (this.m_maxDepth > 0) {
            this.m_radiusInc = (r - 30.0) / (double)this.m_maxDepth;
        }
    }

    private void calcAngularBounds(NodeItem r) {
        Node n;
        NodeItem pp;
        if (this.m_prevRoot == null || !this.m_prevRoot.isValid() || r == this.m_prevRoot) {
            this.m_prevRoot = r;
            return;
        }
        NodeItem p = this.m_prevRoot;
        while ((pp = (NodeItem)p.getParent()) != r) {
            if (pp == null) {
                this.m_prevRoot = r;
                return;
            }
            p = pp;
        }
        double dt = 0.0;
        Iterator iter = this.sortedChildren(r);
        while (iter.hasNext() && (n = (Node)iter.next()) != p) {
            dt += ((Params)n.get((String)PARAMS)).width;
        }
        double rw = ((Params)r.get((String)PARAMS)).width;
        double pw = ((Params)p.get((String)PARAMS)).width;
        dt = Math.PI * -2 * (dt + pw / 2.0) / rw;
        this.m_theta1 = dt + Math.atan2(p.getY() - r.getY(), p.getX() - r.getX());
        this.m_theta2 = this.m_theta1 + Math.PI * 2;
        this.m_prevRoot = r;
    }

    private double calcAngularWidth(NodeItem n, int d) {
        double diameter;
        if (d > this.m_maxDepth) {
            this.m_maxDepth = d;
        }
        double aw = 0.0;
        Rectangle2D bounds = n.getBounds();
        double w = bounds.getWidth();
        double h = bounds.getHeight();
        double d2 = diameter = d == 0 ? 0.0 : Math.sqrt(w * w + h * h) / (double)d;
        if (n.isExpanded() && n.getChildCount() > 0) {
            Iterator childIter = n.children();
            while (childIter.hasNext()) {
                NodeItem c = (NodeItem)childIter.next();
                aw += this.calcAngularWidth(c, d + 1);
            }
            aw = Math.max(diameter, aw);
        } else {
            aw = diameter;
        }
        ((Params)n.get((String)PARAMS)).width = aw;
        return aw;
    }

    private static final double normalize(double angle) {
        while (angle > Math.PI * 2) {
            angle -= Math.PI * 2;
        }
        while (angle < 0.0) {
            angle += Math.PI * 2;
        }
        return angle;
    }

    private Iterator sortedChildren(final NodeItem n) {
        int cc;
        double base = 0.0;
        NodeItem p = (NodeItem)n.getParent();
        if (p != null) {
            base = RadialTreeLayout.normalize(Math.atan2(p.getY() - n.getY(), p.getX() - n.getX()));
        }
        if ((cc = n.getChildCount()) == 0) {
            return null;
        }
        NodeItem c = (NodeItem)n.getFirstChild();
        if (!c.isStartVisible()) {
            return n.children();
        }
        double[] angle = new double[cc];
        final int[] idx = new int[cc];
        int i = 0;
        while (i < cc) {
            idx[i] = i;
            angle[i] = RadialTreeLayout.normalize(-base + Math.atan2(c.getY() - n.getY(), c.getX() - n.getX()));
            ++i;
            c = (NodeItem)c.getNextSibling();
        }
        ArrayLib.sort(angle, idx);
        return new Iterator(){
            int cur = 0;

            public Object next() {
                return n.getChild(idx[this.cur++]);
            }

            public boolean hasNext() {
                return this.cur < idx.length;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected void layout(NodeItem n, double r, double theta1, double theta2) {
        double dtheta = theta2 - theta1;
        double dtheta2 = dtheta / 2.0;
        double width = ((Params)n.get((String)PARAMS)).width;
        double nfrac = 0.0;
        Iterator childIter = this.sortedChildren(n);
        while (childIter != null && childIter.hasNext()) {
            NodeItem c = (NodeItem)childIter.next();
            Params cp = (Params)c.get(PARAMS);
            double cfrac = cp.width / width;
            if (c.isExpanded() && c.getChildCount() > 0) {
                this.layout(c, r + this.m_radiusInc, theta1 + nfrac * dtheta, theta1 + (nfrac + cfrac) * dtheta);
            }
            this.setPolarLocation(c, n, r, theta1 + nfrac * dtheta + cfrac * dtheta2);
            cp.angle = cfrac * dtheta;
            nfrac += cfrac;
        }
    }

    protected void setPolarLocation(NodeItem n, NodeItem p, double r, double t) {
        this.setX(n, p, this.m_origin.getX() + r * Math.cos(t));
        this.setY(n, p, this.m_origin.getY() + r * Math.sin(t));
    }

    protected void initSchema(TupleSet ts) {
        ts.addColumns(PARAMS_SCHEMA);
    }

    static {
        PARAMS_SCHEMA.addColumn(PARAMS, Params.class, new Params());
    }

    public static class Params
    implements Cloneable {
        double width;
        double angle;

        public Object clone() {
            Params p = new Params();
            p.width = this.width;
            p.angle = this.angle;
            return p;
        }
    }
}

