/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.layout;

import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import prefuse.action.layout.Layout;
import prefuse.data.Node;
import prefuse.data.tuple.TupleSet;
import prefuse.visual.VisualItem;

public class GridLayout
extends Layout {
    protected int rows;
    protected int cols;
    protected boolean analyze = false;

    public GridLayout(String group) {
        super(group);
        this.analyze = true;
    }

    public GridLayout(String group, int nrows, int ncols) {
        super(group);
        this.rows = nrows;
        this.cols = ncols;
        this.analyze = false;
    }

    public void run(double frac) {
        Rectangle2D b = this.getLayoutBounds();
        double bx = b.getMinX();
        double by = b.getMinY();
        double w = b.getWidth();
        double h = b.getHeight();
        TupleSet ts = this.m_vis.getGroup(this.m_group);
        int m = this.rows;
        int n = this.cols;
        if (this.analyze) {
            int[] d = GridLayout.analyzeGraphGrid(ts);
            m = d[0];
            n = d[1];
        }
        Iterator iter = ts.tuples();
        for (int i = 0; iter.hasNext() && i < m * n; ++i) {
            VisualItem item = (VisualItem)iter.next();
            item.setVisible(true);
            double x = bx + w * ((double)(i % n) / (double)(n - 1));
            double y = by + h * ((double)(i / n) / (double)(m - 1));
            this.setX(item, null, x);
            this.setY(item, null, y);
        }
        while (iter.hasNext()) {
            VisualItem item = (VisualItem)iter.next();
            item.setVisible(false);
        }
    }

    public static int[] analyzeGraphGrid(TupleSet ts) {
        Node nd;
        Iterator iter = ts.tuples();
        iter.next();
        int n = 2;
        while (iter.hasNext() && (nd = (Node)iter.next()).getDegree() != 2) {
            ++n;
        }
        int m = ts.getTupleCount() / n;
        return new int[]{m, n};
    }

    public int getNumCols() {
        return this.cols;
    }

    public void setNumCols(int cols) {
        this.cols = cols;
    }

    public int getNumRows() {
        return this.rows;
    }

    public void setNumRows(int rows) {
        this.rows = rows;
    }
}

