/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action;

import prefuse.Visualization;
import prefuse.action.Action;
import prefuse.action.ItemAction;
import prefuse.data.expression.Expression;
import prefuse.data.expression.ExpressionVisitor;
import prefuse.data.expression.ObjectLiteral;
import prefuse.data.expression.Predicate;
import prefuse.util.PredicateChain;
import prefuse.visual.VisualItem;

public abstract class EncoderAction
extends ItemAction {
    private PredicateChain m_chain = null;

    public EncoderAction() {
    }

    public EncoderAction(Visualization vis) {
        super(vis);
    }

    public EncoderAction(String group) {
        super(group);
    }

    public EncoderAction(String group, Predicate filter) {
        super(group, filter);
    }

    public EncoderAction(Visualization vis, String group) {
        super(vis, group);
    }

    public EncoderAction(Visualization vis, String group, Predicate filter) {
        super(vis, group, filter);
    }

    protected void add(Predicate p, Object value) {
        if (this.m_chain == null) {
            this.m_chain = new PredicateChain();
        }
        if (value instanceof Action) {
            ((Action)value).setVisualization(this.m_vis);
        }
        this.m_chain.add(p, value);
    }

    protected Object lookup(VisualItem item) {
        return this.m_chain == null ? null : this.m_chain.get(item);
    }

    public void clear() {
        if (this.m_chain != null) {
            this.m_chain.clear();
        }
    }

    public boolean remove(Predicate p) {
        return this.m_chain != null ? this.m_chain.remove(p) : false;
    }

    public void setVisualization(Visualization vis) {
        super.setVisualization(vis);
        if (this.m_chain != null) {
            this.m_chain.getExpression().visit(new SetVisualizationVisitor());
        }
    }

    public void run(double frac) {
        this.setup();
        if (this.m_chain != null) {
            this.m_chain.getExpression().visit(SetupVisitor.getInstance());
        }
        super.run(frac);
        if (this.m_chain != null) {
            this.m_chain.getExpression().visit(FinishVisitor.getInstance());
        }
        this.finish();
    }

    protected void setup() {
    }

    protected void finish() {
    }

    private static class FinishVisitor
    extends ActionVisitor {
        private static FinishVisitor s_instance;

        private FinishVisitor() {
        }

        public static FinishVisitor getInstance() {
            if (s_instance == null) {
                s_instance = new FinishVisitor();
            }
            return s_instance;
        }

        public void visitAction(Action a) {
            if (a instanceof EncoderAction) {
                ((EncoderAction)a).setup();
            }
        }
    }

    private static class SetupVisitor
    extends ActionVisitor {
        private static SetupVisitor s_instance;

        private SetupVisitor() {
        }

        public static SetupVisitor getInstance() {
            if (s_instance == null) {
                s_instance = new SetupVisitor();
            }
            return s_instance;
        }

        public void visitAction(Action a) {
            if (a instanceof EncoderAction) {
                ((EncoderAction)a).setup();
            }
        }
    }

    private class SetVisualizationVisitor
    extends ActionVisitor {
        private SetVisualizationVisitor() {
        }

        public void visitAction(Action a) {
            a.setVisualization(EncoderAction.this.m_vis);
        }
    }

    private static abstract class ActionVisitor
    implements ExpressionVisitor {
        private ActionVisitor() {
        }

        public void visitExpression(Expression expr) {
            Object val;
            if (expr instanceof ObjectLiteral && (val = expr.get(null)) instanceof Action) {
                this.visitAction((Action)val);
            }
        }

        public abstract void visitAction(Action var1);

        public void down() {
        }

        public void up() {
        }
    }
}

