/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.JNITypeParser;
import com.sun.tools.jdi.ObjectReferenceImpl;
import com.sun.tools.jdi.ReferenceTypeImpl;
import com.sun.tools.jdi.VMListener;
import com.sun.tools.jdi.VirtualMachineImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ClassLoaderReferenceImpl
extends ObjectReferenceImpl
implements ClassLoaderReference,
VMListener {
    protected ObjectReferenceImpl.Cache newCache() {
        return new Cache();
    }

    ClassLoaderReferenceImpl(VirtualMachine virtualMachine, long l) {
        super(virtualMachine, l);
        this.vm.state().addListener(this);
    }

    protected String description() {
        return "ClassLoaderReference " + this.uniqueID();
    }

    public List definedClasses() {
        ArrayList<ReferenceType> arrayList = new ArrayList<ReferenceType>();
        for (ReferenceType referenceType : this.vm.allClasses()) {
            if (!referenceType.isPrepared() || !this.equals(referenceType.classLoader())) continue;
            arrayList.add(referenceType);
        }
        return arrayList;
    }

    public List visibleClasses() {
        List list = null;
        try {
            Cache cache = (Cache)this.getCache();
            if (cache != null) {
                list = cache.visibleClasses;
            }
            if (list == null) {
                JDWP.ClassLoaderReference.VisibleClasses.ClassInfo[] classInfoArray = JDWP.ClassLoaderReference.VisibleClasses.process((VirtualMachineImpl)this.vm, (ClassLoaderReferenceImpl)this).classes;
                list = new ArrayList<ReferenceTypeImpl>(classInfoArray.length);
                for (int i = 0; i < classInfoArray.length; ++i) {
                    list.add(this.vm.referenceType(classInfoArray[i].typeID, classInfoArray[i].refTypeTag));
                }
                list = Collections.unmodifiableList(list);
                if (cache != null) {
                    cache.visibleClasses = list;
                    if ((this.vm.traceFlags & 0x10) != 0) {
                        this.vm.printTrace(this.description() + " temporarily caching visible classes (count = " + list.size() + ")");
                    }
                }
            }
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
        return list;
    }

    Type findType(String string) throws ClassNotLoadedException {
        Object object2;
        List list = this.visibleClasses();
        for (Object object2 : list) {
            if (!object2.signature().equals(string)) continue;
            return object2;
        }
        object2 = new JNITypeParser(string);
        throw new ClassNotLoadedException(((JNITypeParser)object2).typeName(), "Class " + ((JNITypeParser)object2).typeName() + " not loaded");
    }

    byte typeValueKey() {
        return 108;
    }

    private static class Cache
    extends ObjectReferenceImpl.Cache {
        List visibleClasses = null;

        private Cache() {
        }
    }
}

