/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beansdev.metadd;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.schema2beansdev.metadd.CommonBean;
import org.netbeans.modules.schema2beansdev.metadd.MetaDD;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MetaProperty
implements CommonBean {
    public static final String BEAN_NAME = "BeanName";
    public static final String DEFAULT_VALUE = "DefaultValue";
    public static final String KNOWN_VALUE = "KnownValue";
    public static final String KEY = "Key";
    public static final String VETOABLE = "Vetoable";
    private String _BeanName;
    private List _DefaultValue = new ArrayList();
    private List _KnownValue = new ArrayList();
    private boolean _Key;
    private boolean _isSet_Key = false;
    private boolean _Vetoable;
    private boolean _isSet_Vetoable = false;

    public MetaProperty() {
        this._BeanName = "";
    }

    public MetaProperty(String beanName) {
        this._BeanName = beanName;
    }

    public MetaProperty(MetaProperty source) {
        this(source, false);
    }

    public MetaProperty(MetaProperty source, boolean justData) {
        String srcElement;
        this._BeanName = source._BeanName;
        Iterator it = source._DefaultValue.iterator();
        while (it.hasNext()) {
            srcElement = (String)it.next();
            this._DefaultValue.add(srcElement);
        }
        it = source._KnownValue.iterator();
        while (it.hasNext()) {
            srcElement = (String)it.next();
            this._KnownValue.add(srcElement);
        }
        this._Key = source._Key;
        this._isSet_Key = source._isSet_Key;
        this._Vetoable = source._Vetoable;
        this._isSet_Vetoable = source._isSet_Vetoable;
    }

    public void setBeanName(String value) {
        this._BeanName = value;
    }

    public String getBeanName() {
        return this._BeanName;
    }

    public void setDefaultValue(String[] value) {
        if (value == null) {
            value = new String[]{};
        }
        this._DefaultValue.clear();
        ((ArrayList)this._DefaultValue).ensureCapacity(value.length);
        for (int i = 0; i < value.length; ++i) {
            this._DefaultValue.add(value[i]);
        }
    }

    public void setDefaultValue(int index, String value) {
        this._DefaultValue.set(index, value);
    }

    public String[] getDefaultValue() {
        String[] arr = new String[this._DefaultValue.size()];
        return this._DefaultValue.toArray(arr);
    }

    public List fetchDefaultValueList() {
        return this._DefaultValue;
    }

    public String getDefaultValue(int index) {
        return (String)this._DefaultValue.get(index);
    }

    public int sizeDefaultValue() {
        return this._DefaultValue.size();
    }

    public int addDefaultValue(String value) {
        this._DefaultValue.add(value);
        int positionOfNewItem = this._DefaultValue.size() - 1;
        return positionOfNewItem;
    }

    public int removeDefaultValue(String value) {
        int pos = this._DefaultValue.indexOf(value);
        if (pos >= 0) {
            this._DefaultValue.remove(pos);
        }
        return pos;
    }

    public void setKnownValue(String[] value) {
        if (value == null) {
            value = new String[]{};
        }
        this._KnownValue.clear();
        ((ArrayList)this._KnownValue).ensureCapacity(value.length);
        for (int i = 0; i < value.length; ++i) {
            this._KnownValue.add(value[i]);
        }
    }

    public void setKnownValue(int index, String value) {
        this._KnownValue.set(index, value);
    }

    public String[] getKnownValue() {
        String[] arr = new String[this._KnownValue.size()];
        return this._KnownValue.toArray(arr);
    }

    public List fetchKnownValueList() {
        return this._KnownValue;
    }

    public String getKnownValue(int index) {
        return (String)this._KnownValue.get(index);
    }

    public int sizeKnownValue() {
        return this._KnownValue.size();
    }

    public int addKnownValue(String value) {
        this._KnownValue.add(value);
        int positionOfNewItem = this._KnownValue.size() - 1;
        return positionOfNewItem;
    }

    public int removeKnownValue(String value) {
        int pos = this._KnownValue.indexOf(value);
        if (pos >= 0) {
            this._KnownValue.remove(pos);
        }
        return pos;
    }

    public void setKey(boolean value) {
        this._Key = value;
        this._isSet_Key = true;
    }

    public boolean isKey() {
        return this._Key;
    }

    public void setVetoable(boolean value) {
        this._Vetoable = value;
        this._isSet_Vetoable = true;
    }

    public boolean isVetoable() {
        return this._Vetoable;
    }

    public void writeNode(Writer out) throws IOException {
        String myName = "meta-property";
        this.writeNode(out, myName, "");
    }

    public void writeNode(Writer out, String nodeName, String indent) throws IOException {
        this.writeNode(out, nodeName, null, indent, new HashMap());
    }

    public void writeNode(Writer out, String nodeName, String namespace, String indent, Map namespaceMap) throws IOException {
        String element;
        out.write(indent);
        out.write("<");
        if (namespace != null) {
            out.write((String)namespaceMap.get(namespace));
            out.write(":");
        }
        out.write(nodeName);
        out.write(">\n");
        String nextIndent = indent + "\t";
        if (this._BeanName != null) {
            out.write(nextIndent);
            out.write("<bean-name");
            out.write(">");
            MetaDD.writeXML(out, this._BeanName, false);
            out.write("</bean-name>\n");
        }
        Iterator it = this._DefaultValue.iterator();
        while (it.hasNext()) {
            element = (String)it.next();
            if (element == null) continue;
            out.write(nextIndent);
            out.write("<default-value");
            out.write(">");
            MetaDD.writeXML(out, element, false);
            out.write("</default-value>\n");
        }
        it = this._KnownValue.iterator();
        while (it.hasNext()) {
            element = (String)it.next();
            if (element == null) continue;
            out.write(nextIndent);
            out.write("<known-value");
            out.write(">");
            MetaDD.writeXML(out, element, false);
            out.write("</known-value>\n");
        }
        if (this._isSet_Key && this._Key) {
            out.write(nextIndent);
            out.write("<key");
            out.write("/>\n");
        }
        if (this._isSet_Vetoable && this._Vetoable) {
            out.write(nextIndent);
            out.write("<vetoable");
            out.write("/>\n");
        }
        out.write(indent);
        out.write("</");
        if (namespace != null) {
            out.write((String)namespaceMap.get(namespace));
            out.write(":");
        }
        out.write(nodeName);
        out.write(">\n");
    }

    public void readNode(Node node) {
        this.readNode(node, new HashMap());
    }

    public void readNode(Node node, Map namespacePrefixes) {
        if (node.hasAttributes()) {
            NamedNodeMap attrs = node.getAttributes();
            boolean firstNamespaceDef = true;
            for (int attrNum = 0; attrNum < attrs.getLength(); ++attrNum) {
                Attr attr = (Attr)attrs.item(attrNum);
                String attrName = attr.getName();
                if (!attrName.startsWith("xmlns:")) continue;
                if (firstNamespaceDef) {
                    firstNamespaceDef = false;
                    namespacePrefixes = new HashMap<String, String>(namespacePrefixes);
                }
                String attrNSPrefix = attrName.substring(6, attrName.length());
                namespacePrefixes.put(attrNSPrefix, attr.getValue());
            }
        }
        NodeList children = node.getChildNodes();
        int size = children.getLength();
        for (int i = 0; i < size; ++i) {
            Node childNode = children.item(i);
            String childNodeName = childNode.getLocalName() == null ? childNode.getNodeName().intern() : childNode.getLocalName().intern();
            String childNodeValue = "";
            if (childNode.getFirstChild() != null) {
                childNodeValue = childNode.getFirstChild().getNodeValue();
            }
            if (childNodeName == "bean-name") {
                this._BeanName = childNodeValue;
                continue;
            }
            if (childNodeName == "default-value") {
                String aDefaultValue = childNodeValue;
                this._DefaultValue.add(aDefaultValue);
                continue;
            }
            if (childNodeName == "known-value") {
                String aKnownValue = childNodeValue;
                this._KnownValue.add(aKnownValue);
                continue;
            }
            if (childNodeName == "key") {
                this._Key = childNode.getFirstChild() == null ? true : Boolean.valueOf(childNodeValue);
                this._isSet_Key = true;
                continue;
            }
            if (childNodeName != "vetoable") continue;
            this._Vetoable = childNode.getFirstChild() == null ? true : Boolean.valueOf(childNodeValue);
            this._isSet_Vetoable = true;
        }
    }

    public void validate() throws MetaDD.ValidateException {
        boolean restrictionFailure = false;
        boolean restrictionPassed = false;
        if (this.getBeanName() == null) {
            throw new MetaDD.ValidateException("getBeanName() == null", MetaDD.ValidateException.FailureType.NULL_VALUE, "beanName", this);
        }
    }

    public void changePropertyByName(String name, Object value) {
        if (name == null) {
            return;
        }
        if ((name = name.intern()) == "beanName") {
            this.setBeanName((String)value);
        } else if (name == "defaultValue") {
            this.addDefaultValue((String)value);
        } else if (name == "defaultValue[]") {
            this.setDefaultValue((String[])value);
        } else if (name == "knownValue") {
            this.addKnownValue((String)value);
        } else if (name == "knownValue[]") {
            this.setKnownValue((String[])value);
        } else if (name == "key") {
            this.setKey((Boolean)value);
        } else if (name == "vetoable") {
            this.setVetoable((Boolean)value);
        } else {
            throw new IllegalArgumentException(name + " is not a valid property name for MetaProperty");
        }
    }

    public Object fetchPropertyByName(String name) {
        if (name == "beanName") {
            return this.getBeanName();
        }
        if (name == "defaultValue[]") {
            return this.getDefaultValue();
        }
        if (name == "knownValue[]") {
            return this.getKnownValue();
        }
        if (name == "key") {
            return this.isKey() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name == "vetoable") {
            return this.isVetoable() ? Boolean.TRUE : Boolean.FALSE;
        }
        throw new IllegalArgumentException(name + " is not a valid property name for MetaProperty");
    }

    public String nameSelf() {
        return "MetaProperty";
    }

    public String nameChild(Object childObj) {
        return this.nameChild(childObj, false, false);
    }

    public String nameChild(Object childObj, boolean returnConstName, boolean returnSchemaName) {
        return this.nameChild(childObj, returnConstName, returnSchemaName, false);
    }

    public String nameChild(Object childObj, boolean returnConstName, boolean returnSchemaName, boolean returnXPathName) {
        Object child;
        if (childObj instanceof String) {
            String element;
            child = (String)childObj;
            if (child == this._BeanName) {
                if (returnConstName) {
                    return BEAN_NAME;
                }
                if (returnSchemaName) {
                    return "bean-name";
                }
                if (returnXPathName) {
                    return "bean-name";
                }
                return BEAN_NAME;
            }
            int index = 0;
            Iterator it = this._DefaultValue.iterator();
            while (it.hasNext()) {
                element = (String)it.next();
                if (child == element) {
                    if (returnConstName) {
                        return DEFAULT_VALUE;
                    }
                    if (returnSchemaName) {
                        return "default-value";
                    }
                    if (returnXPathName) {
                        return "default-value[position()=" + index + "]";
                    }
                    return "DefaultValue." + Integer.toHexString(index);
                }
                ++index;
            }
            index = 0;
            it = this._KnownValue.iterator();
            while (it.hasNext()) {
                element = (String)it.next();
                if (child == element) {
                    if (returnConstName) {
                        return KNOWN_VALUE;
                    }
                    if (returnSchemaName) {
                        return "known-value";
                    }
                    if (returnXPathName) {
                        return "known-value[position()=" + index + "]";
                    }
                    return "KnownValue." + Integer.toHexString(index);
                }
                ++index;
            }
        }
        if (childObj instanceof Boolean) {
            child = (Boolean)childObj;
            if ((Boolean)child == this._Key) {
                if (returnConstName) {
                    return KEY;
                }
                if (returnSchemaName) {
                    return "key";
                }
                if (returnXPathName) {
                    return "key";
                }
                return KEY;
            }
            if ((Boolean)child == this._Vetoable) {
                if (returnConstName) {
                    return VETOABLE;
                }
                if (returnSchemaName) {
                    return "vetoable";
                }
                if (returnXPathName) {
                    return "vetoable";
                }
                return VETOABLE;
            }
        }
        return null;
    }

    public CommonBean[] childBeans(boolean recursive) {
        LinkedList children = new LinkedList();
        this.childBeans(recursive, children);
        CommonBean[] result = new CommonBean[children.size()];
        return children.toArray(result);
    }

    public void childBeans(boolean recursive, List beans) {
    }

    public boolean equals(Object o) {
        return o instanceof MetaProperty && this.equals((MetaProperty)o);
    }

    public boolean equals(MetaProperty inst) {
        String element2;
        String element;
        if (inst == this) {
            return true;
        }
        if (inst == null) {
            return false;
        }
        if (!(this._BeanName != null ? this._BeanName.equals(inst._BeanName) : inst._BeanName == null)) {
            return false;
        }
        if (this.sizeDefaultValue() != inst.sizeDefaultValue()) {
            return false;
        }
        Iterator it = this._DefaultValue.iterator();
        Iterator it2 = inst._DefaultValue.iterator();
        while (it.hasNext() && it2.hasNext()) {
            element = (String)it.next();
            element2 = (String)it2.next();
            if (element != null ? element.equals(element2) : element2 == null) continue;
            return false;
        }
        if (this.sizeKnownValue() != inst.sizeKnownValue()) {
            return false;
        }
        it = this._KnownValue.iterator();
        it2 = inst._KnownValue.iterator();
        while (it.hasNext() && it2.hasNext()) {
            element = (String)it.next();
            element2 = (String)it2.next();
            if (element != null ? element.equals(element2) : element2 == null) continue;
            return false;
        }
        if (this._isSet_Key != inst._isSet_Key) {
            return false;
        }
        if (this._isSet_Key && this._Key != inst._Key) {
            return false;
        }
        if (this._isSet_Vetoable != inst._isSet_Vetoable) {
            return false;
        }
        return !this._isSet_Vetoable || this._Vetoable == inst._Vetoable;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this._BeanName == null ? 0 : this._BeanName.hashCode());
        result = 37 * result + (this._DefaultValue == null ? 0 : ((Object)this._DefaultValue).hashCode());
        result = 37 * result + (this._KnownValue == null ? 0 : ((Object)this._KnownValue).hashCode());
        result = 37 * result + (this._isSet_Key ? 0 : (this._Key ? 0 : 1));
        result = 37 * result + (this._isSet_Vetoable ? 0 : (this._Vetoable ? 0 : 1));
        return result;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        try {
            this.writeNode(sw);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sw.toString();
    }
}

