/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4cics.webservices.utils.generators;

import it.imolinfo.jbi4cics.Logger;
import it.imolinfo.jbi4cics.LoggerFactory;
import it.imolinfo.jbi4cics.exception.ClassGenerationException;
import it.imolinfo.jbi4cics.jbi.BCELClassLoader;
import it.imolinfo.jbi4cics.webservices.descriptor.ServiceDescriptor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class ServiceInterfaceGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceInterfaceGenerator.class);
    private final String completeClassName;
    private final ServiceDescriptor serviceDescriptor;

    public ServiceInterfaceGenerator(ServiceDescriptor serviceDescriptor) {
        this.completeClassName = serviceDescriptor.getServiceInterfacePackageName() + "." + serviceDescriptor.getServiceInterfaceName();
        this.serviceDescriptor = serviceDescriptor;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Complete interface name: " + this.completeClassName);
        }
    }

    public Class generateServiceInterface(BCELClassLoader loader) throws ClassGenerationException {
        Class<?> clazz;
        ClassWriter cw = new ClassWriter(true);
        String internalClassName = this.completeClassName.replace('.', '/');
        String returnType = Type.getDescriptor((Class)this.serviceDescriptor.getOutputBean());
        String paramType = Type.getDescriptor((Class)this.serviceDescriptor.getInputBean());
        cw.visit(196653, 1537, internalClassName, null, "java/lang/Object", null);
        MethodVisitor mv = cw.visitMethod(1025, this.serviceDescriptor.getOperationName(), "(" + paramType + ")" + returnType, null, null);
        mv.visitEnd();
        loader.addClass(this.completeClassName, cw.toByteArray());
        try {
            clazz = loader.loadClass(this.completeClassName);
        }
        catch (ClassNotFoundException e) {
            Object[] args = new Object[]{this.completeClassName};
            LOG.error("CIC002400_Class_generation_error", args, e);
            throw new ClassGenerationException("CIC002400_Class_generation_error", args, e);
        }
        this.serviceDescriptor.setServiceInterface(clazz);
        return clazz;
    }
}

