/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4cics.webservices.utils.generators;

import it.imolinfo.jbi4cics.Logger;
import it.imolinfo.jbi4cics.LoggerFactory;
import it.imolinfo.jbi4cics.exception.ClassGenerationException;
import it.imolinfo.jbi4cics.exception.FormatException;
import it.imolinfo.jbi4cics.jbi.BCELClassLoader;
import it.imolinfo.jbi4cics.messageformat.FieldDescriptor;
import it.imolinfo.jbi4cics.messageformat.MappingDescriptor;
import it.imolinfo.jbi4cics.typemapping.cobol.CobolType;
import it.imolinfo.jbi4cics.typemapping.cobol.CobolTypeDescriptor;
import it.imolinfo.jbi4cics.webservices.descriptor.ServiceDescriptor;
import java.util.Map;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class ServiceBeanGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceBeanGenerator.class);
    private final String completeClassName;
    private final String internalClassName;
    private final MappingDescriptor mappingDescriptor;
    private final ClassWriter classWriter = new ClassWriter(true);

    public ServiceBeanGenerator(ServiceDescriptor desc, boolean input) {
        this(desc.getServiceInterfacePackageName() + "." + (input ? desc.getInputBeanClassName() : desc.getOutputBeanClassName()), input ? desc.getInputMappingDescriptor() : desc.getOutputMappingDescriptor());
    }

    private ServiceBeanGenerator(String completeClassName, MappingDescriptor mappingDescriptor) {
        this.completeClassName = completeClassName;
        this.mappingDescriptor = mappingDescriptor;
        this.internalClassName = completeClassName.replace('.', '/');
        this.classWriter.visit(196653, 33, this.internalClassName, null, "java/lang/Object", null);
    }

    public Class generateBeanClass(BCELClassLoader loader) throws ClassGenerationException {
        Class<?> clazz;
        boolean debug = LOG.isDebugEnabled();
        this.addDefaultConstructor();
        this.addToStringMethod();
        this.addEqualsMethod();
        this.addHashCodeMethod();
        try {
            Map<String, FieldDescriptor> fields = this.mappingDescriptor.getFieldMap();
            for (Map.Entry<String, FieldDescriptor> entry : fields.entrySet()) {
                CobolTypeDescriptor cobolTypeDescriptor;
                CobolType cobolType;
                String propertyName = entry.getKey();
                FieldDescriptor fieldDescriptor = entry.getValue();
                if (fieldDescriptor instanceof CobolTypeDescriptor && ((cobolType = (cobolTypeDescriptor = (CobolTypeDescriptor)fieldDescriptor).getType()) == CobolType.NESTED_COMMAREA || cobolType == CobolType.OCCURS)) {
                    String innerClassName = this.completeClassName.substring(0, this.completeClassName.lastIndexOf(46) + 1) + propertyName;
                    ServiceBeanGenerator inner = new ServiceBeanGenerator(innerClassName, cobolTypeDescriptor.getNestedCommarea());
                    inner.generateBeanClass(loader);
                }
                if (debug) {
                    LOG.debug("handling property name: " + propertyName);
                }
                Type type = Type.getType((Class)fieldDescriptor.getPreferredJavaType());
                this.addPrivateField(propertyName, type);
                this.addSetMethod(propertyName, type);
                this.addGetMethod(propertyName, type);
            }
        }
        catch (FormatException e) {
            Object[] args = new Object[]{this.completeClassName};
            LOG.error("CIC002400_Class_generation_error", args, e);
            throw new ClassGenerationException("CIC002400_Class_generation_error", args, e);
        }
        loader.addClass(this.completeClassName, this.classWriter.toByteArray());
        try {
            clazz = loader.loadClass(this.completeClassName);
        }
        catch (ClassNotFoundException e) {
            Object[] args = new Object[]{this.completeClassName};
            LOG.error("CIC002400_Class_generation_error", args, e);
            throw new ClassGenerationException("CIC002400_Class_generation_error", args, e);
        }
        this.mappingDescriptor.setBeanClass(clazz);
        return clazz;
    }

    private void addDefaultConstructor() {
        MethodVisitor mv = this.classWriter.visitMethod(1, "<init>", "()V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private void addToStringMethod() {
        MethodVisitor mv = this.classWriter.visitMethod(1, "toString", "()Ljava/lang/String;", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "org/apache/commons/lang/builder/ReflectionToStringBuilder", "toString", "(Ljava/lang/Object;)Ljava/lang/String;");
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void addEqualsMethod() {
        MethodVisitor mv = this.classWriter.visitMethod(1, "equals", "(Ljava/lang/Object;)Z", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(184, "org/apache/commons/lang/builder/EqualsBuilder", "reflectionEquals", "(Ljava/lang/Object;Ljava/lang/Object;)Z");
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void addHashCodeMethod() {
        MethodVisitor mv = this.classWriter.visitMethod(1, "hashCode", "()I", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "org/apache/commons/lang/builder/HashCodeBuilder", "reflectionHashCode", "(Ljava/lang/Object;)I");
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void addPrivateField(String fieldName, Type fieldType) {
        FieldVisitor fv = this.classWriter.visitField(2, fieldName, fieldType.getDescriptor(), null, null);
        fv.visitEnd();
    }

    private void addGetMethod(String propertyName, Type propertyType) {
        StringBuilder methodName = new StringBuilder(propertyName);
        String returnType = propertyType.getDescriptor();
        methodName.setCharAt(0, Character.toUpperCase(methodName.charAt(0)));
        methodName.insert(0, "get");
        MethodVisitor mv = this.classWriter.visitMethod(1, methodName.toString(), "()".concat(returnType), null, null);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.internalClassName, propertyName, returnType);
        mv.visitInsn(propertyType.getOpcode(172));
        mv.visitMaxs(0, 0);
    }

    private void addSetMethod(String propertyName, Type propertyType) {
        StringBuilder methodName = new StringBuilder(propertyName);
        String desc = propertyType.getDescriptor();
        methodName.setCharAt(0, Character.toUpperCase(methodName.charAt(0)));
        methodName.insert(0, "set");
        MethodVisitor mv = this.classWriter.visitMethod(1, methodName.toString(), "(" + desc + ")V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(propertyType.getOpcode(21), 1);
        mv.visitFieldInsn(181, this.internalClassName, propertyName, desc);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
    }
}

